/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.descriptors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class ElementDescriptor
implements Comparable<ElementDescriptor> {
    private static final String ELEMENT_ICON_FILENAME = "element";
    protected final String mXmlName;
    private final String mUiName;
    private AttributeDescriptor[] mAttributes;
    private ElementDescriptor[] mChildren;
    private String mTooltip;
    private String mSdkUrl;
    private final Mandatory mMandatory;

    public ElementDescriptor(String xml_name, String ui_name, String tooltip, String sdk_url, AttributeDescriptor[] attributes, ElementDescriptor[] children, Mandatory mandatory) {
        this.mMandatory = mandatory;
        this.mXmlName = xml_name;
        this.mUiName = ui_name;
        this.mTooltip = tooltip != null && tooltip.length() > 0 ? tooltip : null;
        this.mSdkUrl = sdk_url != null && sdk_url.length() > 0 ? sdk_url : null;
        this.setAttributes(attributes != null ? attributes : new AttributeDescriptor[]{});
        this.mChildren = children != null ? children : new ElementDescriptor[]{};
    }

    public ElementDescriptor(String xml_name, String ui_name, String tooltip, String sdk_url, AttributeDescriptor[] attributes, ElementDescriptor[] children, boolean mandatory) {
        this.mMandatory = mandatory ? Mandatory.MANDATORY : Mandatory.NOT_MANDATORY;
        this.mXmlName = xml_name;
        this.mUiName = ui_name;
        this.mTooltip = tooltip != null && tooltip.length() > 0 ? tooltip : null;
        this.mSdkUrl = sdk_url != null && sdk_url.length() > 0 ? sdk_url : null;
        this.setAttributes(attributes != null ? attributes : new AttributeDescriptor[]{});
        this.mChildren = children != null ? children : new ElementDescriptor[]{};
    }

    public ElementDescriptor(String xml_name, ElementDescriptor[] children, Mandatory mandatory) {
        this(xml_name, ElementDescriptor.prettyName(xml_name), null, null, null, children, mandatory);
    }

    public ElementDescriptor(String xml_name, ElementDescriptor[] children) {
        this(xml_name, ElementDescriptor.prettyName(xml_name), null, null, null, children, false);
    }

    public ElementDescriptor(String xml_name) {
        this(xml_name, ElementDescriptor.prettyName(xml_name), null, null, null, null, false);
    }

    public Mandatory getMandatory() {
        return this.mMandatory;
    }

    public String toString() {
        return String.format("%s [%s, attr %d, children %d%s]", this.getClass().getSimpleName(), this.mXmlName, this.mAttributes != null ? this.mAttributes.length : 0, this.mChildren != null ? this.mChildren.length : 0, this.mMandatory != Mandatory.NOT_MANDATORY ? ", " + this.mMandatory.toString() : "");
    }

    public final String getXmlLocalName() {
        int pos = this.mXmlName.indexOf(58);
        if (pos != -1) {
            return this.mXmlName.substring(pos + 1);
        }
        return this.mXmlName;
    }

    public String getXmlName() {
        return this.mXmlName;
    }

    public final String getNamespace() {
        if (this.mXmlName.startsWith("android:")) {
            return "http://schemas.android.com/apk/res/android";
        }
        return "";
    }

    public String getUiName() {
        return this.mUiName;
    }

    public Image getGenericIcon() {
        return IconFactory.getInstance().getIcon(ELEMENT_ICON_FILENAME);
    }

    public Image getCustomizedIcon() {
        Image icon;
        IconFactory factory = IconFactory.getInstance();
        int color = this.hasChildren() ? 10 : 6;
        int shape = this.hasChildren() ? 82 : 67;
        String name = this.mXmlName;
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(pos + 1);
        }
        if ((icon = factory.getIcon(name, color, shape)) == null) {
            icon = this.getGenericIcon();
        }
        if (icon == null) {
            icon = AndmoreAndroidPlugin.getAndroidLogo();
        }
        return icon;
    }

    public ImageDescriptor getImageDescriptor() {
        IconFactory factory = IconFactory.getInstance();
        int color = this.hasChildren() ? 10 : 6;
        int shape = this.hasChildren() ? 82 : 67;
        ImageDescriptor id = factory.getImageDescriptor(this.mXmlName, color, shape);
        return id != null ? id : AndmoreAndroidPlugin.getAndroidLogoDesc();
    }

    public AttributeDescriptor[] getAttributes() {
        return this.mAttributes;
    }

    public void setAttributes(AttributeDescriptor[] attributes) {
        this.mAttributes = attributes;
        AttributeDescriptor[] attributeDescriptorArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attribute = attributeDescriptorArray[n2];
            attribute.setParent(this);
            ++n2;
        }
    }

    public ElementDescriptor[] getChildren() {
        return this.mChildren;
    }

    public boolean hasChildren() {
        return this.mChildren.length > 0;
    }

    public boolean acceptChild(ElementDescriptor target) {
        if (target != null && this.mChildren.length > 0) {
            String targetXmlName = target.getXmlName();
            ElementDescriptor[] elementDescriptorArray = this.mChildren;
            int n = this.mChildren.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor child = elementDescriptorArray[n2];
                if (child.getXmlName().equals(targetXmlName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setChildren(ElementDescriptor[] newChildren) {
        this.mChildren = newChildren;
    }

    public void setChildren(Collection<ElementDescriptor> newChildren) {
        this.setChildren(newChildren.toArray(new ElementDescriptor[newChildren.size()]));
    }

    public String getTooltip() {
        return this.mTooltip;
    }

    public String getSdkUrl() {
        return this.mSdkUrl;
    }

    public void setTooltip(String tooltip) {
        this.mTooltip = tooltip;
    }

    public void setSdkUrl(String sdkUrl) {
        this.mSdkUrl = sdkUrl;
    }

    public UiElementNode createUiNode() {
        return new UiElementNode(this);
    }

    public ElementDescriptor findChildrenDescriptor(String element_name, boolean recursive) {
        return this.findChildrenDescriptorInternal(element_name, recursive, null);
    }

    private ElementDescriptor findChildrenDescriptorInternal(String element_name, boolean recursive, Set<ElementDescriptor> visited) {
        ElementDescriptor e;
        if (recursive && visited == null) {
            visited = new HashSet<ElementDescriptor>();
        }
        ElementDescriptor[] elementDescriptorArray = this.getChildren();
        int n = elementDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            e = elementDescriptorArray[n2];
            if (e.getXmlName().equals(element_name)) {
                return e;
            }
            ++n2;
        }
        if (visited != null) {
            visited.add(this);
        }
        if (recursive) {
            elementDescriptorArray = this.getChildren();
            n = elementDescriptorArray.length;
            n2 = 0;
            while (n2 < n) {
                ElementDescriptor f;
                e = elementDescriptorArray[n2];
                if ((visited == null || visited.add(e)) && (f = e.findChildrenDescriptorInternal(element_name, recursive, visited)) != null) {
                    return f;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String prettyName(String xml_name) {
        char[] c = xml_name.toCharArray();
        if (c.length > 0) {
            c[0] = Character.toUpperCase(c[0]);
        }
        return new String(c).replace("-", " ");
    }

    public boolean definesAttribute(String namespaceUri, String attributeName) {
        AttributeDescriptor[] attributeDescriptorArray = this.mAttributes;
        int n = this.mAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor desc = attributeDescriptorArray[n2];
            if (desc.getXmlLocalName().equals(attributeName) && desc.getNamespaceUri().equals(namespaceUri)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public int compareTo(ElementDescriptor o) {
        return this.mUiName.compareToIgnoreCase(o.mUiName);
    }

    public boolean syncAttributes() {
        return true;
    }

    public static enum Mandatory {
        NOT_MANDATORY,
        MANDATORY,
        MANDATORY_LAST;

    }
}

