/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout;

import com.android.ide.common.rendering.api.ActionBarCallback;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.w3c.dom.Element;

public class ActionBarHandler
extends ActionBarCallback {
    private final GraphicalEditorPart mEditor;

    ActionBarHandler(GraphicalEditorPart editor) {
        this.mEditor = editor;
    }

    public List<String> getMenuIdNames() {
        String commaSeparatedMenus = this.getXmlAttribute("menu");
        ArrayList<String> menus = new ArrayList<String>();
        Iterables.addAll(menus, (Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)commaSeparatedMenus));
        return menus;
    }

    public boolean getSplitActionBarWhenNarrow() {
        ManifestInfo.ActivityAttributes attributes = this.getActivityAttributes();
        if (attributes != null) {
            return "splitActionBarWhenNarrow".equals(attributes.getUiOptions());
        }
        return false;
    }

    public int getNavigationMode() {
        String navMode = this.getXmlAttribute("actionBarNavMode");
        if (navMode.equalsIgnoreCase("tabs")) {
            return 2;
        }
        if (navMode.equalsIgnoreCase("list")) {
            return 1;
        }
        return 0;
    }

    public ActionBarCallback.HomeButtonStyle getHomeButtonStyle() {
        ManifestInfo.ActivityAttributes attributes = this.getActivityAttributes();
        if (attributes != null && attributes.getParentActivity() != null) {
            return ActionBarCallback.HomeButtonStyle.SHOW_HOME_AS_UP;
        }
        return ActionBarCallback.HomeButtonStyle.NONE;
    }

    private ManifestInfo.ActivityAttributes getActivityAttributes() {
        ManifestInfo manifest = ManifestInfo.get(this.mEditor.getProject());
        String activity = this.mEditor.getConfigurationChooser().getConfiguration().getActivity();
        return manifest.getActivityAttributes(activity);
    }

    private String getXmlAttribute(String name) {
        Element element = this.mEditor.getModel().getUiRoot().getXmlDocument().getDocumentElement();
        String value = element.getAttributeNS("http://schemas.android.com/tools", name);
        if (value == null) {
            return "";
        }
        return value.trim();
    }
}

