/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.AndroidContentAssist;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.descriptors.CustomViewDescriptorService;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.CustomViewFinder;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.w3c.dom.Node;

public final class LayoutContentAssist
extends AndroidContentAssist {
    public LayoutContentAssist() {
        super(2);
    }

    @Override
    protected Object[] getChoicesForElement(String parent, Node currentNode) {
        List<ElementDescriptor> descriptors;
        String parentName;
        Object[] choices = super.getChoicesForElement(parent, currentNode);
        if (choices == null && currentNode.getParentNode().getNodeType() == 1 && (parentName = currentNode.getParentNode().getNodeName()).indexOf(46) != -1) {
            ElementDescriptor[] children;
            ElementDescriptor[] elementDescriptorArray = children = this.getRootDescriptor().getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ElementDescriptor e = elementDescriptorArray[n2];
                if (e.getXmlName().startsWith(parent)) {
                    return LayoutContentAssist.sort(children);
                }
                ++n2;
            }
        }
        if (choices == null && parent.length() >= 1 && Character.isLowerCase(parent.charAt(0)) && (descriptors = this.getCustomViews()) != null && !descriptors.isEmpty()) {
            ArrayList matches = Lists.newArrayList();
            for (ElementDescriptor descriptor : descriptors) {
                if (!descriptor.getXmlLocalName().startsWith(parent)) continue;
                matches.add(descriptor);
            }
            if (!matches.isEmpty()) {
                return matches.toArray(new ElementDescriptor[matches.size()]);
            }
        }
        return choices;
    }

    @Override
    protected ElementDescriptor[] getElementChoicesForTextNode(Node parentNode) {
        Object[] choices = super.getElementChoicesForTextNode(parentNode);
        List<ElementDescriptor> descriptors = this.getCustomViews();
        if (descriptors != null && !descriptors.isEmpty()) {
            Object[] array = descriptors.toArray(new ElementDescriptor[descriptors.size()]);
            choices = (ElementDescriptor[])ObjectArrays.concat((Object[])choices, (Object[])array, ElementDescriptor.class);
            choices = LayoutContentAssist.sort((ElementDescriptor[])choices);
        }
        return choices;
    }

    private List<ElementDescriptor> getCustomViews() {
        IProject project = this.mEditor.getProject();
        CustomViewFinder finder = CustomViewFinder.get(project);
        Collection<String> views = finder.getAllViews();
        if (views == null) {
            finder.refresh();
            views = finder.getAllViews();
        }
        if (views != null && !views.isEmpty()) {
            ArrayList descriptors = Lists.newArrayListWithExpectedSize((int)views.size());
            CustomViewDescriptorService customViews = CustomViewDescriptorService.getInstance();
            for (String fqcn : views) {
                ViewElementDescriptor descriptor = customViews.getDescriptor(project, fqcn);
                if (descriptor == null) continue;
                descriptors.add(descriptor);
            }
            return descriptors;
        }
        return null;
    }

    @Override
    protected boolean computeAttributeValues(List<ICompletionProposal> proposals, int offset, String parentTagName, String attributeName, Node node, String wordPrefix, boolean skipEndTag, int replaceLength) {
        super.computeAttributeValues(proposals, offset, parentTagName, attributeName, node, wordPrefix, skipEndTag, replaceLength);
        boolean projectOnly = false;
        List<String> superClasses = null;
        if ("fragment".equals(parentTagName) && (attributeName.endsWith("name") || attributeName.equals("class"))) {
            superClasses = Arrays.asList("android.support.v4.app.Fragment", "android.app.Fragment");
        } else if ("view".equals(parentTagName) && attributeName.endsWith("class")) {
            superClasses = Collections.singletonList("android.view.View");
            projectOnly = true;
        } else if (attributeName.endsWith("context")) {
            superClasses = Collections.singletonList("android.app.Activity");
        }
        if (superClasses != null) {
            IProject project = this.mEditor.getProject();
            if (project == null) {
                return false;
            }
            try {
                IType subType;
                int n;
                int n2;
                IType[] iTypeArray;
                IType[] allSubtypes;
                ITypeHierarchy hierarchy;
                IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
                IType type = javaProject.findType(superClasses.get(0));
                HashSet<IType> elements = new HashSet<IType>();
                if (type != null) {
                    hierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    iTypeArray = allSubtypes = hierarchy.getAllSubtypes(type);
                    n2 = allSubtypes.length;
                    n = 0;
                    while (n < n2) {
                        subType = iTypeArray[n];
                        if (!projectOnly || subType.getResource() != null) {
                            elements.add(subType);
                        }
                        ++n;
                    }
                }
                assert (superClasses.size() <= 2);
                if (superClasses.size() == 2 && (type = javaProject.findType(superClasses.get(1))) != null) {
                    hierarchy = type.newTypeHierarchy((IProgressMonitor)new NullProgressMonitor());
                    iTypeArray = allSubtypes = hierarchy.getAllSubtypes(type);
                    n2 = allSubtypes.length;
                    n = 0;
                    while (n < n2) {
                        subType = iTypeArray[n];
                        if (!projectOnly || subType.getResource() != null) {
                            elements.add(subType);
                        }
                        ++n;
                    }
                }
                ArrayList sorted = new ArrayList(elements);
                Collections.sort(sorted, new Comparator<IType>(){

                    @Override
                    public int compare(IType type1, IType type2) {
                        int category2;
                        String fqcn1 = type1.getFullyQualifiedName();
                        String fqcn2 = type2.getFullyQualifiedName();
                        int category1 = fqcn1.startsWith("android.") ? 1 : -1;
                        int n = category2 = fqcn2.startsWith("android.") ? 1 : -1;
                        if (category1 != category2) {
                            return category1 - category2;
                        }
                        return fqcn1.compareTo(fqcn2);
                    }
                });
                this.addMatchingProposals(proposals, sorted.toArray(), offset, node, wordPrefix, '\u0000', false, false, false, replaceLength);
                return true;
            }
            catch (CoreException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
        }
        return false;
    }
}

