/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.configuration;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;

public class FlagManager {
    private static final FlagManager sInstance = new FlagManager();
    private Map<String, Image> mImageMap = Maps.newHashMap();

    public static FlagManager get() {
        return sInstance;
    }

    private FlagManager() {
    }

    public static Image getEmptyIcon() {
        return DesignerPlugin.getImage((String)"nls/flags/flag_empty.png");
    }

    public static Image getGlobeIcon() {
        return IconFactory.getInstance().getIcon("globe");
    }

    public Image getFlag(String language, String region) {
        assert (region != null || language != null);
        if (region == null || region.isEmpty()) {
            Image flag;
            assert (language != null);
            Locale locale = Locale.getDefault();
            if (language.equals(locale.getLanguage()) && (flag = this.getFlag(locale.getCountry())) != null) {
                return flag;
            }
            region = language.equals("ca") ? "catalonia" : (language.equals("gd") ? "scotland" : (language.equals("cy") ? "wales" : LocaleManager.getLanguageRegion((String)language)));
        }
        if (region == null || region.isEmpty()) {
            return null;
        }
        return this.getIcon(region);
    }

    public Image getFlag(LocaleQualifier locale) {
        String languageCode = locale != null && locale.hasLanguage() ? locale.getLanguage() : null;
        String regionCode = locale != null && locale.hasRegion() ? locale.getRegion() : null;
        return this.getFlag(languageCode, regionCode);
    }

    public Image getFlagForFolderName(String folder) {
        LocaleQualifier locale = FolderConfiguration.getConfigForFolder((String)folder).getLocaleQualifier();
        if (locale != null) {
            return FlagManager.get().getFlag(locale);
        }
        return null;
    }

    public Image getFlag(String region) {
        assert (region.length() == 2 && Character.isUpperCase(region.charAt(0)) && Character.isUpperCase(region.charAt(1))) : region;
        return this.getIcon(region);
    }

    private Image getIcon(String base) {
        Image flagImage = this.mImageMap.get(base);
        if (flagImage == null) {
            if (this.mImageMap.containsKey(base)) {
                return null;
            }
            String flagFileName = String.valueOf(base.toLowerCase(Locale.US)) + ".png";
            flagImage = DesignerPlugin.getImage((String)("nls/flags/" + flagFileName));
            this.mImageMap.put(base, flagImage);
        }
        return flagImage;
    }
}

