/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.configuration;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import org.eclipse.andmore.internal.editors.layout.configuration.FlagManager;
import org.eclipse.swt.graphics.Image;

public class Locale {
    public static final LocaleQualifier ANY_LOCALE = new LocaleQualifier("__");
    public static final Locale ANY = new Locale(ANY_LOCALE);
    public final LocaleQualifier locale;

    private Locale(LocaleQualifier locale) {
        this.locale = locale;
    }

    public static Locale create(LocaleQualifier locale) {
        return new Locale(locale);
    }

    public Image getFlagImage() {
        Image image = null;
        if (this.locale.hasFakeValue()) {
            return FlagManager.getGlobeIcon();
        }
        FlagManager icons = FlagManager.get();
        image = icons.getFlag(this.locale.getLanguage(), this.locale.getRegion());
        if (image == null) {
            image = FlagManager.getEmptyIcon();
        }
        return image;
    }

    public boolean hasLanguage() {
        return this.locale.hasLanguage();
    }

    public boolean hasRegion() {
        return this.locale.hasRegion();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Locale other = (Locale)obj;
        if (this.locale == null) {
            return other.locale == null;
        }
        return this.locale.equals((Object)other.locale);
    }

    public String toString() {
        return this.locale.getValue();
    }

    public String toLocaleId() {
        return this.locale.getValue();
    }
}

