/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.configuration;

import com.android.sdklib.IAndroidTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.andmore.internal.editors.Hyperlinks;
import org.eclipse.andmore.internal.editors.layout.configuration.Configuration;
import org.eclipse.andmore.internal.editors.layout.configuration.ConfigurationChooser;
import org.eclipse.andmore.internal.editors.layout.configuration.SelectThemeAction;
import org.eclipse.andmore.internal.editors.layout.gle2.SubmenuAction;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.resources.ResourceHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;

class ThemeMenuAction
extends SubmenuAction {
    private static final String DEVICE_LIGHT_PREFIX = "@android:style/Theme.DeviceDefault.Light";
    private static final String HOLO_LIGHT_PREFIX = "@android:style/Theme.Holo.Light";
    private static final String DEVICE_PREFIX = "@android:style/Theme.DeviceDefault";
    private static final String HOLO_PREFIX = "@android:style/Theme.Holo";
    private static final String LIGHT_PREFIX = "@android:style/Theme.Light";
    private static final String THEME_PREFIX = "@android:style/Theme";
    private static final int MENU_MANIFEST = 1;
    private static final int MENU_PROJECT = 2;
    private static final int MENU_THEME = 3;
    private static final int MENU_THEME_LIGHT = 4;
    private static final int MENU_HOLO = 5;
    private static final int MENU_HOLO_LIGHT = 6;
    private static final int MENU_DEVICE = 7;
    private static final int MENU_DEVICE_LIGHT = 8;
    private static final int MENU_ALL = 9;
    private final ConfigurationChooser mConfigChooser;
    private final List<String> mThemeList;
    private final int mType;

    ThemeMenuAction(int type, String title, ConfigurationChooser configuration, List<String> themeList) {
        super(title);
        this.mType = type;
        this.mConfigChooser = configuration;
        this.mThemeList = themeList;
    }

    static void showThemeMenu(ConfigurationChooser configChooser, ToolItem combo, List<String> themeList) {
        IAndroidTarget target;
        String preferred;
        MenuManager manager = new MenuManager();
        Configuration configuration = configChooser.getConfiguration();
        String currentTheme = configuration.getTheme();
        String currentName = null;
        if (currentTheme != null) {
            currentName = ResourceHelper.styleToTheme(currentTheme);
            SelectThemeAction action = new SelectThemeAction(configChooser, currentName, currentTheme, true);
            action.setEnabled(false);
            manager.add((IAction)action);
            manager.add((IContributionItem)new Separator());
        }
        if ((preferred = configuration.computePreferredTheme()) != null && !preferred.equals(currentTheme)) {
            manager.add((IAction)new SelectThemeAction(configChooser, ResourceHelper.styleToTheme(preferred), preferred, false));
            manager.add((IContributionItem)new Separator());
        }
        int apiLevel = (target = configuration.getTarget()) != null ? target.getVersion().getApiLevel() : 1;
        boolean hasHolo = apiLevel >= 11;
        boolean hasDeviceDefault = apiLevel >= 14;
        manager.add((IAction)new ThemeMenuAction(2, "Project Themes", configChooser, themeList));
        manager.add((IAction)new ThemeMenuAction(1, "Manifest Themes", configChooser, themeList));
        manager.add((IContributionItem)new Separator());
        if (hasHolo) {
            manager.add((IAction)new ThemeMenuAction(5, "Holo", configChooser, themeList));
            manager.add((IAction)new ThemeMenuAction(6, "Holo.Light", configChooser, themeList));
        }
        if (hasDeviceDefault) {
            manager.add((IAction)new ThemeMenuAction(7, "DeviceDefault", configChooser, themeList));
            manager.add((IAction)new ThemeMenuAction(8, "DeviceDefault.Light", configChooser, themeList));
        }
        manager.add((IAction)new ThemeMenuAction(3, "Theme", configChooser, themeList));
        manager.add((IAction)new ThemeMenuAction(4, "Theme.Light", configChooser, themeList));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ThemeMenuAction(9, "All", configChooser, themeList));
        if (currentTheme != null) {
            assert (currentName != null);
            manager.add((IContributionItem)new Separator());
            String title = String.format("Open %1$s Declaration...", currentName);
            manager.add((IAction)new OpenThemeAction(title, configChooser.getEditedFile(), currentTheme));
        }
        Menu menu = manager.createContextMenu((Control)configChooser.getShell());
        Rectangle bounds = combo.getBounds();
        Point location = new Point(bounds.x, bounds.y + bounds.height);
        location = combo.getParent().toDisplay(location);
        menu.setLocation(location.x, location.y);
        menu.setVisible(true);
    }

    @Override
    protected void addMenuItems(Menu menu) {
        switch (this.mType) {
            case 9: {
                this.addMenuItems(menu, this.mThemeList);
                break;
            }
            case 1: {
                String theme;
                ManifestInfo.ActivityAttributes attributes;
                IProject project = this.mConfigChooser.getEditedFile().getProject();
                ManifestInfo manifest = ManifestInfo.get(project);
                Configuration configuration = this.mConfigChooser.getConfiguration();
                String activity = configuration.getActivity();
                if (activity != null && (attributes = manifest.getActivityAttributes(activity)) != null && (theme = attributes.getTheme()) != null) {
                    this.addMenuItem(menu, theme, this.isSelectedTheme(theme));
                }
                String manifestTheme = manifest.getManifestTheme();
                boolean found = false;
                HashSet<String> allThemes = new HashSet<String>();
                if (manifestTheme != null) {
                    found = true;
                    allThemes.add(manifestTheme);
                }
                for (ManifestInfo.ActivityAttributes info : manifest.getActivityAttributesMap().values()) {
                    if (info.getTheme() == null) continue;
                    found = true;
                    allThemes.add(info.getTheme());
                }
                ArrayList sorted = new ArrayList(allThemes);
                Collections.sort(sorted);
                String current = configuration.getTheme();
                for (String theme2 : sorted) {
                    boolean selected = theme2.equals(current);
                    this.addMenuItem(menu, theme2, selected);
                }
                if (found) break;
                this.addDisabledMessageItem("No themes are registered in the manifest");
                break;
            }
            case 2: {
                int size = this.mThemeList.size();
                ArrayList<String> themes = new ArrayList<String>(size);
                int i = 0;
                while (i < size) {
                    String theme = this.mThemeList.get(i);
                    if (ResourceHelper.isProjectStyle(theme)) {
                        themes.add(theme);
                    }
                    ++i;
                }
                if (themes.isEmpty()) {
                    this.addDisabledMessageItem("There are no local theme styles in the project");
                    break;
                }
                this.addMenuItems(menu, themes);
                break;
            }
            case 3: {
                ArrayList<String> themes = new ArrayList<String>(this.mThemeList.size());
                for (String theme : this.mThemeList) {
                    if (!theme.startsWith(THEME_PREFIX) || theme.startsWith(LIGHT_PREFIX) || theme.startsWith(HOLO_PREFIX) || theme.startsWith(DEVICE_PREFIX)) continue;
                    themes.add(theme);
                }
                this.addMenuItems(menu, themes);
                break;
            }
            case 4: {
                this.addMenuItems(menu, this.filterThemes(LIGHT_PREFIX, null));
                break;
            }
            case 5: {
                this.addMenuItems(menu, this.filterThemes(HOLO_PREFIX, HOLO_LIGHT_PREFIX));
                break;
            }
            case 6: {
                this.addMenuItems(menu, this.filterThemes(HOLO_LIGHT_PREFIX, null));
                break;
            }
            case 7: {
                this.addMenuItems(menu, this.filterThemes(DEVICE_PREFIX, DEVICE_LIGHT_PREFIX));
                break;
            }
            case 8: {
                this.addMenuItems(menu, this.filterThemes(DEVICE_LIGHT_PREFIX, null));
            }
        }
    }

    private List<String> filterThemes(String include, String exclude) {
        ArrayList<String> themes = new ArrayList<String>(this.mThemeList.size());
        for (String theme : this.mThemeList) {
            if (!theme.startsWith(include) || exclude != null && theme.startsWith(exclude)) continue;
            themes.add(theme);
        }
        return themes;
    }

    private void addMenuItems(Menu menu, List<String> themes) {
        String current = this.mConfigChooser.getConfiguration().getTheme();
        for (String theme : themes) {
            this.addMenuItem(menu, theme, theme.equals(current));
        }
    }

    private boolean isSelectedTheme(String theme) {
        return theme.equals(this.mConfigChooser.getConfiguration().getTheme());
    }

    private void addMenuItem(Menu menu, String theme, boolean selected) {
        String title = ResourceHelper.styleToTheme(theme);
        SelectThemeAction action = new SelectThemeAction(this.mConfigChooser, title, theme, selected);
        new ActionContributionItem((IAction)action).fill(menu, -1);
    }

    private static class OpenThemeAction
    extends Action {
        private final String mTheme;
        private final IFile mFile;

        private OpenThemeAction(String title, IFile file, String theme) {
            super(title, 1);
            this.mFile = file;
            this.mTheme = theme;
        }

        public void run() {
            IProject project = this.mFile.getProject();
            IHyperlink[] links = Hyperlinks.getResourceLinks(null, this.mTheme, project, null);
            if (links != null && links.length > 0) {
                IHyperlink link = links[0];
                link.open();
            }
        }
    }
}

