/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.descriptors;

import java.util.Collections;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.graphics.Image;

public class ViewElementDescriptor
extends ElementDescriptor {
    private final String mFullClassName;
    private AttributeDescriptor[] mLayoutAttributes;
    private ViewElementDescriptor mSuperClassDesc;
    private List<String> mAttributeSources;

    public ViewElementDescriptor(String xml_name, String ui_name, String fullClassName, String tooltip, String sdk_url, AttributeDescriptor[] attributes, AttributeDescriptor[] layoutAttributes, ElementDescriptor[] children, boolean mandatory) {
        super(xml_name, ui_name, tooltip, sdk_url, attributes, children, mandatory);
        this.mFullClassName = fullClassName;
        this.mLayoutAttributes = layoutAttributes != null ? layoutAttributes : new AttributeDescriptor[]{};
    }

    public ViewElementDescriptor(String xml_name, String fullClassName) {
        super(xml_name);
        this.mFullClassName = fullClassName;
        this.mLayoutAttributes = null;
    }

    public String getFullClassName() {
        return this.mFullClassName;
    }

    public AttributeDescriptor[] getLayoutAttributes() {
        return this.mLayoutAttributes;
    }

    public void setLayoutAttributes(AttributeDescriptor[] attributes) {
        assert (attributes != null);
        this.mLayoutAttributes = attributes;
    }

    @Override
    public UiElementNode createUiNode() {
        return new UiViewElementNode(this);
    }

    public ViewElementDescriptor getSuperClassDesc() {
        return this.mSuperClassDesc;
    }

    public void setSuperClass(ViewElementDescriptor superClassDesc) {
        this.mSuperClassDesc = superClassDesc;
    }

    @Override
    public Image getGenericIcon() {
        IconFactory factory = IconFactory.getInstance();
        String name = this.mXmlName;
        if (name.indexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        } else if ("view".equals(name)) {
            name = "View";
        }
        Image icon = factory.getIcon(name);
        if (icon == null) {
            icon = AndmoreAndroidPlugin.getAndroidLogo();
        }
        return icon;
    }

    public List<String> getAttributeSources() {
        return this.mAttributeSources != null ? this.mAttributeSources : Collections.emptyList();
    }

    public void setAttributeSources(List<String> attributeSources) {
        this.mAttributeSources = attributeSources;
    }

    public static boolean viewNeedsPackage(String fqcn) {
        return !fqcn.startsWith("android.widget.") && !fqcn.startsWith("android.view.") && !fqcn.startsWith("android.webkit.");
    }
}

