/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.Margins;
import com.android.ide.common.api.Rect;
import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.common.layout.GridLayoutRule;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.FragmentMenu;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleAttribute;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleXmlTransfer;
import org.eclipse.andmore.internal.editors.layout.gle2.SwtUtils;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiAttributeNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CanvasViewInfo
implements IPropertySource {
    public static final int SELECTION_MIN_SIZE = 6;
    private final Rectangle mAbsRect;
    private final Rectangle mSelectionRect;
    private final String mName;
    private final Object mViewObject;
    private final UiViewElementNode mUiViewNode;
    private CanvasViewInfo mParent;
    private ViewInfo mViewInfo;
    private final List<CanvasViewInfo> mChildren = new ArrayList<CanvasViewInfo>();
    private boolean mExploded;
    private List<CanvasViewInfo> mNodeSiblings;

    private CanvasViewInfo(CanvasViewInfo parent, String name, Object viewObject, UiViewElementNode node, Rectangle absRect, Rectangle selectionRect, ViewInfo viewInfo) {
        this.mParent = parent;
        this.mName = name;
        this.mViewObject = viewObject;
        this.mViewInfo = viewInfo;
        this.mUiViewNode = node;
        this.mAbsRect = absRect;
        this.mSelectionRect = selectionRect;
    }

    public Rectangle getAbsRect() {
        return this.mAbsRect;
    }

    public Rectangle getSelectionRect() {
        return this.mSelectionRect;
    }

    public UiViewElementNode getUiViewNode() {
        return this.mUiViewNode;
    }

    public CanvasViewInfo getParent() {
        return this.mParent;
    }

    public List<CanvasViewInfo> getChildren() {
        return this.mChildren;
    }

    private CanvasViewInfo getPrimaryNodeSibling() {
        if (this.mNodeSiblings == null || this.mNodeSiblings.size() == 0) {
            return null;
        }
        return this.mNodeSiblings.get(0);
    }

    private boolean isPrimaryNodeSibling() {
        return this.getPrimaryNodeSibling() == this;
    }

    public List<CanvasViewInfo> getNodeSiblings() {
        return this.mNodeSiblings;
    }

    public List<CanvasViewInfo> getUniqueChildren() {
        boolean haveHidden = false;
        for (CanvasViewInfo info : this.mChildren) {
            if (info.mNodeSiblings != null) {
                ArrayList<CanvasViewInfo> children = new ArrayList<CanvasViewInfo>();
                for (CanvasViewInfo vi : this.mChildren) {
                    if (vi.mNodeSiblings == null) {
                        children.add(vi);
                        continue;
                    }
                    if (!vi.isPrimaryNodeSibling()) continue;
                    children.add(vi);
                }
                return children;
            }
            haveHidden |= info.isHidden();
        }
        if (haveHidden) {
            ArrayList<CanvasViewInfo> children = new ArrayList<CanvasViewInfo>(this.mChildren.size());
            for (CanvasViewInfo vi : this.mChildren) {
                if (vi.isHidden()) continue;
                children.add(vi);
            }
            return children;
        }
        return this.mChildren;
    }

    public boolean isParent(CanvasViewInfo potentialParent) {
        CanvasViewInfo p = this.mParent;
        while (p != null) {
            if (p == potentialParent) {
                return true;
            }
            p = p.getParent();
        }
        return false;
    }

    public String getName() {
        return this.mName;
    }

    public Object getViewObject() {
        return this.mViewObject;
    }

    public int getBaseline() {
        int baseline;
        if (this.mViewInfo != null && (baseline = this.mViewInfo.getBaseLine()) != Integer.MIN_VALUE) {
            return baseline;
        }
        return -1;
    }

    public Margins getMargins() {
        if (this.mViewInfo != null) {
            int leftMargin = this.mViewInfo.getLeftMargin();
            int topMargin = this.mViewInfo.getTopMargin();
            int rightMargin = this.mViewInfo.getRightMargin();
            int bottomMargin = this.mViewInfo.getBottomMargin();
            return new Margins(leftMargin != Integer.MIN_VALUE ? leftMargin : 0, rightMargin != Integer.MIN_VALUE ? rightMargin : 0, topMargin != Integer.MIN_VALUE ? topMargin : 0, bottomMargin != Integer.MIN_VALUE ? bottomMargin : 0);
        }
        return null;
    }

    public Object getEditableValue() {
        UiViewElementNode uiView = this.getUiViewNode();
        if (uiView != null) {
            return uiView.getEditableValue();
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        UiViewElementNode uiView = this.getUiViewNode();
        if (uiView != null) {
            return uiView.getPropertyDescriptors();
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        UiViewElementNode uiView = this.getUiViewNode();
        if (uiView != null) {
            return uiView.getPropertyValue(id);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        UiViewElementNode uiView = this.getUiViewNode();
        if (uiView != null) {
            return uiView.isPropertySet(id);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        UiViewElementNode uiView = this.getUiViewNode();
        if (uiView != null) {
            uiView.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        UiViewElementNode uiView = this.getUiViewNode();
        if (uiView != null) {
            uiView.setPropertyValue(id, value);
        }
    }

    public Node getXmlNode() {
        UiViewElementNode uiView = this.getUiViewNode();
        if (uiView != null) {
            return uiView.getXmlNode();
        }
        return null;
    }

    public boolean isRoot() {
        if (this.mParent != null && this.mParent.mName.endsWith("GestureOverlayView") && this.mParent.isRoot() && this.mParent.mChildren.size() == 1) {
            return true;
        }
        return this.mUiViewNode == null || this.mUiViewNode.getUiParent() == null || this.mUiViewNode.getUiParent().getUiParent() == null;
    }

    public boolean isInvisible() {
        if (this.isHidden()) {
            return false;
        }
        if (this.mAbsRect.width < 6 || this.mAbsRect.height < 6) {
            return this.mUiViewNode != null && (this.mUiViewNode.getDescriptor().hasChildren() || this.mAbsRect.width <= 0 || this.mAbsRect.height <= 0);
        }
        return false;
    }

    public boolean isHidden() {
        if (GridLayoutRule.sDebugGridLayout) {
            return false;
        }
        return "android.widget.Space".equals(this.mName) || "android.support.v7.widget.Space".equals(this.mName);
    }

    public boolean isExploded() {
        return this.mExploded;
    }

    void setExploded(boolean exploded) {
        this.mExploded = exploded;
    }

    SimpleElement toSimpleElement() {
        UiViewElementNode uiNode = this.getUiViewNode();
        String fqcn = SimpleXmlTransfer.getFqcn(uiNode.getDescriptor());
        String parentFqcn = null;
        Rect bounds = SwtUtils.toRect(this.getAbsRect());
        Rect parentBounds = null;
        UiElementNode uiParent = uiNode.getUiParent();
        if (uiParent != null) {
            parentFqcn = SimpleXmlTransfer.getFqcn(uiParent.getDescriptor());
        }
        if (this.getParent() != null) {
            parentBounds = SwtUtils.toRect(this.getParent().getAbsRect());
        }
        SimpleElement e = new SimpleElement(fqcn, parentFqcn, bounds, parentBounds);
        for (UiAttributeNode attr : uiNode.getAllUiAttributes()) {
            String value = attr.getCurrentValue();
            if (value == null || value.length() <= 0) continue;
            AttributeDescriptor attrDesc = attr.getDescriptor();
            SimpleAttribute a = new SimpleAttribute(attrDesc.getNamespaceUri(), attrDesc.getXmlLocalName(), value);
            e.addAttribute(a);
        }
        for (CanvasViewInfo childVi : this.getChildren()) {
            SimpleElement e2 = childVi.toSimpleElement();
            if (e2 == null) continue;
            e.addInnerElement(e2);
        }
        return e;
    }

    public String getIncludeUrl() {
        CanvasViewInfo curr = this;
        while (curr != null) {
            Node node;
            if (curr.mUiViewNode != null && (node = curr.mUiViewNode.getXmlNode()) != null && node.getNodeType() == 1) {
                String url;
                String nodeName = node.getNodeName();
                if (node.getNamespaceURI() == null && "include".equals(nodeName)) {
                    Element element = (Element)node;
                    String url2 = element.getAttribute("layout");
                    if (url2.length() > 0) {
                        return url2;
                    }
                } else if ("fragment".equals(nodeName) && (url = FragmentMenu.getFragmentLayout(node)) != null) {
                    return url;
                }
            }
            curr = curr.mParent;
        }
        return null;
    }

    private void addChild(CanvasViewInfo child) {
        this.mChildren.add(child);
    }

    private void addChildAt(int index, CanvasViewInfo child) {
        this.mChildren.add(index, child);
    }

    public boolean removeChild(CanvasViewInfo child) {
        return this.mChildren.remove(child);
    }

    public String toString() {
        return "CanvasViewInfo [name=" + this.mName + ", node=" + this.mUiViewNode + "]";
    }

    public static Pair<CanvasViewInfo, List<Rectangle>> create(ViewInfo root, boolean layoutlib5) {
        return new Builder(layoutlib5).create(root);
    }

    /* synthetic */ CanvasViewInfo(CanvasViewInfo canvasViewInfo, String string, Object object, UiViewElementNode uiViewElementNode, Rectangle rectangle, Rectangle rectangle2, ViewInfo viewInfo, CanvasViewInfo canvasViewInfo2) {
        this(canvasViewInfo, string, object, uiViewElementNode, rectangle, rectangle2, viewInfo);
    }

    private static class Builder {
        private Map<UiViewElementNode, List<CanvasViewInfo>> mMergeNodeMap;
        private boolean mLayoutLib5;

        public Builder(boolean layoutlib5) {
            this.mLayoutLib5 = layoutlib5;
        }

        private Pair<CanvasViewInfo, List<Rectangle>> create(ViewInfo root) {
            Object cookie = root.getCookie();
            if (cookie == null) {
                CanvasViewInfo rootView = this.createView(null, root, 0, 0);
                this.addKeyedSubtrees(rootView, root, 0, 0);
                ArrayList<Rectangle> includedBounds = new ArrayList<Rectangle>();
                for (CanvasViewInfo vi : rootView.getChildren()) {
                    if (vi.getNodeSiblings() != null && !vi.isPrimaryNodeSibling()) continue;
                    includedBounds.add(vi.getAbsRect());
                }
                if (this.mMergeNodeMap != null) {
                    UiViewElementNode merge = null;
                    ArrayList<CanvasViewInfo> merged = new ArrayList<CanvasViewInfo>();
                    for (Map.Entry<UiViewElementNode, List<CanvasViewInfo>> entry : this.mMergeNodeMap.entrySet()) {
                        UiViewElementNode node = entry.getKey();
                        if (!this.hasMergeParent(node)) continue;
                        List<CanvasViewInfo> views = entry.getValue();
                        assert (views.size() > 0);
                        CanvasViewInfo view = views.get(0);
                        if (view.getParent() != rootView) continue;
                        UiElementNode parent = node.getUiParent();
                        if (merge != null && parent != merge) continue;
                        merge = (UiViewElementNode)parent;
                        merged.add(view);
                    }
                    if (merged.size() > 0) {
                        Rectangle absRect = null;
                        for (CanvasViewInfo child : merged) {
                            Rectangle rect = child.getAbsRect();
                            absRect = absRect == null ? rect : absRect.union(rect);
                        }
                        CanvasViewInfo mergeView = new CanvasViewInfo(rootView, "merge", null, merge, absRect, absRect, null, null);
                        for (CanvasViewInfo view : merged) {
                            if (!rootView.removeChild(view)) continue;
                            mergeView.addChild(view);
                        }
                        rootView.addChild(mergeView);
                    }
                }
                return Pair.of((Object)rootView, includedBounds);
            }
            CanvasViewInfo rootView = this.addKeyedSubtrees(null, root, 0, 0);
            if (rootView != null && this.hasMergeParent(rootView.getUiViewNode())) {
                CanvasViewInfo merge = new CanvasViewInfo(null, "merge", null, (UiViewElementNode)rootView.getUiViewNode().getUiParent(), rootView.getAbsRect(), rootView.getSelectionRect(), null, null);
                rootView.mParent = merge;
                merge.addChild(rootView);
                rootView = merge;
            }
            return Pair.of((Object)rootView, null);
        }

        private boolean hasMergeParent(UiViewElementNode rootNode) {
            UiElementNode rootParent = rootNode.getUiParent();
            return rootParent instanceof UiViewElementNode && "merge".equals(rootParent.getDescriptor().getXmlName());
        }

        private CanvasViewInfo createView(CanvasViewInfo parent, ViewInfo root, int parentX, int parentY) {
            Object cookie = root.getCookie();
            UiViewElementNode node = null;
            if (cookie instanceof UiViewElementNode) {
                node = (UiViewElementNode)cookie;
            } else if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof UiViewElementNode) {
                node = (UiViewElementNode)cookie;
                CanvasViewInfo view = this.createView(parent, root, parentX, parentY, node);
                if (root.getCookie() instanceof MergeCookie && view.mNodeSiblings == null) {
                    List<CanvasViewInfo> v;
                    List<CanvasViewInfo> list = v = this.mMergeNodeMap == null ? null : this.mMergeNodeMap.get(node);
                    if (v != null) {
                        v.add(view);
                    } else {
                        v = new ArrayList<CanvasViewInfo>();
                        v.add(view);
                        if (this.mMergeNodeMap == null) {
                            this.mMergeNodeMap = new HashMap<UiViewElementNode, List<CanvasViewInfo>>();
                        }
                        this.mMergeNodeMap.put(node, v);
                    }
                    view.mNodeSiblings = v;
                }
                return view;
            }
            return this.createView(parent, root, parentX, parentY, node);
        }

        private CanvasViewInfo createView(CanvasViewInfo parent, ViewInfo root, int parentX, int parentY, UiViewElementNode node) {
            int d;
            int x = root.getLeft();
            int y = root.getTop();
            int w = root.getRight() - x;
            int h = root.getBottom() - y;
            Rectangle absRect = new Rectangle(x += parentX, y += parentY, w - 1, h - 1);
            if (w < 6) {
                d = (6 - w) / 2;
                x -= d;
                w += 6 - w;
            }
            if (h < 6) {
                d = (6 - h) / 2;
                y -= d;
                h += 6 - h;
            }
            Rectangle selectionRect = new Rectangle(x, y, w - 1, h - 1);
            return new CanvasViewInfo(parent, root.getClassName(), root.getViewObject(), node, absRect, selectionRect, root, null);
        }

        private CanvasViewInfo createSubtree(CanvasViewInfo parent, ViewInfo viewInfo, int parentX, int parentY) {
            CanvasViewInfo view;
            block19: {
                CanvasViewInfo childView;
                String containerName;
                int mergeNodes;
                int missingNodes;
                List children;
                block18: {
                    assert (viewInfo.getCookie() != null);
                    view = this.createView(parent, viewInfo, parentX, parentY);
                    if (parent != null && view.mUiViewNode == parent.mUiViewNode) {
                        return null;
                    }
                    parentX += viewInfo.getLeft();
                    parentY += viewInfo.getTop();
                    children = viewInfo.getChildren();
                    if (this.mLayoutLib5) {
                        for (ViewInfo child : children) {
                            CanvasViewInfo childView2;
                            Object cookie = child.getCookie();
                            if (!(cookie instanceof UiViewElementNode) && !(cookie instanceof MergeCookie) || (childView2 = this.createSubtree(view, child, parentX, parentY)) == null) continue;
                            view.addChild(childView2);
                        }
                        return view;
                    }
                    missingNodes = 0;
                    mergeNodes = 0;
                    for (ViewInfo child : children) {
                        Object cookie = child.getCookie();
                        if (cookie instanceof UiViewElementNode) continue;
                        if (cookie instanceof MergeCookie) {
                            ++mergeNodes;
                            continue;
                        }
                        ++missingNodes;
                    }
                    if (missingNodes != 0 || mergeNodes != 0) break block18;
                    for (ViewInfo child : children) {
                        CanvasViewInfo childView3 = this.createSubtree(view, child, parentX, parentY);
                        view.addChild(childView3);
                    }
                    break block19;
                }
                UiViewElementNode uiViewNode = view.getUiViewNode();
                String string = containerName = uiViewNode != null ? uiViewNode.getDescriptor().getXmlLocalName() : "";
                if (containerName.equals("include")) break block19;
                LinkedList<UiViewElementNode> unused = new LinkedList<UiViewElementNode>();
                if (uiViewNode != null) {
                    for (UiElementNode uiElementNode : uiViewNode.getUiChildren()) {
                        if (!(uiElementNode instanceof UiViewElementNode)) continue;
                        unused.addLast((UiViewElementNode)uiElementNode);
                    }
                }
                for (ViewInfo viewInfo2 : children) {
                    Object cookie = viewInfo2.getCookie();
                    if (mergeNodes > 0 && cookie instanceof MergeCookie) {
                        cookie = ((MergeCookie)cookie).getCookie();
                    }
                    if (cookie == null) continue;
                    unused.remove(cookie);
                }
                if (unused.size() > 0 || mergeNodes > 0) {
                    if (unused.size() == missingNodes) {
                        for (ViewInfo viewInfo3 : children) {
                            if (viewInfo3.getCookie() == null) {
                                childView = this.createView(view, viewInfo3, parentX, parentY, unused.removeFirst());
                                view.addChild(childView);
                                continue;
                            }
                            childView = this.createSubtree(view, viewInfo3, parentX, parentY);
                            view.addChild(childView);
                        }
                    } else {
                        this.addMismatched(view, parentX, parentY, children, unused);
                    }
                } else {
                    for (ViewInfo viewInfo4 : children) {
                        if (viewInfo4.getCookie() == null) continue;
                        childView = this.createSubtree(view, viewInfo4, parentX, parentY);
                        view.addChild(childView);
                    }
                }
            }
            return view;
        }

        private void addMismatched(CanvasViewInfo parentView, int parentX, int parentY, List<ViewInfo> children, LinkedList<UiViewElementNode> unused) {
            UiViewElementNode afterNode = null;
            UiViewElementNode beforeNode = null;
            int index = 0;
            int size = children.size();
            while (index < size) {
                ViewInfo child = children.get(index);
                if (child.getCookie() != null) {
                    CanvasViewInfo childView = this.createSubtree(parentView, child, parentX, parentY);
                    if (childView != null) {
                        parentView.addChild(childView);
                    }
                    if (child.getCookie() instanceof UiViewElementNode) {
                        afterNode = (UiViewElementNode)child.getCookie();
                    }
                } else {
                    beforeNode = this.nextViewNode(children, index);
                    UiViewElementNode matching = null;
                    for (UiViewElementNode uiViewElementNode : unused) {
                        if (afterNode != null && !this.isAfter(afterNode, uiViewElementNode) || beforeNode != null && !this.isBefore(beforeNode, uiViewElementNode)) continue;
                        matching = uiViewElementNode;
                        break;
                    }
                    if (matching != null) {
                        unused.remove(matching);
                        CanvasViewInfo canvasViewInfo = this.createView(parentView, child, parentX, parentY, matching);
                        parentView.addChild(canvasViewInfo);
                        afterNode = matching;
                    }
                }
                ++index;
            }
            if (unused.size() > 0) {
                HashMap<UiViewElementNode, Integer> rankMap = new HashMap<UiViewElementNode, Integer>();
                HashMap<UiViewElementNode, CanvasViewInfo> infoMap = new HashMap<UiViewElementNode, CanvasViewInfo>();
                UiElementNode parent = unused.get(0).getUiParent();
                if (parent != null) {
                    int index2 = 0;
                    for (UiElementNode uiElementNode : parent.getUiChildren()) {
                        UiViewElementNode node = (UiViewElementNode)uiElementNode;
                        rankMap.put(node, index2++);
                    }
                    for (CanvasViewInfo canvasViewInfo : parentView.getChildren()) {
                        infoMap.put(canvasViewInfo.getUiViewNode(), canvasViewInfo);
                    }
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (UiViewElementNode node : unused) {
                        Integer rank = (Integer)rankMap.get(node);
                        if (rank == null) continue;
                        arrayList.add(rank);
                    }
                    Collections.sort(arrayList);
                    int i = arrayList.size() - 1;
                    while (i >= 0) {
                        Integer rank = (Integer)arrayList.get(i);
                        UiElementNode found = null;
                        for (UiViewElementNode node : unused) {
                            if (!((Integer)rankMap.get(node)).equals(rank)) continue;
                            found = node;
                            break;
                        }
                        if (found != null) {
                            Rectangle absRect = new Rectangle(parentX, parentY, 0, 0);
                            String name = found.getDescriptor().getXmlLocalName();
                            CanvasViewInfo v = new CanvasViewInfo(parentView, name, null, (UiViewElementNode)found, absRect, absRect, null, null);
                            List<CanvasViewInfo> siblings = parentView.getChildren();
                            int insertPosition = siblings.size();
                            int j = siblings.size() - 1;
                            while (j >= 0) {
                                Integer siblingRank;
                                CanvasViewInfo sibling = siblings.get(j);
                                UiViewElementNode siblingNode = sibling.getUiViewNode();
                                if (siblingNode != null && (siblingRank = (Integer)rankMap.get(siblingNode)) != null && siblingRank < rank) {
                                    insertPosition = j + 1;
                                    break;
                                }
                                --j;
                            }
                            parentView.addChildAt(insertPosition, v);
                            unused.remove(found);
                        }
                        --i;
                    }
                }
                for (UiViewElementNode node : unused) {
                    Rectangle absRect = new Rectangle(parentX, parentY, 0, 0);
                    String name = node.getDescriptor().getXmlLocalName();
                    CanvasViewInfo v = new CanvasViewInfo(parentView, name, null, node, absRect, absRect, null, null);
                    parentView.addChild(v);
                }
            }
        }

        private boolean isBefore(UiViewElementNode beforeNode, UiViewElementNode candidate) {
            UiElementNode parent = candidate.getUiParent();
            if (parent != null) {
                for (UiElementNode sibling : parent.getUiChildren()) {
                    if (sibling == beforeNode) {
                        return false;
                    }
                    if (sibling != candidate) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean isAfter(UiViewElementNode afterNode, UiViewElementNode candidate) {
            UiElementNode parent = candidate.getUiParent();
            if (parent != null) {
                for (UiElementNode sibling : parent.getUiChildren()) {
                    if (sibling == afterNode) {
                        return true;
                    }
                    if (sibling != candidate) continue;
                    return false;
                }
            }
            return false;
        }

        private UiViewElementNode nextViewNode(List<ViewInfo> children, int index) {
            int size = children.size();
            while (index < size) {
                ViewInfo child = children.get(index);
                if (child.getCookie() instanceof UiViewElementNode) {
                    return (UiViewElementNode)child.getCookie();
                }
                ++index;
            }
            return null;
        }

        private CanvasViewInfo addKeyedSubtrees(CanvasViewInfo parent, ViewInfo viewInfo, int parentX, int parentY) {
            if (viewInfo.getCookie() != null) {
                CanvasViewInfo subtree = this.createSubtree(parent, viewInfo, parentX, parentY);
                if (parent != null && subtree != null) {
                    parent.mChildren.add(subtree);
                }
                return subtree;
            }
            for (ViewInfo child : viewInfo.getChildren()) {
                this.addKeyedSubtrees(parent, child, parentX + viewInfo.getLeft(), parentY + viewInfo.getTop());
            }
            return null;
        }
    }
}

