/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class GestureToolTip {
    private static final int TIMEOUT_MS = 750;
    private static final int SHELL_TRANSPARENCY = 220;
    private static final int FONT_SIZE = 9;
    private static final int OFFSET_X = 20;
    private static final int OFFSET_Y = 20;
    private CLabel mLabel;
    private Shell mShell;
    private Font mFont;
    private boolean mBelow;
    private boolean mToRightOf;
    private boolean mTimerPending;
    private boolean mPendingBelow;
    private boolean mPendingRight;
    private long mLastAlignmentTime;

    public GestureToolTip(Composite parent, boolean below, boolean toRightOf) {
        this.mBelow = below;
        this.mToRightOf = toRightOf;
        this.mLastAlignmentTime = System.currentTimeMillis();
        this.mShell = new Shell(parent.getShell(), 540676);
        this.mShell.setLayout((Layout)new FillLayout());
        this.mShell.setAlpha(220);
        Display display = parent.getDisplay();
        this.mLabel = new CLabel((Composite)this.mShell, 32);
        this.mLabel.setBackground(display.getSystemColor(29));
        this.mLabel.setForeground(display.getSystemColor(28));
        Font systemFont = display.getSystemFont();
        FontData[] fd = systemFont.getFontData();
        int i = 0;
        while (i < fd.length) {
            fd[i].setHeight(9);
            ++i;
        }
        this.mFont = new Font((Device)display, fd);
        this.mLabel.setFont(this.mFont);
        this.mShell.setVisible(false);
    }

    public void update(final String text, boolean below, boolean toRightOf) {
        if (!(this.mTimerPending || below == this.mBelow && toRightOf == this.mToRightOf || System.currentTimeMillis() - this.mLastAlignmentTime < 750L)) {
            this.mBelow = below;
            this.mToRightOf = toRightOf;
            this.mLastAlignmentTime = System.currentTimeMillis();
        }
        Point location = this.mShell.getDisplay().getCursorLocation();
        this.mLabel.setText(text);
        boolean changed = true;
        this.mShell.pack(changed);
        Point size = this.mShell.getSize();
        if (this.mBelow) {
            location.y += 20;
        } else {
            location.y -= 20;
            location.y -= size.y;
        }
        if (this.mToRightOf) {
            location.x += 20;
        } else {
            location.x -= 20;
            location.x -= size.x;
        }
        this.mShell.setLocation(location);
        if (!this.mShell.isVisible()) {
            this.mShell.setVisible(true);
        }
        this.mPendingBelow = below;
        this.mPendingRight = toRightOf;
        if (!(below == this.mBelow && toRightOf == this.mToRightOf || this.mTimerPending)) {
            this.mTimerPending = true;
            Runnable timer = new Runnable(){

                @Override
                public void run() {
                    GestureToolTip.this.mTimerPending = false;
                    if (GestureToolTip.this.mBelow != GestureToolTip.this.mPendingBelow || GestureToolTip.this.mToRightOf != GestureToolTip.this.mPendingRight) {
                        GestureToolTip.this.mBelow = GestureToolTip.this.mPendingBelow;
                        GestureToolTip.this.mToRightOf = GestureToolTip.this.mPendingRight;
                        GestureToolTip.this.mLastAlignmentTime = System.currentTimeMillis();
                        if (GestureToolTip.this.mShell != null && GestureToolTip.this.mShell.isVisible()) {
                            GestureToolTip.this.update(text, GestureToolTip.this.mBelow, GestureToolTip.this.mToRightOf);
                        }
                    }
                }
            };
            this.mShell.getDisplay().timerExec(750, timer);
        }
    }

    public void dispose() {
        this.mShell.dispose();
        this.mFont.dispose();
        this.mShell = null;
        this.mFont = null;
        this.mLabel = null;
    }
}

