/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasTransform;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.ControlPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.LintTooltip;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

class LintTooltipManager
implements Listener {
    private final LayoutCanvas mCanvas;
    private Shell mTip = null;
    private List<UiViewElementNode> mShowingNodes;

    LintTooltipManager(LayoutCanvas canvas) {
        this.mCanvas = canvas;
    }

    void register() {
        this.mCanvas.addListener(12, this);
        this.mCanvas.addListener(1, this);
        this.mCanvas.addListener(5, this);
        this.mCanvas.addListener(32, this);
    }

    void unregister() {
        if (!this.mCanvas.isDisposed()) {
            this.mCanvas.removeListener(12, this);
            this.mCanvas.removeListener(1, this);
            this.mCanvas.removeListener(5, this);
            this.mCanvas.removeListener(32, this);
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 5: {
                List<UiViewElementNode> nodes;
                if (this.mShowingNodes != null && (nodes = this.computeNodes(event)) != null && !nodes.isEmpty()) {
                    if (nodes.equals(this.mShowingNodes)) {
                        return;
                    }
                    this.show(nodes);
                    break;
                }
            }
            case 1: 
            case 3: 
            case 7: 
            case 12: 
            case 16: {
                this.hide();
                break;
            }
            case 32: {
                this.hide();
                this.show(event);
            }
        }
    }

    void hide() {
        if (this.mTip != null) {
            this.mTip.dispose();
            this.mTip = null;
        }
        this.mShowingNodes = null;
    }

    private void show(Event event) {
        List<UiViewElementNode> nodes = this.computeNodes(event);
        if (nodes != null && !nodes.isEmpty()) {
            this.show(nodes);
        }
    }

    private void show(List<UiViewElementNode> nodes) {
        this.hide();
        if (!AdtPrefs.getPrefs().isLintOnSave()) {
            return;
        }
        this.mTip = new LintTooltip(this.mCanvas, nodes);
        Rectangle rect = this.mCanvas.getBounds();
        Point size = this.mTip.computeSize(-1, -1);
        Point pos = this.mCanvas.toDisplay(rect.x, rect.y + rect.height);
        if (size.x > rect.width) {
            size = this.mTip.computeSize(rect.width, -1);
        }
        this.mTip.setBounds(pos.x, pos.y, size.x, size.y);
        this.mShowingNodes = nodes;
        this.mTip.setVisible(true);
    }

    private List<UiViewElementNode> computeNodes(Event event) {
        LayoutPoint p = ControlPoint.create(this.mCanvas, event.x, event.y).toLayout();
        LayoutEditorDelegate delegate = this.mCanvas.getEditorDelegate();
        ViewHierarchy viewHierarchy = this.mCanvas.getViewHierarchy();
        CanvasTransform mHScale = this.mCanvas.getHorizontalTransform();
        CanvasTransform mVScale = this.mCanvas.getVerticalTransform();
        int layoutIconSize = mHScale.inverseScale(8);
        int slop = mVScale.inverseScale(10);
        Collection<Node> xmlNodes = delegate.getLintNodes();
        if (xmlNodes == null) {
            return null;
        }
        ArrayList<UiViewElementNode> nodes = new ArrayList<UiViewElementNode>();
        for (Node xmlNode : xmlNodes) {
            CanvasViewInfo v = viewHierarchy.findViewInfoFor(xmlNode);
            if (v == null) continue;
            Rectangle b = v.getAbsRect();
            int x2 = b.x + b.width;
            int y2 = b.y + b.height;
            if (p.x < x2 - layoutIconSize - slop || p.x > x2 + slop || p.y < y2 - layoutIconSize - slop || p.y > y2 + slop) continue;
            nodes.add(v.getUiViewNode());
        }
        return nodes;
    }
}

