/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.api.INode;
import com.android.ide.common.api.InsertType;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.andmore.common.layout.BaseLayoutRule;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.GlobalCanvasDragInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.MoveGesture;
import org.eclipse.andmore.internal.editors.layout.gle2.OutlinePage;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionManager;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleXmlTransfer;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;

class OutlineDropListener
extends ViewerDropAdapter {
    private final OutlinePage mOutlinePage;

    public OutlineDropListener(OutlinePage outlinePage, TreeViewer treeViewer) {
        super((Viewer)treeViewer);
        this.mOutlinePage = outlinePage;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 0 && GlobalCanvasDragInfo.getInstance().isDragging()) {
            int operation;
            event.detail = operation = 1;
        }
        super.dragEnter(event);
    }

    public boolean performDrop(Object data) {
        final DropTargetEvent event = this.getCurrentEvent();
        if (event == null) {
            return false;
        }
        int location = this.determineLocation(event);
        if (location == 4) {
            return false;
        }
        SimpleXmlTransfer sxt = SimpleXmlTransfer.getInstance();
        if (sxt.isSupportedType(event.currentDataType)) {
            if (!(data instanceof SimpleElement[])) {
                return false;
            }
        } else {
            return false;
        }
        final SimpleElement[] elements = (SimpleElement[])data;
        if (elements.length == 0) {
            return false;
        }
        CanvasViewInfo parent = OutlinePage.getViewInfo(event.item.getData());
        if (parent == null) {
            return false;
        }
        int index = -1;
        UiViewElementNode parentNode = parent.getUiViewNode();
        if (location == 1 || location == 2) {
            UiViewElementNode node = parentNode;
            if ((parent = parent.getParent()) == null) {
                return false;
            }
            parentNode = parent.getUiViewNode();
            index = 0;
            for (UiElementNode child : parentNode.getUiChildren()) {
                if (child == node) break;
                ++index;
            }
            if (location == 2) {
                ++index;
            }
        }
        final LayoutCanvas canvas = this.mOutlinePage.getEditor().getCanvasControl();
        final NodeProxy targetNode = canvas.getNodeFactory().create(parentNode);
        HashSet<INode> children = new HashSet<INode>();
        INode[] iNodeArray = targetNode.getChildren();
        int n = iNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            INode node = iNodeArray[n2];
            children.add(node);
            ++n2;
        }
        String label = MoveGesture.computeUndoLabel(targetNode, elements, event.detail);
        final int indexFinal = index;
        canvas.getEditorDelegate().getEditor().wrapUndoEditXmlModel(label, new Runnable(){

            @Override
            public void run() {
                InsertType insertType = MoveGesture.getInsertType(event, targetNode);
                canvas.getRulesEngine().setInsertType(insertType);
                Object sourceCanvas = GlobalCanvasDragInfo.getInstance().getSourceCanvas();
                boolean createNew = event.detail == 1 || sourceCanvas != canvas;
                BaseLayoutRule.insertAt(targetNode, elements, createNew, indexFinal);
                targetNode.applyPendingChanges();
                if (event.detail == 2) {
                    GlobalCanvasDragInfo.getInstance().removeSource();
                }
            }
        });
        ArrayList<INode> added = new ArrayList<INode>();
        INode[] iNodeArray2 = targetNode.getChildren();
        int n3 = iNodeArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            INode node = iNodeArray2[n4];
            if (!children.contains(node)) {
                added.add(node);
            }
            ++n4;
        }
        SelectionManager selectionManager = canvas.getSelectionManager();
        selectionManager.setOutlineSelection(added);
        canvas.redraw();
        return true;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        DropTargetEvent event = this.getCurrentEvent();
        if (event == null) {
            return false;
        }
        int location = this.determineLocation(event);
        if (location == 4) {
            return false;
        }
        SimpleXmlTransfer sxt = SimpleXmlTransfer.getInstance();
        if (!sxt.isSupportedType(transferType)) {
            return false;
        }
        CanvasViewInfo parent = OutlinePage.getViewInfo(event.item.getData());
        if (parent == null) {
            return false;
        }
        UiViewElementNode parentNode = parent.getUiViewNode();
        if (location == 3 && !DescriptorsUtils.canInsertChildren(parentNode.getDescriptor(), parent.getViewObject())) {
            return false;
        }
        SelectionItem[] sel = GlobalCanvasDragInfo.getInstance().getCurrentSelection();
        if (sel != null) {
            SelectionItem[] selectionItemArray = sel;
            int n = sel.length;
            int n2 = 0;
            while (n2 < n) {
                SelectionItem item = selectionItemArray[n2];
                if (this.isAncestor(item.getViewInfo().getUiViewNode(), parentNode)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private boolean isAncestor(UiElementNode parent, UiElementNode child) {
        while (child != null) {
            if (child == parent) {
                return true;
            }
            child = child.getUiParent();
        }
        return false;
    }
}

