/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.ide.common.rendering.RenderSecurityManager;
import com.android.ide.common.rendering.api.LayoutLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;

public class RenderLogger
extends LayoutLog {
    static final String TAG_MISSING_DIMENSION = "missing.dimension";
    private final String mName;
    private List<String> mFidelityWarnings;
    private List<String> mWarnings;
    private List<String> mErrors;
    private boolean mHaveExceptions;
    private List<String> mTags;
    private List<Throwable> mTraces;
    private static Set<String> sIgnoredFidelityWarnings;
    private final Object mCredential;

    RenderLogger(String name, Object credential) {
        this.mName = name;
        this.mCredential = credential;
    }

    public boolean hasProblems() {
        return this.mFidelityWarnings != null || this.mErrors != null || this.mWarnings != null || this.mHaveExceptions;
    }

    public List<Throwable> getFirstTrace() {
        return this.mTraces;
    }

    public String getProblems(boolean includeFidelityWarnings) {
        StringBuilder sb = new StringBuilder();
        if (this.mErrors != null) {
            for (String error : this.mErrors) {
                sb.append(error).append('\n');
            }
        }
        if (this.mWarnings != null) {
            for (String warning : this.mWarnings) {
                sb.append(warning).append('\n');
            }
        }
        if (includeFidelityWarnings && this.mFidelityWarnings != null) {
            sb.append("The graphics preview in the layout editor may not be accurate:\n");
            for (String warning : this.mFidelityWarnings) {
                sb.append("* ");
                sb.append(warning).append('\n');
            }
        }
        if (this.mHaveExceptions) {
            sb.append("Exception details are logged in Window > Show View > Error Log");
        }
        return sb.toString();
    }

    public List<String> getFidelityWarnings() {
        return this.mFidelityWarnings;
    }

    public void error(String tag, String message, Object data) {
        String description = this.describe(message);
        this.appendToIdeLog(null, 4, description);
        if (tag == null && message != null && message.startsWith("Failed to find style ")) {
            tag = "resources.resolve.theme";
        }
        this.addError(tag, description);
    }

    public void error(String tag, String message, Throwable throwable, Object data) {
        String description = this.describe(message);
        this.appendToIdeLog(throwable, 4, description);
        if (throwable != null) {
            if (throwable instanceof ClassNotFoundException) {
                return;
            }
            if (description.equals(throwable.getLocalizedMessage()) || description.equals(throwable.getMessage())) {
                description = "Exception raised during rendering: " + description;
            }
            this.recordThrowable(throwable);
            this.mHaveExceptions = true;
        }
        this.addError(tag, description);
    }

    public void recordThrowable(Throwable throwable) {
        if (this.mTraces == null) {
            this.mTraces = new ArrayList<Throwable>();
        }
        this.mTraces.add(throwable);
    }

    public void warning(String tag, String message, Object data) {
        String description = this.describe(message);
        boolean log = true;
        if ("resources.format".equals(tag) && (description.equals("You must supply a layout_width attribute.") || description.equals("You must supply a layout_height attribute."))) {
            tag = TAG_MISSING_DIMENSION;
            log = false;
        }
        if (log) {
            this.appendToIdeLog(null, 2, description);
        }
        this.addWarning(tag, description);
    }

    public void fidelityWarning(String tag, String message, Throwable throwable, Object data) {
        if (sIgnoredFidelityWarnings != null && sIgnoredFidelityWarnings.contains(message)) {
            return;
        }
        String description = this.describe(message);
        this.appendToIdeLog(throwable, 4, description);
        if (throwable != null) {
            this.mHaveExceptions = true;
        }
        this.addFidelityWarning(tag, description);
    }

    public static void ignoreFidelityWarning(String message) {
        if (sIgnoredFidelityWarnings == null) {
            sIgnoredFidelityWarnings = new HashSet<String>();
        }
        sIgnoredFidelityWarnings.add(message);
    }

    private String describe(String message) {
        if (message == null) {
            return "";
        }
        return message;
    }

    private void addWarning(String tag, String description) {
        if (this.mWarnings == null) {
            this.mWarnings = new ArrayList<String>();
        } else if (this.mWarnings.contains(description)) {
            return;
        }
        this.mWarnings.add(description);
        this.addTag(tag);
    }

    private void addError(String tag, String description) {
        if (this.mErrors == null) {
            this.mErrors = new ArrayList<String>();
        } else if (this.mErrors.contains(description)) {
            return;
        }
        this.mErrors.add(description);
        this.addTag(tag);
    }

    private void addFidelityWarning(String tag, String description) {
        if (this.mFidelityWarnings == null) {
            this.mFidelityWarnings = new ArrayList<String>();
        } else if (this.mFidelityWarnings.contains(description)) {
            return;
        }
        this.mFidelityWarnings.add(description);
        this.addTag(tag);
    }

    private void addTag(String tag) {
        if (tag != null) {
            if (this.mTags == null) {
                this.mTags = new ArrayList<String>();
            }
            this.mTags.add(tag);
        }
    }

    public boolean seenTagPrefix(String prefix) {
        if (this.mTags != null) {
            for (String tag : this.mTags) {
                if (!tag.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean seenTag(String tag) {
        if (this.mTags != null) {
            return this.mTags.contains(tag);
        }
        return false;
    }

    private void appendToIdeLog(Throwable throwable, int severity, String description) {
        boolean token = RenderSecurityManager.enterSafeRegion((Object)this.mCredential);
        try {
            if (throwable != null) {
                AndmoreAndroidPlugin.log(throwable, "%1$s: %2$s", this.mName, description);
            } else {
                AndmoreAndroidPlugin.log(severity, "%1$s: %2$s", this.mName, description);
            }
        }
        finally {
            RenderSecurityManager.exitSafeRegion((boolean)token);
        }
    }
}

