/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gle2;

import com.android.SdkConstants;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.RuleAction;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.layout.BaseViewRule;
import org.eclipse.andmore.common.layout.GridLayoutRule;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasAlternateSelection;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.ControlPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutActionBar;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutCanvas;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutPoint;
import org.eclipse.andmore.internal.editors.layout.gle2.OutlinePage;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionHandle;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionHandles;
import org.eclipse.andmore.internal.editors.layout.gle2.SelectionItem;
import org.eclipse.andmore.internal.editors.layout.gle2.SubmenuAction;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.andmore.internal.editors.layout.gre.NodeFactory;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.gre.RulesEngine;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.refactorings.core.RenameResourceWizard;
import org.eclipse.andmore.internal.refactorings.core.RenameResult;
import org.eclipse.andmore.internal.resources.ResourceNameValidator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.w3c.dom.Node;

public class SelectionManager
implements ISelectionProvider {
    private LayoutCanvas mCanvas;
    private final LinkedList<SelectionItem> mSelections = new LinkedList();
    private final List<SelectionItem> mUnmodifiableSelection = Collections.unmodifiableList(this.mSelections);
    private boolean mInsideUpdateSelection;
    private CanvasAlternateSelection mAltSelection;
    private final ListenerList mSelectionListeners = new ListenerList();
    private static final int SELECT_PARENT = 1;
    private static final int SELECT_SIBLINGS = 2;
    private static final int SELECT_SAME_TYPE = 3;
    private static final int SELECT_NONE = 4;

    public SelectionManager(LayoutCanvas layoutCanvas) {
        this.mCanvas = layoutCanvas;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.mSelectionListeners.remove((Object)listener);
    }

    List<SelectionItem> getSelections() {
        return this.mUnmodifiableSelection;
    }

    public List<SelectionItem> getSnapshot() {
        if (this.mSelectionListeners.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<SelectionItem>(this.mSelections);
    }

    public ISelection getSelection() {
        if (this.mSelections.isEmpty()) {
            return TreeSelection.EMPTY;
        }
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (SelectionItem cs : this.mSelections) {
            CanvasViewInfo vi = cs.getViewInfo();
            if (vi == null) continue;
            paths.add(SelectionManager.getTreePath(vi));
        }
        return new TreeSelection(paths.toArray(new TreePath[paths.size()]));
    }

    public static TreePath getTreePath(CanvasViewInfo viewInfo) {
        ArrayList<CanvasViewInfo> segments = new ArrayList<CanvasViewInfo>();
        while (viewInfo != null) {
            segments.add(0, viewInfo);
            viewInfo = viewInfo.getParent();
        }
        return new TreePath(segments.toArray());
    }

    public void setSelection(ISelection selection) {
        if (this.mInsideUpdateSelection) {
            return;
        }
        boolean changed = false;
        try {
            this.mInsideUpdateSelection = true;
            if (selection == null) {
                selection = TreeSelection.EMPTY;
            }
            if (selection instanceof ITreeSelection) {
                ITreeSelection treeSel = (ITreeSelection)selection;
                if (treeSel.isEmpty()) {
                    if (!this.mSelections.isEmpty()) {
                        this.mSelections.clear();
                        this.mAltSelection = null;
                        this.updateActionsFromSelection();
                        this.redraw();
                    }
                    return;
                }
                boolean redoLayout = false;
                HashSet<CanvasViewInfo> oldSelected = new HashSet<CanvasViewInfo>();
                for (SelectionItem cs : this.mSelections) {
                    oldSelected.add(cs.getViewInfo());
                }
                TreePath[] treePathArray = treeSel.getPaths();
                int n = treePathArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray[n2];
                    Object seg = path.getLastSegment();
                    if (seg instanceof CanvasViewInfo) {
                        CanvasViewInfo newVi = (CanvasViewInfo)seg;
                        if (oldSelected.contains(newVi)) {
                            oldSelected.remove(newVi);
                        } else {
                            this.mAltSelection = null;
                            this.mSelections.add(this.createSelection(newVi));
                            changed = true;
                        }
                        if (newVi.isInvisible()) {
                            redoLayout = true;
                        }
                    } else {
                        return;
                    }
                    ++n2;
                }
                for (CanvasViewInfo vi : oldSelected) {
                    if (vi.isExploded()) {
                        redoLayout = true;
                    }
                    this.deselect(vi);
                    changed = true;
                }
                if (redoLayout) {
                    this.mCanvas.getEditorDelegate().recomputeLayout();
                }
            }
        }
        finally {
            this.mInsideUpdateSelection = false;
        }
        if (changed) {
            this.redraw();
            this.fireSelectionChanged();
            this.updateActionsFromSelection();
        }
    }

    public void menuClick(MenuDetectEvent e) {
        LayoutPoint p = ControlPoint.create(this.mCanvas, e).toLayout();
        for (SelectionItem cs : this.mSelections) {
            if (cs.isRoot() || !cs.getRect().contains(p.x, p.y)) continue;
            return;
        }
        CanvasViewInfo vi = this.mCanvas.getViewHierarchy().findViewInfoAt(p);
        this.selectSingle(vi);
    }

    public void select(MouseEvent e) {
        CanvasViewInfo vi;
        boolean isMultiClick = (e.stateMask & 0x20000) != 0 || SdkConstants.CURRENT_PLATFORM == 3 && (e.stateMask & 0x400000) != 0;
        boolean isCycleClick = (e.stateMask & 0x10000) != 0;
        LayoutPoint p = ControlPoint.create(this.mCanvas, e).toLayout();
        if (e.button == 3) {
            if (!isCycleClick && !isMultiClick) {
                for (SelectionItem cs : this.mSelections) {
                    if (!cs.getRect().contains(p.x, p.y)) continue;
                    return;
                }
            }
        } else if (e.button != 1) {
            return;
        }
        if ((vi = this.mCanvas.getViewHierarchy().findViewInfoAt(p)) != null && vi.isHidden()) {
            vi = vi.getParent();
        }
        if (isMultiClick && !isCycleClick) {
            this.mAltSelection = null;
            if (vi != null) {
                if (this.deselect(vi)) {
                    if (vi.isExploded()) {
                        this.mCanvas.getEditorDelegate().recomputeLayout();
                    }
                    this.redraw();
                    return;
                }
                this.mSelections.add(this.createSelection(vi));
                this.fireSelectionChanged();
                this.redraw();
            }
        } else if (isCycleClick) {
            CanvasViewInfo vi2;
            if (this.mAltSelection == null || this.mAltSelection.getOriginatingView() != vi) {
                this.mAltSelection = new CanvasAlternateSelection(vi, this.mCanvas.getViewHierarchy().findAltViewInfoAt(p));
                this.deselectAll(this.mAltSelection.getAltViews());
                vi2 = this.mAltSelection.getCurrent();
                if (vi2 != null) {
                    this.mSelections.addFirst(this.createSelection(vi2));
                    this.fireSelectionChanged();
                }
            } else {
                vi2 = this.mAltSelection.getCurrent();
                this.deselect(vi2);
                vi2 = this.mAltSelection.getNext();
                if (vi2 != null) {
                    this.mSelections.addFirst(this.createSelection(vi2));
                    this.fireSelectionChanged();
                }
            }
            this.redraw();
        } else {
            this.selectSingle(vi);
        }
    }

    SelectionItem selectSingle(CanvasViewInfo vi) {
        SelectionItem item = null;
        this.mAltSelection = null;
        if (vi == null) {
            vi = this.mCanvas.getViewHierarchy().getRoot();
        }
        boolean redoLayout = this.hasExplodedItems();
        if (!this.mSelections.isEmpty()) {
            if (this.mSelections.size() == 1 && this.mSelections.getFirst().getViewInfo() == vi) {
                return this.mSelections.getFirst();
            }
            this.mSelections.clear();
        }
        if (vi != null) {
            item = this.createSelection(vi);
            this.mSelections.add(item);
            if (vi.isInvisible()) {
                redoLayout = true;
            }
        }
        this.fireSelectionChanged();
        if (redoLayout) {
            this.mCanvas.getEditorDelegate().recomputeLayout();
        }
        this.redraw();
        return item;
    }

    private boolean hasExplodedItems() {
        for (SelectionItem item : this.mSelections) {
            if (!item.getViewInfo().isExploded()) continue;
            return true;
        }
        return false;
    }

    void selectMultiple(Collection<CanvasViewInfo> viewInfos) {
        this.mAltSelection = null;
        boolean redoLayout = this.hasExplodedItems();
        this.mSelections.clear();
        if (viewInfos != null) {
            for (CanvasViewInfo viewInfo : viewInfos) {
                this.mSelections.add(this.createSelection(viewInfo));
                if (!viewInfo.isInvisible()) continue;
                redoLayout = true;
            }
        }
        this.fireSelectionChanged();
        if (redoLayout) {
            this.mCanvas.getEditorDelegate().recomputeLayout();
        }
        this.redraw();
    }

    public void select(Collection<INode> nodes) {
        ArrayList<CanvasViewInfo> infos = new ArrayList<CanvasViewInfo>(nodes.size());
        for (INode node : nodes) {
            CanvasViewInfo info = this.mCanvas.getViewHierarchy().findViewInfoFor(node);
            if (info == null) continue;
            infos.add(info);
        }
        this.selectMultiple(infos);
    }

    void select(Node xmlNode) {
        CanvasViewInfo vi;
        if (xmlNode == null) {
            return;
        }
        if (xmlNode.getNodeType() == 3) {
            xmlNode = xmlNode.getParentNode();
        }
        if ((vi = this.mCanvas.getViewHierarchy().findViewInfoFor(xmlNode)) != null && !vi.isRoot()) {
            this.selectSingle(vi);
        }
    }

    public void selectWithin(LayoutPoint topLeft, LayoutPoint bottomRight, Collection<CanvasViewInfo> toggled) {
        this.mAltSelection = null;
        ViewHierarchy viewHierarchy = this.mCanvas.getViewHierarchy();
        Collection<CanvasViewInfo> viewInfos = viewHierarchy.findWithin(topLeft, bottomRight);
        if (toggled.size() > 0) {
            HashSet<CanvasViewInfo> result = new HashSet<CanvasViewInfo>(toggled);
            for (CanvasViewInfo viewInfo : viewInfos) {
                if (toggled.contains(viewInfo)) {
                    result.remove(viewInfo);
                    continue;
                }
                result.add(viewInfo);
            }
            viewInfos = result;
        }
        this.mSelections.clear();
        for (CanvasViewInfo viewInfo : viewInfos) {
            if (viewInfo.isHidden()) continue;
            this.mSelections.add(this.createSelection(viewInfo));
        }
        this.fireSelectionChanged();
        this.redraw();
    }

    public void selectAll() {
        this.mSelections.clear();
        this.mAltSelection = null;
        for (CanvasViewInfo vi : this.mCanvas.getViewHierarchy().findAllViewInfos(false)) {
            this.mSelections.add(this.createSelection(vi));
        }
        this.fireSelectionChanged();
        this.redraw();
    }

    public void selectNone() {
        this.mSelections.clear();
        this.mAltSelection = null;
        this.fireSelectionChanged();
        this.redraw();
    }

    public void selectParent() {
        CanvasViewInfo parent;
        if (this.mSelections.size() == 1 && (parent = this.mSelections.get(0).getViewInfo().getParent()) != null) {
            this.selectSingle(parent);
        }
    }

    public void selectSameType() {
        if (this.mSelections.size() == 1) {
            CanvasViewInfo viewInfo = this.mSelections.get(0).getViewInfo();
            ElementDescriptor descriptor = viewInfo.getUiViewNode().getDescriptor();
            this.mSelections.clear();
            this.mAltSelection = null;
            this.addSameType(this.mCanvas.getViewHierarchy().getRoot(), descriptor);
            this.fireSelectionChanged();
            this.redraw();
        }
    }

    private void addSameType(CanvasViewInfo root, ElementDescriptor descriptor) {
        if (root.getUiViewNode().getDescriptor() == descriptor) {
            this.mSelections.add(this.createSelection(root));
        }
        for (CanvasViewInfo child : root.getChildren()) {
            this.addSameType(child, descriptor);
        }
    }

    public void selectSiblings() {
        if (this.mSelections.size() == 1) {
            CanvasViewInfo vi = this.mSelections.get(0).getViewInfo();
            this.mSelections.clear();
            this.mAltSelection = null;
            CanvasViewInfo parent = vi.getParent();
            if (parent == null) {
                this.selectNone();
            } else {
                for (CanvasViewInfo child : parent.getChildren()) {
                    this.mSelections.add(this.createSelection(child));
                }
                this.fireSelectionChanged();
                this.redraw();
            }
        }
    }

    public boolean hasMultiSelection() {
        return this.mSelections.size() > 1;
    }

    public boolean deselect(CanvasViewInfo canvasViewInfo) {
        if (canvasViewInfo == null) {
            return false;
        }
        ListIterator it = this.mSelections.listIterator();
        while (it.hasNext()) {
            SelectionItem s = (SelectionItem)it.next();
            if (canvasViewInfo != s.getViewInfo()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private void deselectAll(List<CanvasViewInfo> canvasViewInfos) {
        ListIterator it = this.mSelections.listIterator();
        while (it.hasNext()) {
            SelectionItem s = (SelectionItem)it.next();
            if (!canvasViewInfos.contains(s.getViewInfo())) continue;
            it.remove();
        }
    }

    void sync() {
        ListIterator<SelectionItem> it = this.mSelections.listIterator();
        while (it.hasNext()) {
            SelectionItem s = (SelectionItem)it.next();
            ViewHierarchy viewHierarchy = this.mCanvas.getViewHierarchy();
            UiViewElementNode key = s.getViewInfo().getUiViewNode();
            CanvasViewInfo vi = viewHierarchy.findViewInfoFor(key);
            it.remove();
            if (vi == null) {
                vi = this.findCorresponding(s.getViewInfo(), viewHierarchy.getRoot());
            }
            if (vi == null) continue;
            it.add(this.createSelection(vi));
        }
        this.fireSelectionChanged();
        this.mAltSelection = null;
    }

    private CanvasViewInfo findCorresponding(CanvasViewInfo old, CanvasViewInfo newRoot) {
        CanvasViewInfo oldParent = old.getParent();
        if (oldParent != null) {
            CanvasViewInfo newParent = this.findCorresponding(oldParent, newRoot);
            if (newParent == null) {
                return null;
            }
            List<CanvasViewInfo> oldSiblings = oldParent.getChildren();
            List<CanvasViewInfo> newSiblings = newParent.getChildren();
            Iterator<CanvasViewInfo> oldIterator = oldSiblings.iterator();
            Iterator<CanvasViewInfo> newIterator = newSiblings.iterator();
            while (oldIterator.hasNext() && newIterator.hasNext()) {
                CanvasViewInfo oldSibling = oldIterator.next();
                CanvasViewInfo newSibling = newIterator.next();
                if (oldSibling.getName().equals(newSibling.getName())) {
                    return null;
                }
                if (oldSibling != old) continue;
                return newSibling;
            }
        } else {
            return newRoot;
        }
        return null;
    }

    private void fireSelectionChanged() {
        if (this.mInsideUpdateSelection) {
            return;
        }
        try {
            this.mInsideUpdateSelection = true;
            final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    Object[] objectArray = SelectionManager.this.mSelectionListeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object listener = objectArray[n2];
                        ((ISelectionChangedListener)listener).selectionChanged(event);
                        ++n2;
                    }
                }
            });
            this.updateActionsFromSelection();
        }
        finally {
            this.mInsideUpdateSelection = false;
        }
    }

    private void updateActionsFromSelection() {
        LayoutEditorDelegate editor = this.mCanvas.getEditorDelegate();
        if (editor != null) {
            this.mCanvas.updateMenuActionState();
            LayoutActionBar layoutActionBar = editor.getGraphicalEditor().getLayoutActionBar();
            layoutActionBar.updateSelection();
        }
    }

    static void sanitize(List<SelectionItem> selection) {
        if (selection.isEmpty()) {
            return;
        }
        Iterator<SelectionItem> it = selection.iterator();
        block0: while (it.hasNext()) {
            Node node;
            SelectionItem cs = it.next();
            CanvasViewInfo vi = cs.getViewInfo();
            UiViewElementNode key = vi == null ? null : vi.getUiViewNode();
            Node node2 = node = key == null ? null : key.getXmlNode();
            if (node == null) {
                it.remove();
                continue;
            }
            if (vi == null) continue;
            for (SelectionItem cs2 : selection) {
                CanvasViewInfo vi2;
                if (cs == cs2 || !vi.isParent(vi2 = cs2.getViewInfo())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    public boolean selectDropped(List<INode> nodes, List<Integer> indices) {
        boolean found;
        assert (indices == null || nodes.size() == indices.size());
        ViewHierarchy viewHierarchy = this.mCanvas.getViewHierarchy();
        ArrayList<CanvasViewInfo> newChildren = new ArrayList<CanvasViewInfo>();
        int i = 0;
        int n = nodes.size();
        while (i < n) {
            UiViewElementNode parentUiNode;
            INode parent;
            CanvasViewInfo parentViewInfo;
            INode node = nodes.get(i);
            CanvasViewInfo viewInfo = viewHierarchy.findViewInfoFor(node);
            if (viewInfo == null && node instanceof NodeProxy && indices != null && (parentViewInfo = viewHierarchy.findViewInfoFor(parent = node.getParent())) != null && (parentUiNode = parentViewInfo.getUiViewNode()) != null) {
                List<UiElementNode> children = parentUiNode.getUiChildren();
                int index = indices.get(i);
                if (index >= 0 && index < children.size()) {
                    UiElementNode replacedNode = children.get(index);
                    viewInfo = viewHierarchy.findViewInfoFor(replacedNode);
                }
            }
            if (!(viewInfo == null || nodes.size() > 1 && viewInfo.isHidden() || GridLayoutRule.sDebugGridLayout && (viewInfo.getName().equals("android.widget.Space") || viewInfo.getName().equals("android.support.v7.widget.Space")))) {
                newChildren.add(viewInfo);
            }
            ++i;
        }
        boolean bl = found = nodes.size() == newChildren.size();
        if (found || newChildren.size() > 0) {
            this.mCanvas.getSelectionManager().selectMultiple(newChildren);
        }
        return found;
    }

    public void setOutlineSelection(final List<INode> nodes) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionManager.this.selectDropped(nodes, null);
                SelectionManager.this.syncOutlineSelection();
            }
        });
    }

    public void syncOutlineSelection() {
        OutlinePage outlinePage = this.mCanvas.getOutlinePage();
        IWorkbenchPartSite site = outlinePage.getEditor().getSite();
        ISelectionProvider selectionProvider = site.getSelectionProvider();
        ISelection selection = selectionProvider.getSelection();
        if (selection != null) {
            outlinePage.setSelection(selection);
        }
    }

    private void redraw() {
        this.mCanvas.redraw();
    }

    SelectionItem createSelection(CanvasViewInfo vi) {
        return new SelectionItem(this.mCanvas, vi);
    }

    public boolean isEmpty() {
        return this.mSelections.size() == 0;
    }

    public Pair<SelectionItem, SelectionHandle> findHandle(ControlPoint controlPoint) {
        if (!this.isEmpty()) {
            LayoutPoint layoutPoint = controlPoint.toLayout();
            int distance = (int)(5.0 / this.mCanvas.getScale());
            for (SelectionItem item : this.getSelections()) {
                SelectionHandles handles = item.getSelectionHandles();
                SelectionHandle handle = handles.findHandle(layoutPoint, distance);
                if (handle == null) continue;
                return Pair.of((Object)item, (Object)handle);
            }
        }
        return null;
    }

    public void performDefaultAction() {
        NodeProxy primary;
        List<SelectionItem> selections = this.getSelections();
        if (selections.size() > 0 && (primary = selections.get(0).getNode()) != null) {
            RulesEngine rulesEngine = this.mCanvas.getRulesEngine();
            String id = rulesEngine.callGetDefaultActionId(primary);
            if (id == null) {
                return;
            }
            List<RuleAction> actions = rulesEngine.callGetContextMenu(primary);
            if (actions == null) {
                return;
            }
            RuleAction matching = null;
            for (RuleAction a : actions) {
                if (!id.equals(a.getId())) continue;
                matching = a;
                break;
            }
            if (matching == null) {
                return;
            }
            final ArrayList<NodeProxy> selectedNodes = new ArrayList<NodeProxy>();
            for (SelectionItem item : selections) {
                NodeProxy n = item.getNode();
                if (n == null) continue;
                selectedNodes.add(n);
            }
            final RuleAction action = matching;
            this.mCanvas.getEditorDelegate().getEditor().wrapUndoEditXmlModel(action.getTitle(), new Runnable(){

                @Override
                public void run() {
                    action.getCallback().action(action, selectedNodes, action.getId(), null);
                    LayoutCanvas canvas = SelectionManager.this.mCanvas;
                    CanvasViewInfo root = canvas.getViewHierarchy().getRoot();
                    if (root != null) {
                        UiViewElementNode uiViewNode = root.getUiViewNode();
                        NodeFactory nodeFactory = canvas.getNodeFactory();
                        NodeProxy rootNode = nodeFactory.create(uiViewNode);
                        if (rootNode != null) {
                            rootNode.applyPendingChanges();
                        }
                    }
                }
            });
        }
    }

    public void performRename() {
        NodeProxy primary;
        List<SelectionItem> selections = this.getSelections();
        if (selections.size() > 0 && (primary = selections.get(0).getNode()) != null) {
            this.performRename(primary, selections);
        }
    }

    public RenameResult performRename(final INode primary, final List<SelectionItem> selections) {
        String id = primary.getStringAttr("http://schemas.android.com/apk/res/android", "id");
        if (id != null && !id.isEmpty()) {
            RenameResult result = RenameResourceWizard.renameResource(this.mCanvas.getShell(), this.mCanvas.getEditorDelegate().getGraphicalEditor().getProject(), ResourceType.ID, BaseViewRule.stripIdPrefix(id), null, true);
            if (result.isCanceled()) {
                return result;
            }
            if (!result.isUnavailable()) {
                return result;
            }
        }
        String currentId = primary.getStringAttr("http://schemas.android.com/apk/res/android", "id");
        currentId = BaseViewRule.stripIdPrefix(currentId);
        InputDialog d = new InputDialog(AndmoreAndroidPlugin.getDisplay().getActiveShell(), "Set ID", "New ID:", currentId, (IInputValidator)ResourceNameValidator.create(false, null, ResourceType.ID));
        if (d.open() == 0) {
            final String s = d.getValue();
            this.mCanvas.getEditorDelegate().getEditor().wrapUndoEditXmlModel("Set ID", new Runnable(){

                @Override
                public void run() {
                    String newId = s;
                    newId = "@+id/" + BaseViewRule.stripIdPrefix(s);
                    if (selections != null) {
                        for (SelectionItem item : selections) {
                            NodeProxy node = item.getNode();
                            if (node == null) continue;
                            node.setAttribute("http://schemas.android.com/apk/res/android", "id", newId);
                        }
                    } else {
                        primary.setAttribute("http://schemas.android.com/apk/res/android", "id", newId);
                    }
                    LayoutCanvas canvas = SelectionManager.this.mCanvas;
                    CanvasViewInfo root = canvas.getViewHierarchy().getRoot();
                    if (root != null) {
                        UiViewElementNode uiViewNode = root.getUiViewNode();
                        NodeFactory nodeFactory = canvas.getNodeFactory();
                        NodeProxy rootNode = nodeFactory.create(uiViewNode);
                        if (rootNode != null) {
                            rootNode.applyPendingChanges();
                        }
                    }
                }
            });
            return RenameResult.name(BaseViewRule.stripIdPrefix(s));
        }
        return RenameResult.canceled();
    }

    private class SelectAction
    extends Action {
        private final int mType;

        public SelectAction(String title, int type) {
            super(title, 1);
            this.mType = type;
        }

        public void run() {
            switch (this.mType) {
                case 4: {
                    SelectionManager.this.selectNone();
                    break;
                }
                case 1: {
                    SelectionManager.this.selectParent();
                    break;
                }
                case 3: {
                    SelectionManager.this.selectSameType();
                    break;
                }
                case 2: {
                    SelectionManager.this.selectSiblings();
                }
            }
            ArrayList<INode> nodes = new ArrayList<INode>();
            for (SelectionItem item : SelectionManager.this.getSelections()) {
                nodes.add(item.getNode());
            }
            SelectionManager.this.setOutlineSelection(nodes);
        }
    }

    public static class SelectionMenu
    extends SubmenuAction {
        private final GraphicalEditorPart mEditor;

        public SelectionMenu(GraphicalEditorPart editor) {
            super("Select");
            this.mEditor = editor;
        }

        public String getId() {
            return "-selectionmenu";
        }

        @Override
        protected void addMenuItems(Menu menu) {
            LayoutCanvas canvas = this.mEditor.getCanvasControl();
            SelectionManager selectionManager = canvas.getSelectionManager();
            List<SelectionItem> selections = selectionManager.getSelections();
            boolean selectedOne = selections.size() == 1;
            boolean notRoot = selectedOne && !selections.get(0).isRoot();
            boolean haveSelection = selections.size() > 0;
            SelectionManager selectionManager2 = selectionManager;
            selectionManager2.getClass();
            SelectAction a = selectionManager2.new SelectAction("Select Parent\tEsc", 1);
            new ActionContributionItem((IAction)a).fill(menu, -1);
            a.setEnabled(notRoot);
            a.setAccelerator(27);
            SelectionManager selectionManager3 = selectionManager;
            selectionManager3.getClass();
            a = selectionManager3.new SelectAction("Select Siblings", 2);
            new ActionContributionItem((IAction)a).fill(menu, -1);
            a.setEnabled(notRoot);
            SelectionManager selectionManager4 = selectionManager;
            selectionManager4.getClass();
            a = selectionManager4.new SelectAction("Select Same Type", 3);
            new ActionContributionItem((IAction)a).fill(menu, -1);
            a.setEnabled(selectedOne);
            new Separator().fill(menu, -1);
            a = canvas.getSelectAllAction();
            new ActionContributionItem((IAction)a).fill(menu, -1);
            a.setEnabled(true);
            SelectionManager selectionManager5 = selectionManager;
            selectionManager5.getClass();
            a = selectionManager5.new SelectAction("Deselect All", 4);
            new ActionContributionItem((IAction)a).fill(menu, -1);
            a.setEnabled(haveSelection);
        }
    }
}

