/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gre;

import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleAttribute;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Element;

public class PaletteMetadataDescriptor
extends ViewElementDescriptor {
    private String mInitString;
    private String mIconName;

    public PaletteMetadataDescriptor(ViewElementDescriptor descriptor, String displayName, String initString, String iconName) {
        super(descriptor.getXmlName(), displayName, descriptor.getFullClassName(), descriptor.getTooltip(), descriptor.getSdkUrl(), descriptor.getAttributes(), descriptor.getLayoutAttributes(), descriptor.getChildren(), descriptor.getMandatory() == ElementDescriptor.Mandatory.MANDATORY);
        this.mInitString = initString;
        this.mIconName = iconName;
        this.setSuperClass(descriptor.getSuperClassDesc());
    }

    public String getInitializedAttributes() {
        return this.mInitString != null ? this.mInitString : "";
    }

    @Override
    public Image getGenericIcon() {
        IconFactory factory;
        Image icon;
        if (this.mIconName != null && (icon = (factory = IconFactory.getInstance()).getIcon(this.mIconName)) != null) {
            return icon;
        }
        return super.getGenericIcon();
    }

    public void initializeNew(SimpleElement element) {
        this.initializeNew(element, null);
    }

    public void initializeNew(Element element) {
        this.initializeNew(null, element);
    }

    private void initializeNew(SimpleElement simpleElement, Element domElement) {
        String initializedAttributes = this.mInitString;
        if (initializedAttributes != null && initializedAttributes.length() > 0) {
            String[] stringArray = initializedAttributes.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] nameValue = s.split("=");
                String name = nameValue[0];
                String value = nameValue[1];
                String nameSpace = "";
                if (name.startsWith("android:")) {
                    name = name.substring("android:".length());
                    nameSpace = "http://schemas.android.com/apk/res/android";
                }
                if (simpleElement != null) {
                    SimpleAttribute attr = new SimpleAttribute(nameSpace, name, value);
                    simpleElement.addAttribute(attr);
                }
                if (domElement != null) {
                    domElement.setAttributeNS(nameSpace, name, value);
                }
                ++n2;
            }
        }
    }
}

