/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.gre;

import com.android.ide.common.api.DropFeedback;
import com.android.ide.common.api.IClientRulesEngine;
import com.android.ide.common.api.IDragElement;
import com.android.ide.common.api.IGraphics;
import com.android.ide.common.api.INode;
import com.android.ide.common.api.IViewRule;
import com.android.ide.common.api.InsertType;
import com.android.ide.common.api.Point;
import com.android.ide.common.api.Rect;
import com.android.ide.common.api.RuleAction;
import com.android.ide.common.api.SegmentType;
import com.android.sdklib.IAndroidTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.layout.ViewRule;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.GCWrapper;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.SimpleElement;
import org.eclipse.andmore.internal.editors.layout.gre.ClientRulesEngine;
import org.eclipse.andmore.internal.editors.layout.gre.NodeProxy;
import org.eclipse.andmore.internal.editors.layout.gre.RuleLoader;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;

public class RulesEngine {
    private final IProject mProject;
    private final Map<Object, IViewRule> mRulesCache = new HashMap<Object, IViewRule>();
    private InsertType mInsertType = InsertType.CREATE;
    private RuleLoader mRuleLoader;
    private ClassLoader mUserClassLoader;
    private final GraphicalEditorPart mEditor;

    public RulesEngine(GraphicalEditorPart editor, IProject project) {
        this.mProject = project;
        this.mEditor = editor;
        this.mRuleLoader = RuleLoader.get(project);
    }

    public IProject getProject() {
        return this.mProject;
    }

    public GraphicalEditorPart getEditor() {
        return this.mEditor;
    }

    public void dispose() {
        this.clearCache();
    }

    public String callGetDisplayName(UiViewElementNode element) {
        IViewRule rule = this.loadRule(element);
        if (rule != null) {
            try {
                return rule.getDisplayName();
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.getDisplayName() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public List<RuleAction> callGetContextMenu(NodeProxy selectedNode) {
        IViewRule rule = this.loadRule(selectedNode.getNode());
        if (rule != null) {
            try {
                this.mInsertType = InsertType.CREATE;
                ArrayList<RuleAction> actions = new ArrayList<RuleAction>();
                rule.addContextMenuActions(actions, (INode)selectedNode);
                Collections.sort(actions);
                return actions;
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.getContextMenu() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public String callGetDefaultActionId(NodeProxy selectedNode) {
        IViewRule rule = this.loadRule(selectedNode.getNode());
        if (rule != null) {
            try {
                this.mInsertType = InsertType.CREATE;
                return rule.getDefaultActionId((INode)selectedNode);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.getDefaultAction() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public List<RuleAction> callAddLayoutActions(List<RuleAction> actions, NodeProxy parentNode, List<NodeProxy> children) {
        IViewRule rule = this.loadRule(parentNode.getNode());
        if (rule != null) {
            try {
                this.mInsertType = InsertType.CREATE;
                rule.addLayoutActions(actions, (INode)parentNode, children);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.getContextMenu() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public List<String> callGetSelectionHint(NodeProxy parentNode, NodeProxy childNode) {
        IViewRule rule = this.loadRule(parentNode.getNode());
        if (rule != null) {
            try {
                return rule.getSelectionHint((INode)parentNode, (INode)childNode);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.getSelectionHint() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public void callPaintSelectionFeedback(GCWrapper gcWrapper, NodeProxy parentNode, List<? extends INode> childNodes, Object view) {
        IViewRule rule = this.loadRule(parentNode.getNode());
        if (rule != null) {
            try {
                rule.paintSelectionFeedback((IGraphics)gcWrapper, (INode)parentNode, childNodes, view);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.callPaintSelectionFeedback() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
    }

    public DropFeedback callOnDropEnter(NodeProxy targetNode, Object targetView, IDragElement[] elements) {
        IViewRule rule = this.loadRule(targetNode.getNode());
        if (rule != null) {
            try {
                return rule.onDropEnter((INode)targetNode, targetView, elements);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onDropEnter() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public DropFeedback callOnDropMove(NodeProxy targetNode, IDragElement[] elements, DropFeedback feedback, Point where) {
        IViewRule rule = this.loadRule(targetNode.getNode());
        if (rule != null) {
            try {
                return rule.onDropMove((INode)targetNode, elements, feedback, where);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onDropMove() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public void callOnDropLeave(NodeProxy targetNode, IDragElement[] elements, DropFeedback feedback) {
        IViewRule rule = this.loadRule(targetNode.getNode());
        if (rule != null) {
            try {
                rule.onDropLeave((INode)targetNode, elements, feedback);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onDropLeave() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
    }

    public void callOnDropped(NodeProxy targetNode, IDragElement[] elements, DropFeedback feedback, Point where, InsertType insertType) {
        IViewRule rule = this.loadRule(targetNode.getNode());
        if (rule != null) {
            try {
                this.mInsertType = insertType;
                rule.onDropped((INode)targetNode, elements, feedback, where);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onDropped() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
    }

    public void callDropFeedbackPaint(IGraphics gc, NodeProxy targetNode, DropFeedback feedback) {
        if (gc != null && feedback != null && feedback.painter != null) {
            try {
                feedback.painter.paint(gc, (INode)targetNode, feedback);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "DropFeedback.painter failed: %s", e.toString());
            }
        }
    }

    public NodeProxy callOnPaste(NodeProxy targetNode, Object targetView, SimpleElement[] pastedElements) {
        NodeProxy parent = targetNode;
        while (parent instanceof NodeProxy) {
            ElementDescriptor descriptor;
            NodeProxy np = parent;
            if (np.getNode() != null && np.getNode().getDescriptor() != null && (descriptor = np.getNode().getDescriptor()).hasChildren()) {
                targetNode = np;
                break;
            }
            parent = parent.getParent();
        }
        IViewRule rule = this.loadRule(targetNode.getNode());
        if (rule != null) {
            try {
                this.mInsertType = InsertType.PASTE;
                rule.onPaste((INode)targetNode, targetView, (IDragElement[])pastedElements);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onPaste() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return targetNode;
    }

    public DropFeedback callOnResizeBegin(NodeProxy child, NodeProxy parent, Rect newBounds, SegmentType horizontalEdge, SegmentType verticalEdge, Object childView, Object parentView) {
        IViewRule rule = this.loadRule(parent.getNode());
        if (rule != null) {
            try {
                return rule.onResizeBegin((INode)child, (INode)parent, horizontalEdge, verticalEdge, childView, parentView);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onResizeBegin() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
        return null;
    }

    public void callOnResizeUpdate(DropFeedback feedback, NodeProxy child, NodeProxy parent, Rect newBounds, int modifierMask) {
        IViewRule rule = this.loadRule(parent.getNode());
        if (rule != null) {
            try {
                rule.onResizeUpdate(feedback, (INode)child, (INode)parent, newBounds, modifierMask);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onResizeUpdate() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
    }

    public void callOnResizeEnd(DropFeedback feedback, NodeProxy child, NodeProxy parent, Rect newBounds) {
        IViewRule rule = this.loadRule(parent.getNode());
        if (rule != null) {
            try {
                rule.onResizeEnd(feedback, (INode)child, (INode)parent, newBounds);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onResizeEnd() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
    }

    public void callCreateHooks(AndroidXmlEditor editor, NodeProxy parentNode, NodeProxy childNode, InsertType overrideInsertType) {
        UiViewElementNode newUiNode;
        IViewRule childRule;
        IViewRule parentRule = null;
        if (parentNode != null) {
            UiViewElementNode parentUiNode = parentNode.getNode();
            parentRule = this.loadRule(parentUiNode);
        }
        if (overrideInsertType != null) {
            this.mInsertType = overrideInsertType;
        }
        if ((childRule = this.loadRule(newUiNode = childNode.getNode())) != null || parentRule != null) {
            RulesEngine.callCreateHooks(editor, this.mInsertType, parentRule, parentNode, childRule, childNode);
        }
    }

    private static void callCreateHooks(final AndroidXmlEditor editor, final InsertType insertType, final IViewRule parentRule, final INode parentNode, final IViewRule childRule, final INode newNode) {
        if (!editor.isEditXmlModelPending()) {
            editor.wrapEditXmlModel(new Runnable(){

                @Override
                public void run() {
                    RulesEngine.callCreateHooks(editor, insertType, parentRule, parentNode, childRule, newNode);
                }
            });
            return;
        }
        if (parentRule != null) {
            parentRule.onChildInserted(newNode, parentNode, insertType);
        }
        if (childRule != null) {
            childRule.onCreate(newNode, parentNode, insertType);
        }
        if (parentNode != null) {
            ((NodeProxy)parentNode).applyPendingChanges();
        }
    }

    public void setInsertType(InsertType insertType) {
        this.mInsertType = insertType;
    }

    public InsertType getInsertType() {
        return this.mInsertType;
    }

    public void callOnRemovingChildren(NodeProxy parentNode, List<INode> children) {
        UiViewElementNode parentUiNode;
        IViewRule parentRule;
        if (parentNode != null && (parentRule = this.loadRule(parentUiNode = parentNode.getNode())) != null) {
            try {
                parentRule.onRemovingChildren(children, (INode)parentNode, this.mInsertType == InsertType.MOVE_WITHIN);
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onDispose() failed: %s", parentRule.getClass().getSimpleName(), e.toString());
            }
        }
    }

    private ViewElementDescriptor getBaseViewDescriptor() {
        IAndroidTarget target;
        Sdk currentSdk = Sdk.getCurrent();
        if (currentSdk != null && (target = currentSdk.getTarget(this.mProject)) != null) {
            AndroidTargetData data = currentSdk.getTargetData(target);
            return data.getLayoutDescriptors().getBaseViewDescriptor();
        }
        return null;
    }

    private void clearCache() {
        HashSet<IViewRule> rules = new HashSet<IViewRule>(this.mRulesCache.values());
        this.mRulesCache.clear();
        for (IViewRule rule : rules) {
            if (rule == null) continue;
            try {
                rule.onDispose();
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "%s.onDispose() failed: %s", rule.getClass().getSimpleName(), e.toString());
            }
        }
    }

    private ClassLoader updateClassLoader() {
        ClassLoader classLoader = this.mRuleLoader.getClassLoader();
        if (this.mUserClassLoader != null && classLoader != this.mUserClassLoader) {
            ArrayList<Object> dispose = new ArrayList<Object>();
            for (Map.Entry<Object, IViewRule> entry : this.mRulesCache.entrySet()) {
                IViewRule rule = entry.getValue();
                if (rule.getClass().getClassLoader() != this.mUserClassLoader) continue;
                dispose.add(entry.getKey());
            }
            for (Map.Entry<Object, Object> entry : dispose) {
                this.mRulesCache.remove(entry);
            }
        }
        this.mUserClassLoader = classLoader;
        return this.mUserClassLoader;
    }

    private IViewRule loadRule(UiViewElementNode element) {
        if (element == null) {
            return null;
        }
        String targetFqcn = null;
        ViewElementDescriptor targetDesc = null;
        ElementDescriptor d = element.getDescriptor();
        if (d instanceof ViewElementDescriptor) {
            targetDesc = (ViewElementDescriptor)d;
        }
        if (d == null || !(d instanceof ViewElementDescriptor)) {
            targetDesc = this.getBaseViewDescriptor();
        }
        this.updateClassLoader();
        IViewRule rule = this.mRulesCache.get(targetDesc);
        if (rule != null || this.mRulesCache.containsKey(targetDesc)) {
            return rule;
        }
        ViewElementDescriptor desc = targetDesc;
        while (desc != null) {
            String fqcn = desc.getFullClassName();
            if (fqcn == null) {
                return null;
            }
            if (targetFqcn == null) {
                targetFqcn = fqcn;
            }
            if (fqcn.indexOf(46) == -1) {
                fqcn = "android.widget." + fqcn;
            }
            if ((rule = this.loadRule(fqcn, targetFqcn)) != null) {
                return rule;
            }
            desc = desc.getSuperClassDesc();
        }
        this.mRulesCache.put(targetDesc, null);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    IViewRule loadRule(String realFqcn, String targetFqcn) {
        if (realFqcn == null || targetFqcn == null) {
            return null;
        }
        IViewRule rule = this.mRulesCache.get(realFqcn);
        if (rule != null || this.mRulesCache.containsKey(realFqcn)) {
            return rule;
        }
        try {
            String ruleClassName;
            ClassLoader classLoader;
            if (realFqcn.startsWith("android.") || realFqcn.equals("merge") || realFqcn.endsWith(".GridLayout") || realFqcn.startsWith("com.google.android.maps.")) {
                String packageName = ViewRule.class.getName();
                packageName = packageName.substring(0, packageName.lastIndexOf(46));
                classLoader = RulesEngine.class.getClassLoader();
                int dotIndex = realFqcn.lastIndexOf(46);
                String baseName = realFqcn.substring(dotIndex + 1);
                if (Character.isLowerCase(baseName.charAt(0))) {
                    if (baseName.equals("view")) {
                        baseName = "ViewTag";
                    }
                    baseName = String.valueOf(Character.toUpperCase(baseName.charAt(0))) + baseName.substring(1);
                }
                ruleClassName = String.valueOf(packageName) + "." + baseName + "Rule";
            } else {
                classLoader = this.updateClassLoader();
                if (classLoader == null) {
                    this.mRulesCache.put(realFqcn, null);
                    return null;
                }
                ruleClassName = String.valueOf(realFqcn) + "Rule";
            }
            Class<?> clz = Class.forName(ruleClassName, true, classLoader);
            rule = (IViewRule)clz.newInstance();
            return this.initializeRule(rule, targetFqcn);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException e) {
            AndmoreAndroidPlugin.log(e, "load rule error (%s): %s", realFqcn, e.toString());
        }
        catch (IllegalAccessException e) {
            AndmoreAndroidPlugin.log(e, "load rule error (%s): %s", realFqcn, e.toString());
        }
        this.mRulesCache.put(realFqcn, null);
        return null;
    }

    private IViewRule initializeRule(IViewRule rule, String targetFqcn) {
        try {
            if (rule.onInitialize(targetFqcn, (IClientRulesEngine)new ClientRulesEngine(this, targetFqcn))) {
                this.mRulesCache.put(targetFqcn, rule);
                return rule;
            }
            rule.onDispose();
        }
        catch (Exception e) {
            AndmoreAndroidPlugin.log(e, "%s.onInit() failed: %s", rule.getClass().getSimpleName(), e.toString());
        }
        return null;
    }
}

