/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.properties;

import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.ListAttributeDescriptor;
import org.eclipse.andmore.internal.editors.layout.properties.XmlProperty;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.ITextValuePropertyEditor;

class EnumXmlPropertyEditor
extends AbstractComboPropertyEditor
implements ITextValuePropertyEditor {
    public static final EnumXmlPropertyEditor INSTANCE = new EnumXmlPropertyEditor();

    private EnumXmlPropertyEditor() {
    }

    protected String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value == Property.UNKNOWN_VALUE) {
            return "<varies>";
        }
        return "";
    }

    private String[] getItems(Property property) {
        XmlProperty xmlProperty = (XmlProperty)property;
        AttributeDescriptor descriptor = xmlProperty.getDescriptor();
        assert (descriptor instanceof ListAttributeDescriptor);
        ListAttributeDescriptor list = (ListAttributeDescriptor)descriptor;
        return list.getValues();
    }

    protected void addItems(Property property, CCombo3 combo) throws Exception {
        String[] stringArray = this.getItems(property);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            combo.add(item);
            ++n2;
        }
    }

    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        property.setValue((Object)this.getItems(property)[index]);
    }

    public void setText(Property property, String text) throws Exception {
        property.setValue((Object)text);
    }
}

