/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.properties;

import com.android.ide.common.api.IAttributeInfo;
import java.util.Map;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.layout.gle2.GraphicalEditorPart;
import org.eclipse.andmore.internal.editors.layout.gle2.ViewHierarchy;
import org.eclipse.andmore.internal.editors.layout.properties.PropertyFactory;
import org.eclipse.andmore.internal.editors.layout.properties.PropertyValueCompleter;
import org.eclipse.andmore.internal.editors.layout.properties.ResourceValueCompleter;
import org.eclipse.andmore.internal.editors.layout.properties.XmlPropertyComposite;
import org.eclipse.andmore.internal.editors.layout.uimodel.UiViewElementNode;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class XmlProperty
extends Property {
    private PropertyFactory mFactory;
    final AttributeDescriptor mDescriptor;
    private UiViewElementNode mNode;
    private Property mParent;

    XmlProperty(PropertyEditor editor, PropertyFactory factory, UiViewElementNode node, AttributeDescriptor descriptor) {
        super(editor);
        this.mFactory = factory;
        this.mNode = node;
        this.mDescriptor = descriptor;
    }

    public PropertyFactory getFactory() {
        return this.mFactory;
    }

    public UiViewElementNode getNode() {
        return this.mNode;
    }

    public AttributeDescriptor getDescriptor() {
        return this.mDescriptor;
    }

    public String getName() {
        return this.mDescriptor.getXmlLocalName();
    }

    public String getTitle() {
        int parentTitleLength;
        String parentTitle;
        String name = this.mDescriptor.getXmlLocalName();
        int nameLength = name.length();
        if (name.startsWith("layout_")) {
            name = name.startsWith("layout_margin") && nameLength > "layout_margin".length() ? name.substring("layout_margin".length()) : name.substring("layout_".length());
        }
        name = DescriptorsUtils.capitalize(name);
        if (this.mParent != null && name.startsWith(parentTitle = this.mParent.getTitle()) && (parentTitleLength = parentTitle.length()) < nameLength) {
            if (nameLength > parentTitleLength && Character.isWhitespace(name.charAt(parentTitleLength))) {
                ++parentTitleLength;
            }
            name = name.substring(parentTitleLength);
        }
        return name;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == PropertyTooltipProvider.class) {
            return adapter.cast(new PropertyTooltipTextProvider(){

                protected String getText(Property p) throws Exception {
                    if (XmlProperty.this.mDescriptor instanceof IPropertyDescriptor) {
                        IPropertyDescriptor d = (IPropertyDescriptor)XmlProperty.this.mDescriptor;
                        return d.getDescription();
                    }
                    return null;
                }
            });
        }
        if (adapter == IContentProposalProvider.class) {
            IAttributeInfo info = this.mDescriptor.getAttributeInfo();
            if (info != null) {
                return adapter.cast(new PropertyValueCompleter(this));
            }
            return adapter.cast(new ResourceValueCompleter(this));
        }
        if (adapter == ILabelProvider.class) {
            return adapter.cast(new LabelProvider(){

                public Image getImage(Object element) {
                    return AndmoreAndroidPlugin.getAndroidLogo();
                }

                public String getText(Object element) {
                    return ((IContentProposal)element).getLabel();
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }

    public boolean isModified() throws Exception {
        Element element;
        block4: {
            Object s = null;
            try {
                element = (Element)this.mNode.getXmlNode();
                if (element != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return s != null && s.toString().length() > 0;
            }
        }
        String name = this.mDescriptor.getXmlLocalName();
        String uri = this.mDescriptor.getNamespaceUri();
        if (uri != null) {
            return element.hasAttributeNS(uri, name);
        }
        return element.hasAttribute(name);
    }

    public String getStringValue() {
        Element element = (Element)this.mNode.getXmlNode();
        if (element == null) {
            return null;
        }
        String name = this.mDescriptor.getXmlLocalName();
        String uri = this.mDescriptor.getNamespaceUri();
        Attr attr = uri != null ? element.getAttributeNodeNS(uri, name) : element.getAttributeNode(name);
        if (attr != null) {
            return attr.getValue();
        }
        Object viewObject = this.getFactory().getCurrentViewObject();
        if (viewObject != null) {
            GraphicalEditorPart graphicalEditor = this.getGraphicalEditor();
            if (graphicalEditor == null) {
                return null;
            }
            ViewHierarchy views = graphicalEditor.getCanvasControl().getViewHierarchy();
            Map<String, String> defaultProperties = views.getDefaultProperties(viewObject);
            if (defaultProperties != null) {
                return defaultProperties.get(name);
            }
        }
        return null;
    }

    public Object getValue() throws Exception {
        return this.getStringValue();
    }

    public void setValue(Object value) throws Exception {
        CommonXmlEditor editor = this.getXmlEditor();
        if (editor == null) {
            return;
        }
        final String attribute = this.mDescriptor.getXmlLocalName();
        final String xmlValue = value != null && value != UNKNOWN_VALUE ? value.toString() : null;
        editor.wrapUndoEditXmlModel(String.format("Set \"%1$s\" to \"%2$s\"", attribute, xmlValue), new Runnable(){

            @Override
            public void run() {
                XmlProperty.this.mNode.setAttributeValue(attribute, XmlProperty.this.mDescriptor.getNamespaceUri(), xmlValue, true);
                XmlProperty.this.mNode.commitDirtyAttributesToXml();
            }
        });
    }

    public Property getComposite(Property[] properties) {
        return XmlPropertyComposite.create(properties);
    }

    GraphicalEditorPart getGraphicalEditor() {
        return this.mFactory.getGraphicalEditor();
    }

    CommonXmlEditor getXmlEditor() {
        GraphicalEditorPart graphicalEditor = this.getGraphicalEditor();
        if (graphicalEditor != null) {
            return graphicalEditor.getEditorDelegate().getEditor();
        }
        return null;
    }

    public Property getParent() {
        return this.mParent;
    }

    public void setParent(Property parent) {
        this.mParent = parent;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ":" + this.getPriority();
    }
}

