/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.internal.editors.descriptors.AttributeDescriptor;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.refactoring.ChangeViewWizard;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoring;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoringWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ChangeViewRefactoring
extends VisualRefactoring {
    private static final String KEY_TYPE = "type";
    private String mTypeFqcn;

    ChangeViewRefactoring(Map<String, String> arguments) {
        super(arguments);
        this.mTypeFqcn = arguments.get(KEY_TYPE);
    }

    public ChangeViewRefactoring(IFile file, LayoutEditorDelegate delegate, ITextSelection selection, ITreeSelection treeSelection) {
        super(file, delegate, selection, treeSelection);
    }

    public ChangeViewRefactoring(List<Element> selectedElements, LayoutEditorDelegate editor) {
        super(selectedElements, editor);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            List<CanvasViewInfo> infos;
            pm.beginTask("Checking preconditions...", 6);
            if (this.mSelectionStart == -1 || this.mSelectionEnd == -1) {
                status.addFatalError("No selection to convert");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mTreeSelection != null && !this.validateNotEmpty(infos = this.getSelectedViewInfos(), status)) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mElements.size() == 0) {
                status.addFatalError("Nothing to convert");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected VisualRefactoring.VisualRefactoringDescriptor createDescriptor() {
        String comment = this.getName();
        return new Descriptor(this.mProject.getName(), comment, comment, this.createArgumentMap());
    }

    @Override
    protected Map<String, String> createArgumentMap() {
        Map<String, String> args = super.createArgumentMap();
        args.put(KEY_TYPE, this.mTypeFqcn);
        return args;
    }

    public String getName() {
        return "Change Widget Type";
    }

    public void setType(String typeFqcn) {
        this.mTypeFqcn = typeFqcn;
    }

    @Override
    public List<Change> computeChanges(IProgressMonitor monitor) {
        String name = this.getViewClass(this.mTypeFqcn);
        IFile file = this.mDelegate.getEditor().getInputFile();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (file == null) {
            return changes;
        }
        TextFileChange change = new TextFileChange(file.getName(), file);
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setEdit((TextEdit)rootEdit);
        change.setTextType("xml");
        changes.add((Change)change);
        for (Element element : this.getElements()) {
            int oldLength;
            IndexedRegion region = ChangeViewRefactoring.getRegion(element);
            String text = this.getText(region.getStartOffset(), region.getEndOffset());
            String oldName = element.getNodeName();
            int open = text.indexOf(oldName);
            int close = text.lastIndexOf(oldName);
            if (element instanceof ElementImpl && ((ElementImpl)element).isEmptyTag()) {
                close = -1;
            }
            if (open != -1) {
                oldLength = oldName.length();
                rootEdit.addChild((TextEdit)new ReplaceEdit(region.getStartOffset() + open, oldLength, name));
            }
            if (close != -1 && close != open) {
                oldLength = oldName.length();
                rootEdit.addChild((TextEdit)new ReplaceEdit(region.getStartOffset() + close, oldLength, name));
            }
            String oldId = ChangeViewRefactoring.getId(element);
            String newId = this.ensureIdMatchesType(element, this.mTypeFqcn, rootEdit);
            if (oldId != null && newId != null) {
                IStructuredModel model = this.mDelegate.getEditor().getModelForRead();
                try {
                    IStructuredDocument doc = model.getStructuredDocument();
                    if (doc != null) {
                        IndexedRegion range = ChangeViewRefactoring.getRegion(element);
                        int skipStart = range.getStartOffset();
                        int skipEnd = range.getEndOffset();
                        List<TextEdit> replaceIds = ChangeViewRefactoring.replaceIds(this.getAndroidNamespacePrefix(), doc, skipStart, skipEnd, oldId, newId);
                        for (TextEdit edit : replaceIds) {
                            rootEdit.addChild(edit);
                        }
                    }
                }
                finally {
                    model.releaseFromRead();
                }
            }
            this.removeUndefinedAttrs(rootEdit, element);
        }
        return changes;
    }

    private void removeUndefinedAttrs(MultiTextEdit rootEdit, Element element) {
        AttributeDescriptor[] layoutAttributes;
        ViewElementDescriptor descriptor = this.getElementDescriptor(this.mTypeFqcn);
        if (descriptor == null) {
            return;
        }
        HashSet<String> defined = new HashSet<String>();
        AttributeDescriptor[] attributeDescriptorArray = layoutAttributes = descriptor.getAttributes();
        int n = layoutAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeDescriptor attribute = attributeDescriptorArray[n2];
            defined.add(attribute.getXmlLocalName());
            ++n2;
        }
        List<Attr> attributes = this.findAttributes(element);
        for (Attr attribute : attributes) {
            String name = attribute.getLocalName();
            if (defined.contains(name)) continue;
            this.removeAttribute(rootEdit, element, attribute.getNamespaceURI(), name);
        }
        if (defined.contains("text") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "text")) {
            this.setAttribute(rootEdit, element, "http://schemas.android.com/apk/res/android", this.getAndroidNamespacePrefix(), "text", descriptor.getUiName());
        }
    }

    protected List<Attr> findAttributes(Node root) {
        ArrayList<Attr> result = new ArrayList<Attr>();
        NamedNodeMap attributes = root.getAttributes();
        int i = 0;
        int n = attributes.getLength();
        while (i < n) {
            Node attributeNode = attributes.item(i);
            String name = attributeNode.getLocalName();
            if (!name.startsWith("layout_") && "http://schemas.android.com/apk/res/android".equals(attributeNode.getNamespaceURI())) {
                result.add((Attr)attributeNode);
            }
            ++i;
        }
        return result;
    }

    List<String> getOldTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (Element primary : this.getElements()) {
            String oldType = primary.getTagName();
            if (oldType.indexOf(46) == -1 && !oldType.equals("include") && !oldType.equals("fragment")) {
                oldType = "android.widget." + oldType;
            }
            types.add(oldType);
        }
        return types;
    }

    @Override
    VisualRefactoringWizard createWizard() {
        return new ChangeViewWizard(this, this.mDelegate);
    }

    public static class Descriptor
    extends VisualRefactoring.VisualRefactoringDescriptor {
        public Descriptor(String project, String description, String comment, Map<String, String> arguments) {
            super("org.eclipse.andmore.refactoring.changeview", project, description, comment, arguments);
        }

        @Override
        protected Refactoring createRefactoring(Map<String, String> args) {
            return new ChangeViewRefactoring(args);
        }
    }
}

