/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import com.android.resources.ResourceType;
import com.android.utils.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.refactoring.ExtractStyleRefactoring;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoringWizard;
import org.eclipse.andmore.internal.resources.ResourceNameValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Attr;

class ExtractStyleWizard
extends VisualRefactoringWizard {
    public ExtractStyleWizard(ExtractStyleRefactoring ref, LayoutEditorDelegate editor) {
        super(ref, editor);
        this.setDefaultPageTitle(ref.getName());
    }

    protected void addUserInputPages() {
        String initialName = "styleName";
        this.addPage((IWizardPage)new InputPage(this.mDelegate.getEditor().getProject(), initialName));
    }

    private static class InputPage
    extends VisualRefactoringWizard.VisualRefactoringInputPage {
        private final IProject mProject;
        private final String mSuggestedName;
        private Text mNameText;
        private Table mTable;
        private Button mRemoveExtracted;
        private Button mSetStyle;
        private Button mRemoveAll;
        private Button mExtend;
        private CheckboxTableViewer mCheckedView;
        private String mParentStyle;
        private Set<Attr> mInSelection;
        private List<Attr> mAllAttributes;
        private int mElementCount;
        private Map<Attr, Integer> mFrequencyCount;
        private Set<Attr> mShown;
        private List<Attr> mInitialChecked;
        private List<Attr> mAllChecked;
        private List<Map.Entry<String, List<Attr>>> mRoot;
        private Map<String, List<Attr>> mAvailableAttributes;

        public InputPage(IProject project, String suggestedName) {
            super("ExtractStyleInputPage");
            this.mProject = project;
            this.mSuggestedName = suggestedName;
        }

        public void createControl(Composite parent) {
            this.initialize();
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label nameLabel = new Label(composite, 0);
            nameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            nameLabel.setText("Style Name:");
            this.mNameText = new Text(composite, 2048);
            this.mNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.mNameText.addModifyListener(this.mModifyValidateListener);
            this.mRemoveExtracted = new Button(composite, 32);
            this.mRemoveExtracted.setSelection(true);
            this.mRemoveExtracted.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
            this.mRemoveExtracted.setText("Remove extracted attributes");
            this.mRemoveExtracted.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            this.mRemoveAll = new Button(composite, 32);
            this.mRemoveAll.setSelection(false);
            this.mRemoveAll.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
            this.mRemoveAll.setText("Remove all extracted attributes regardless of value");
            this.mRemoveAll.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            boolean defaultSetStyle = false;
            if (this.mParentStyle != null) {
                this.mExtend = new Button(composite, 32);
                this.mExtend.setSelection(true);
                this.mExtend.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
                this.mExtend.setText(String.format("Extend %1$s", this.mParentStyle));
                this.mExtend.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
                defaultSetStyle = true;
            }
            this.mSetStyle = new Button(composite, 32);
            this.mSetStyle.setSelection(defaultSetStyle);
            this.mSetStyle.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
            this.mSetStyle.setText("Set style attribute on extracted elements");
            this.mSetStyle.addSelectionListener((SelectionListener)this.mSelectionValidateListener);
            new Label(composite, 0);
            new Label(composite, 0);
            Label tableLabel = new Label(composite, 0);
            tableLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            tableLabel.setText("Choose style attributes to extract:");
            this.mCheckedView = CheckboxTableViewer.newCheckList((Composite)composite, (int)100352);
            this.mTable = this.mCheckedView.getTable();
            this.mTable.setLayoutData((Object)new GridData(4, 4, true, true, 2, 2));
            ((GridData)this.mTable.getLayoutData()).heightHint = 200;
            this.mCheckedView.setContentProvider((IContentProvider)new ArgumentContentProvider());
            this.mCheckedView.setLabelProvider((IBaseLabelProvider)new ArgumentLabelProvider());
            this.mCheckedView.setInput(this.mRoot);
            Object[] initialSelection = this.mInitialChecked.toArray();
            this.mCheckedView.setCheckedElements(initialSelection);
            this.mCheckedView.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    boolean isChecked = event.getChecked();
                    if (isChecked) {
                        Attr attribute = (Attr)event.getElement();
                        List list = (List)InputPage.this.mAvailableAttributes.get(attribute.getLocalName());
                        for (Attr other : list) {
                            if (other == attribute || !InputPage.this.mShown.contains(other)) continue;
                            InputPage.this.mCheckedView.setChecked((Object)other, false);
                        }
                    }
                    InputPage.this.validatePage();
                }
            });
            Composite buttonForm = new Composite(composite, 0);
            buttonForm.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            RowLayout rowLayout = new RowLayout(256);
            rowLayout.marginTop = 0;
            rowLayout.marginLeft = 0;
            buttonForm.setLayout((Layout)rowLayout);
            Button checkAllButton = new Button(buttonForm, 0x800000);
            checkAllButton.setText("Select All");
            checkAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputPage.this.mCheckedView.setCheckedElements(InputPage.this.mAllChecked.toArray());
                    InputPage.this.validatePage();
                }
            });
            Button uncheckAllButton = new Button(buttonForm, 0x800000);
            uncheckAllButton.setText("Deselect All");
            uncheckAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputPage.this.mCheckedView.setAllChecked(false);
                    InputPage.this.validatePage();
                }
            });
            if (this.mSuggestedName != null) {
                this.mNameText.setText(this.mSuggestedName);
            }
            this.setControl((Control)composite);
            this.validatePage();
        }

        private void initialize() {
            ExtractStyleRefactoring ref = (ExtractStyleRefactoring)this.getRefactoring();
            this.mElementCount = ref.getElements().size();
            this.mParentStyle = ref.getParentStyle();
            Pair<Map<String, List<Attr>>, Set<Attr>> result = ref.getAvailableAttributes();
            this.mAvailableAttributes = (Map)result.getFirst();
            this.mInSelection = (Set)result.getSecond();
            this.mRoot = new ArrayList<Map.Entry<String, List<Attr>>>(this.mAvailableAttributes.entrySet());
            Collections.sort(this.mRoot, new Comparator<Map.Entry<String, List<Attr>>>(){

                @Override
                public int compare(Map.Entry<String, List<Attr>> e1, Map.Entry<String, List<Attr>> e2) {
                    return e1.getKey().compareTo(e2.getKey());
                }
            });
            this.mShown = new HashSet<Attr>();
            this.mInitialChecked = new ArrayList<Attr>();
            this.mAllChecked = new ArrayList<Attr>();
            this.mAllAttributes = new ArrayList<Attr>();
            this.mFrequencyCount = new HashMap<Attr, Integer>();
            for (Map.Entry<String, List<Attr>> entry : this.mRoot) {
                List<Attr> attrList = entry.getValue();
                Collections.sort(attrList, new Comparator<Attr>(){

                    @Override
                    public int compare(Attr a1, Attr a2) {
                        return a1.getValue().compareTo(a2.getValue());
                    }
                });
                Attr prevAttr = null;
                String prev = null;
                ArrayList<Attr> uniqueValueAttrs = new ArrayList<Attr>();
                for (Attr attr : attrList) {
                    String value = attr.getValue();
                    if (value.equals(prev)) {
                        Integer count = this.mFrequencyCount.get(prevAttr);
                        count = count == null ? Integer.valueOf(2) : Integer.valueOf(count + 1);
                        this.mFrequencyCount.put(prevAttr, count);
                        continue;
                    }
                    uniqueValueAttrs.add(attr);
                    prev = value;
                    prevAttr = attr;
                }
                Collections.sort(uniqueValueAttrs, new Comparator<Attr>(){

                    @Override
                    public int compare(Attr a1, Attr a2) {
                        int delta;
                        Integer f1 = (Integer)InputPage.this.mFrequencyCount.get(a1);
                        Integer f2 = (Integer)InputPage.this.mFrequencyCount.get(a2);
                        if (f1 == null) {
                            f1 = 1;
                        }
                        if (f2 == null) {
                            f2 = 1;
                        }
                        if ((delta = f2 - f1) != 0) {
                            return delta;
                        }
                        return a1.getValue().compareTo(a2.getValue());
                    }
                });
                this.mAllAttributes.addAll(uniqueValueAttrs);
                this.mShown.addAll(uniqueValueAttrs);
                Attr first = (Attr)uniqueValueAttrs.get(0);
                this.mAllChecked.add(first);
                if (!this.mInSelection.contains(first)) continue;
                this.mInitialChecked.add(first);
            }
        }

        @Override
        protected boolean validatePage() {
            boolean ok = true;
            String text = this.mNameText.getText().trim();
            if (text.length() == 0) {
                this.setErrorMessage("Provide a name for the new style");
                ok = false;
            } else {
                ResourceNameValidator validator = ResourceNameValidator.create(false, this.mProject, ResourceType.STYLE);
                String message = validator.isValid(text);
                if (message != null) {
                    this.setErrorMessage(message);
                    ok = false;
                }
            }
            Object[] checkedElements = this.mCheckedView.getCheckedElements();
            if (checkedElements.length == 0) {
                this.setErrorMessage("Choose at least one attribute to extract");
                ok = false;
            }
            if (ok) {
                this.setErrorMessage(null);
                ExtractStyleRefactoring refactoring = (ExtractStyleRefactoring)this.getRefactoring();
                refactoring.setStyleName(text);
                refactoring.setRemoveExtracted(this.mRemoveExtracted.getSelection());
                refactoring.setRemoveAll(this.mRemoveAll.getSelection());
                refactoring.setApplyStyle(this.mSetStyle.getSelection());
                if (this.mExtend != null && this.mExtend.getSelection()) {
                    refactoring.setParent(this.mParentStyle);
                }
                ArrayList<Attr> attributes = new ArrayList<Attr>();
                Object[] objectArray = checkedElements;
                int n = checkedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    attributes.add((Attr)o);
                    ++n2;
                }
                refactoring.setChosenAttributes(attributes);
            }
            this.setPageComplete(ok);
            return ok;
        }

        private class ArgumentContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                if (inputElement == InputPage.this.mRoot) {
                    return InputPage.this.mAllAttributes.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        private class ArgumentLabelProvider
        extends StyledCellLabelProvider {
            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                Attr attribute = (Attr)element;
                StyledString styledString = new StyledString();
                styledString.append(attribute.getLocalName());
                styledString.append(" = ", StyledString.QUALIFIER_STYLER);
                styledString.append(attribute.getValue());
                if (InputPage.this.mElementCount > 1) {
                    Integer f = (Integer)InputPage.this.mFrequencyCount.get(attribute);
                    String s = String.format(" (in %d/%d elements)", f != null ? f : 1, InputPage.this.mElementCount);
                    styledString.append(s, StyledString.DECORATIONS_STYLER);
                }
                cell.setText(styledString.toString());
                cell.setStyleRanges(styledString.getStyleRanges());
                super.update(cell);
            }
        }
    }
}

