/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import com.android.ide.common.xml.XmlFormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlFormatPreferences;
import org.eclipse.andmore.internal.editors.formatting.EclipseXmlPrettyPrinter;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.editors.layout.refactoring.UseCompoundDrawableWizard;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoring;
import org.eclipse.andmore.internal.editors.layout.refactoring.VisualRefactoringWizard;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class UseCompoundDrawableRefactoring
extends VisualRefactoring {
    public UseCompoundDrawableRefactoring(IFile file, LayoutEditorDelegate editor, ITextSelection selection, ITreeSelection treeSelection) {
        super(file, editor, selection, treeSelection);
    }

    private UseCompoundDrawableRefactoring(Map<String, String> arguments) {
        super(arguments);
    }

    UseCompoundDrawableRefactoring(List<Element> selectedElements, LayoutEditorDelegate editor) {
        super(selectedElements, editor);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            boolean haveImageView;
            pm.beginTask("Checking preconditions...", 6);
            if (this.mSelectionStart == -1 || this.mSelectionEnd == -1) {
                status.addFatalError("Nothing to convert");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mTreeSelection != null) {
                List<CanvasViewInfo> infos = this.getSelectedViewInfos();
                if (!this.validateNotEmpty(infos, status)) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
                if (!this.validateContiguous(infos, status)) {
                    RefactoringStatus refactoringStatus = status;
                    return refactoringStatus;
                }
            }
            if (this.mElements.size() == 0) {
                status.addFatalError("Nothing to convert");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            if (this.mElements.size() != 1 || !((Element)this.mElements.get(0)).getTagName().equals("LinearLayout")) {
                status.addFatalError("Must select exactly one LinearLayout");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            Element layout = (Element)this.mElements.get(0);
            List<Element> children = DomUtilities.getChildren(layout);
            if (children.size() != 2) {
                status.addFatalError("The LinearLayout must have exactly two children");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            Element first = children.get(0);
            Element second = children.get(1);
            boolean haveTextView = first.getTagName().equals("TextView") || second.getTagName().equals("TextView");
            boolean bl = haveImageView = first.getTagName().equals("ImageView") || second.getTagName().equals("ImageView");
            if (!haveTextView || !haveImageView) {
                status.addFatalError("The LinearLayout must have exactly one TextView child and one ImageView child");
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            pm.worked(1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    @Override
    protected VisualRefactoring.VisualRefactoringDescriptor createDescriptor() {
        String comment = this.getName();
        return new Descriptor(this.mProject.getName(), comment, comment, this.createArgumentMap());
    }

    @Override
    protected Map<String, String> createArgumentMap() {
        return super.createArgumentMap();
    }

    public String getName() {
        return "Convert to Compound Drawable";
    }

    @Override
    protected List<Change> computeChanges(IProgressMonitor monitor) {
        MultiTextEdit formatted;
        String layoutId;
        String drawableAttribute;
        String name;
        Element image;
        Element text;
        String androidNsPrefix = this.getAndroidNamespacePrefix();
        IFile file = this.mDelegate.getEditor().getInputFile();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (file == null) {
            return changes;
        }
        TextFileChange change = new TextFileChange(file.getName(), file);
        MultiTextEdit rootEdit = new MultiTextEdit();
        change.setTextType("xml");
        Element layout = (Element)this.mElements.get(0);
        List<Element> children = DomUtilities.getChildren(layout);
        Element first = children.get(0);
        Element second = children.get(1);
        if (first.getTagName().equals("TextView")) {
            text = first;
            image = second;
        } else {
            text = second;
            image = first;
        }
        boolean isVertical = "vertical".equals(layout.getAttributeNS("http://schemas.android.com/apk/res/android", "orientation"));
        Document tempDocument = DomUtilities.createEmptyDocument();
        if (tempDocument == null) {
            return changes;
        }
        Element newTextElement = tempDocument.createElement(text.getTagName());
        tempDocument.appendChild(newTextElement);
        NamedNodeMap attributes = text.getAttributes();
        int i = 0;
        int n = attributes.getLength();
        while (i < n) {
            Attr attribute = (Attr)attributes.item(i);
            name = attribute.getLocalName();
            if (!name.startsWith("layout_") || !"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI()) || name.equals("layout_width") || name.equals("layout_height")) {
                newTextElement.setAttribute(attribute.getName(), attribute.getValue());
            }
            ++i;
        }
        List<Attr> layoutAttributes = this.findLayoutAttributes(layout);
        for (Attr attribute : layoutAttributes) {
            name = attribute.getLocalName();
            if ((name.equals("layout_width") || name.equals("layout_height")) && "http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) continue;
            newTextElement.setAttribute(attribute.getName(), attribute.getValue());
        }
        String gravity = layout.getAttributeNS("http://schemas.android.com/apk/res/android", "gravity");
        if (gravity.length() > 0) {
            UseCompoundDrawableRefactoring.setAndroidAttribute(newTextElement, androidNsPrefix, "gravity", gravity);
        }
        String src = image.getAttributeNS("http://schemas.android.com/apk/res/android", "src");
        String padding1 = null;
        String padding2 = null;
        if (isVertical) {
            if (first == image) {
                drawableAttribute = "drawableTop";
                padding1 = UseCompoundDrawableRefactoring.getPadding(image, "layout_marginBottom");
                padding2 = UseCompoundDrawableRefactoring.getPadding(text, "layout_marginTop");
            } else {
                drawableAttribute = "drawableBottom";
                padding1 = UseCompoundDrawableRefactoring.getPadding(text, "layout_marginBottom");
                padding2 = UseCompoundDrawableRefactoring.getPadding(image, "layout_marginTop");
            }
        } else if (first == image) {
            drawableAttribute = "drawableLeft";
            padding1 = UseCompoundDrawableRefactoring.getPadding(image, "layout_marginRight");
            padding2 = UseCompoundDrawableRefactoring.getPadding(text, "layout_marginLeft");
        } else {
            drawableAttribute = "drawableRight";
            padding1 = UseCompoundDrawableRefactoring.getPadding(text, "layout_marginRight");
            padding2 = UseCompoundDrawableRefactoring.getPadding(image, "layout_marginLeft");
        }
        UseCompoundDrawableRefactoring.setAndroidAttribute(newTextElement, androidNsPrefix, drawableAttribute, src);
        String padding = UseCompoundDrawableRefactoring.combine(padding1, padding2);
        if (padding != null) {
            UseCompoundDrawableRefactoring.setAndroidAttribute(newTextElement, androidNsPrefix, "drawablePadding", padding);
        }
        if (layout.getParentNode() instanceof Document) {
            List<Attr> declarations = UseCompoundDrawableRefactoring.findNamespaceAttributes(layout);
            for (Attr attribute : declarations) {
                if (!(attribute instanceof IndexedRegion)) continue;
                newTextElement.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        if ((layoutId = UseCompoundDrawableRefactoring.getId(layout)).length() > 0) {
            String id = UseCompoundDrawableRefactoring.getId(text);
            if (id.length() == 0) {
                id = this.ensureHasId(rootEdit, text, null, false);
                UseCompoundDrawableRefactoring.setAndroidAttribute(newTextElement, androidNsPrefix, "id", id);
            }
            IStructuredModel model = this.mDelegate.getEditor().getModelForRead();
            try {
                IStructuredDocument doc = model.getStructuredDocument();
                if (doc != null) {
                    List<TextEdit> replaceIds = UseCompoundDrawableRefactoring.replaceIds(androidNsPrefix, doc, this.mSelectionStart, this.mSelectionEnd, layoutId, id);
                    for (TextEdit edit : replaceIds) {
                        rootEdit.addChild(edit);
                    }
                }
            }
            finally {
                model.releaseFromRead();
            }
        }
        String xml = EclipseXmlPrettyPrinter.prettyPrint(tempDocument.getDocumentElement(), EclipseXmlFormatPreferences.create(), XmlFormatStyle.LAYOUT, null, false);
        ReplaceEdit replace = new ReplaceEdit(this.mSelectionStart, this.mSelectionEnd - this.mSelectionStart, xml);
        rootEdit.addChild((TextEdit)replace);
        if (AdtPrefs.getPrefs().getFormatGuiXml() && (formatted = this.reformat(rootEdit, XmlFormatStyle.LAYOUT)) != null) {
            rootEdit = formatted;
        }
        change.setEdit((TextEdit)rootEdit);
        changes.add((Change)change);
        return changes;
    }

    private static String getPadding(Element element, String attribute) {
        String padding = element.getAttributeNS("http://schemas.android.com/apk/res/android", attribute);
        if (padding != null && padding.isEmpty()) {
            padding = null;
        }
        return padding;
    }

    static String combine(String dimension1, String dimension2) {
        String unit;
        if (dimension1 == null || dimension1.isEmpty()) {
            if (dimension2 != null && dimension2.isEmpty()) {
                return null;
            }
            return dimension2;
        }
        if (dimension2 == null || dimension2.isEmpty()) {
            if (dimension1 != null && dimension1.isEmpty()) {
                return null;
            }
            return dimension1;
        }
        if (dimension1.startsWith("@") || dimension2.startsWith("@")) {
            return null;
        }
        Pattern p = Pattern.compile("([\\d\\.]+)(.+)");
        Matcher matcher1 = p.matcher(dimension1);
        Matcher matcher2 = p.matcher(dimension2);
        if (matcher1.matches() && matcher2.matches() && (unit = matcher1.group(2)).equals(matcher2.group(2))) {
            float value1 = Float.parseFloat(matcher1.group(1));
            float value2 = Float.parseFloat(matcher2.group(1));
            return String.valueOf(AdtUtils.formatFloatAttribute(value1 + value2)) + unit;
        }
        return null;
    }

    private static void setAndroidAttribute(Element element, String prefix, String name, String value) {
        element.setAttribute(String.valueOf(prefix) + ':' + name, value);
    }

    @Override
    public VisualRefactoringWizard createWizard() {
        return new UseCompoundDrawableWizard(this, this.mDelegate);
    }

    /* synthetic */ UseCompoundDrawableRefactoring(Map map, UseCompoundDrawableRefactoring useCompoundDrawableRefactoring) {
        this(map);
    }

    public static class Descriptor
    extends VisualRefactoring.VisualRefactoringDescriptor {
        public Descriptor(String project, String description, String comment, Map<String, String> arguments) {
            super("org.eclipse.andmore.refactoring.usecompound", project, description, comment, arguments);
        }

        @Override
        protected Refactoring createRefactoring(Map<String, String> args) {
            return new UseCompoundDrawableRefactoring(args, null);
        }
    }
}

