/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.layout.refactoring;

import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.LayoutEditorDelegate;
import org.eclipse.andmore.internal.editors.layout.gle2.CanvasViewInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.part.FileEditorInput;

abstract class VisualRefactoringAction
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow mWindow;
    protected ITextSelection mTextSelection;
    protected ITreeSelection mTreeSelection;
    protected LayoutEditorDelegate mDelegate;
    protected IFile mFile;

    VisualRefactoringAction() {
    }

    public void init(IWorkbenchWindow window) {
        this.mWindow = window;
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object firstElement;
        this.mTextSelection = null;
        this.mTreeSelection = null;
        this.mFile = null;
        IEditorPart editor = null;
        if (selection instanceof ITextSelection) {
            this.mTextSelection = (ITextSelection)selection;
            editor = AdtUtils.getActiveEditor();
            this.mFile = this.getSelectedFile(editor);
        } else if (selection instanceof ITreeSelection && (firstElement = ((ITreeSelection)selection).getFirstElement()) instanceof CanvasViewInfo) {
            this.mTreeSelection = (ITreeSelection)selection;
            editor = AdtUtils.getActiveEditor();
            this.mFile = this.getSelectedFile(editor);
        }
        this.mDelegate = LayoutEditorDelegate.fromEditor(editor);
        action.setEnabled((this.mTextSelection != null || this.mTreeSelection != null) && this.mFile != null && this.mDelegate != null);
    }

    public abstract void run(IAction var1);

    private IFile getSelectedFile(IEditorPart editor) {
        FileEditorInput fi;
        IFile file;
        IEditorInput input;
        if (editor != null && (input = editor.getEditorInput()) instanceof FileEditorInput && (file = (fi = (FileEditorInput)input).getFile()).exists()) {
            IProject proj = file.getProject();
            try {
                if (proj != null && proj.hasNature("org.eclipse.andmore.AndroidNature")) {
                    return file;
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public static IAction create(String title, LayoutEditorDelegate editorDelegate, Class<? extends VisualRefactoringAction> clz) {
        return new ActionWrapper(title, editorDelegate, clz);
    }

    private static class ActionWrapper
    extends Action {
        private Class<? extends VisualRefactoringAction> mClass;
        private LayoutEditorDelegate mEditorDelegate;

        ActionWrapper(String title, LayoutEditorDelegate editorDelegate, Class<? extends VisualRefactoringAction> clz) {
            super(title);
            this.mEditorDelegate = editorDelegate;
            this.mClass = clz;
        }

        public void run() {
            VisualRefactoringAction action;
            try {
                action = this.mClass.newInstance();
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
                return;
            }
            IEditorSite site = this.mEditorDelegate.getEditor().getEditorSite();
            action.init(site.getWorkbenchWindow());
            ISelection selection = site.getSelectionProvider().getSelection();
            action.selectionChanged((IAction)this, selection);
            if (this.isEnabled()) {
                action.run((IAction)this);
            }
        }
    }
}

