/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.model;

import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import org.eclipse.andmore.internal.editors.manifest.descriptors.ManifestElementDescriptor;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.w3c.dom.Element;

public final class UiManifestElementNode
extends UiElementNode {
    public UiManifestElementNode(ManifestElementDescriptor elementDescriptor) {
        super(elementDescriptor);
    }

    @Override
    public String getShortDescription() {
        ElementDescriptor desc;
        AndroidTargetData target = this.getAndroidTarget();
        AndroidManifestDescriptors manifestDescriptors = null;
        if (target != null) {
            manifestDescriptors = target.getManifestDescriptors();
        }
        String name = this.getDescriptor().getUiName();
        if (manifestDescriptors != null && this.getXmlNode() != null && this.getXmlNode() instanceof Element && this.getXmlNode().hasAttributes() && (desc = this.getDescriptor()) != manifestDescriptors.getManifestElement() && desc != manifestDescriptors.getApplicationElement()) {
            Element elem = (Element)this.getXmlNode();
            String attr = this._Element_getAttributeNS(elem, "http://schemas.android.com/apk/res/android", "name");
            if (attr == null || attr.length() == 0) {
                attr = this._Element_getAttributeNS(elem, "http://schemas.android.com/apk/res/android", "label");
            }
            if (attr != null && attr.length() > 0) {
                if (attr.contains(name)) {
                    return attr;
                }
                return String.format("%1$s (%2$s)", attr, name);
            }
        }
        return String.format("%1$s", name);
    }

    private String _Element_getAttributeNS(Element element, String namespaceURI, String localName) {
        try {
            return element.getAttributeNS(namespaceURI, localName);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

