/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.pages;

import com.android.utils.SdkUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.descriptors.DescriptorsUtils;
import org.eclipse.andmore.internal.editors.manifest.ManifestEditor;
import org.eclipse.andmore.internal.editors.ui.UiElementPart;
import org.eclipse.andmore.internal.editors.uimodel.IUiUpdateListener;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class ApplicationToggle
extends UiElementPart {
    private Button mCheckbox;
    private AppNodeUpdateListener mAppNodeUpdateListener;
    public boolean mInternalModification;
    private FormText mTooltipFormText;

    public ApplicationToggle(Composite body, FormToolkit toolkit, ManifestEditor editor, UiElementNode applicationUiNode) {
        super(body, toolkit, editor, applicationUiNode, "Application Toggle", null, 66);
    }

    public void dispose() {
        super.dispose();
        if (this.getUiElementNode() != null && this.mAppNodeUpdateListener != null) {
            this.getUiElementNode().removeUpdateListener(this.mAppNodeUpdateListener);
            this.mAppNodeUpdateListener = null;
        }
    }

    @Override
    public void setUiElementNode(UiElementNode uiElementNode) {
        super.setUiElementNode(uiElementNode);
        this.updateTooltip();
        this.mAppNodeUpdateListener.uiElementNodeUpdated(this.getUiElementNode(), IUiUpdateListener.UiUpdateState.CHILDREN_CHANGED);
    }

    @Override
    protected void createFormControls(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Composite table = this.createTableLayout(toolkit, 1);
        this.mTooltipFormText = this.createFormText(table, toolkit, true, "<form></form>", false);
        this.updateTooltip();
        this.mCheckbox = toolkit.createButton(table, "Define an <application> tag in the AndroidManifest.xml", 32);
        this.mCheckbox.setLayoutData((Object)new TableWrapData(256, 16));
        this.mCheckbox.setSelection(false);
        this.mCheckbox.addSelectionListener((SelectionListener)new CheckboxSelectionListener());
        this.mAppNodeUpdateListener = new AppNodeUpdateListener();
        this.getUiElementNode().addUpdateListener(this.mAppNodeUpdateListener);
        this.mAppNodeUpdateListener.uiElementNodeUpdated(this.getUiElementNode(), IUiUpdateListener.UiUpdateState.CHILDREN_CHANGED);
        this.layoutChanged();
    }

    private void updateTooltip() {
        boolean isVisible = false;
        String tooltip = this.getUiElementNode().getDescriptor().getTooltip();
        if (tooltip != null) {
            tooltip = DescriptorsUtils.formatFormText(tooltip, this.getUiElementNode().getDescriptor(), Sdk.getCurrent().getDocumentationBaseUrl());
            this.mTooltipFormText.setText(tooltip, true, true);
            this.mTooltipFormText.setImage("image", AndmoreAndroidPlugin.getAndroidLogo());
            this.mTooltipFormText.addHyperlinkListener(this.getEditor().createHyperlinkListener());
            isVisible = true;
        }
        this.mTooltipFormText.setVisible(isVisible);
    }

    private class AppNodeUpdateListener
    implements IUiUpdateListener {
        private AppNodeUpdateListener() {
        }

        @Override
        public void uiElementNodeUpdated(UiElementNode ui_node, IUiUpdateListener.UiUpdateState state) {
            try {
                boolean exists;
                ApplicationToggle.this.mInternalModification = true;
                boolean bl = exists = ui_node.getXmlNode() != null;
                if (ApplicationToggle.this.mCheckbox.getSelection() != exists) {
                    ApplicationToggle.this.mCheckbox.setSelection(exists);
                }
            }
            finally {
                ApplicationToggle.this.mInternalModification = false;
            }
        }
    }

    private class CheckboxSelectionListener
    extends SelectionAdapter {
        private Node mUndoXmlNode;
        private Node mUndoXmlParent;
        private Node mUndoXmlNextNode;
        private Node mUndoXmlNextElement;
        private Document mUndoXmlDocument;

        private CheckboxSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            super.widgetSelected(e);
            if (!ApplicationToggle.this.mInternalModification && ApplicationToggle.this.getUiElementNode() != null) {
                ApplicationToggle.this.getUiElementNode().getEditor().wrapUndoEditXmlModel(ApplicationToggle.this.mCheckbox.getSelection() ? "Create or restore Application node" : "Remove Application node", new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationToggle.this.mCheckbox.getSelection()) {
                            boolean create = true;
                            if (CheckboxSelectionListener.this.mUndoXmlNode != null) {
                                boolean bl = create = !CheckboxSelectionListener.this.restoreApplicationNode();
                            }
                            if (create) {
                                ApplicationToggle.this.getUiElementNode().createXmlNode();
                            }
                        } else {
                            CheckboxSelectionListener.this.removeApplicationNode();
                        }
                    }
                });
            }
        }

        private boolean restoreApplicationNode() {
            if (this.mUndoXmlDocument == null || this.mUndoXmlNode == null) {
                return false;
            }
            this.mUndoXmlParent = this.validateNode(this.mUndoXmlDocument, this.mUndoXmlParent);
            this.mUndoXmlNextNode = this.validateNode(this.mUndoXmlDocument, this.mUndoXmlNextNode);
            this.mUndoXmlNextElement = this.validateNode(this.mUndoXmlDocument, this.mUndoXmlNextElement);
            if (this.mUndoXmlParent == null) {
                this.mUndoXmlParent = ApplicationToggle.this.getUiElementNode().getUiParent().prepareCommit();
                this.mUndoXmlNextNode = null;
                this.mUndoXmlNextElement = null;
            }
            boolean success = false;
            if (this.mUndoXmlParent != null) {
                Node next = this.mUndoXmlNextNode;
                if (next == null) {
                    next = this.mUndoXmlNextElement;
                }
                this.mUndoXmlParent.insertBefore(this.mUndoXmlNode, next);
                if (next == null) {
                    Text sep = this.mUndoXmlDocument.createTextNode(SdkUtils.getLineSeparator());
                    this.mUndoXmlParent.insertBefore(sep, null);
                }
                success = true;
            }
            this.mUndoXmlParent = null;
            this.mUndoXmlNextNode = null;
            this.mUndoXmlNextElement = null;
            this.mUndoXmlNode = null;
            this.mUndoXmlDocument = null;
            return success;
        }

        private Node validateNode(Node root_node, Node xml_node) {
            if (root_node == xml_node) {
                return xml_node;
            }
            Node node = root_node.getFirstChild();
            while (node != null) {
                if (root_node == xml_node || this.validateNode(node, xml_node) != null) {
                    return xml_node;
                }
                node = node.getNextSibling();
            }
            return null;
        }

        private void removeApplicationNode() {
            Node xml_node = ApplicationToggle.this.getUiElementNode().getXmlNode();
            if (xml_node == null) {
                return;
            }
            this.mUndoXmlDocument = xml_node.getOwnerDocument();
            this.mUndoXmlParent = xml_node.getParentNode();
            this.mUndoXmlNextElement = this.mUndoXmlNextNode = xml_node.getNextSibling();
            while (this.mUndoXmlNextElement != null && this.mUndoXmlNextElement.getNodeType() != 1) {
                this.mUndoXmlNextElement = this.mUndoXmlNextElement.getNextSibling();
            }
            this.mUndoXmlNode = ApplicationToggle.this.getUiElementNode().deleteXmlNode();
        }
    }
}

