/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.pages;

import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IPageImageProvider;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.manifest.ManifestEditor;
import org.eclipse.andmore.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import org.eclipse.andmore.internal.editors.ui.tree.UiTreeBlock;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class InstrumentationPage
extends FormPage
implements IPageImageProvider {
    public static final String PAGE_ID = "instrumentation_page";
    ManifestEditor mEditor;
    private UiTreeBlock mTreeBlock;

    public InstrumentationPage(ManifestEditor editor) {
        super((FormEditor)editor, PAGE_ID, "Instrumentation");
        this.mEditor = editor;
    }

    @Override
    public Image getPageImage() {
        return IconFactory.getInstance().getIcon(this.getTitle(), 6, 82);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText("Android Manifest Instrumentation");
        form.setImage(AndmoreAndroidPlugin.getAndroidLogo());
        UiElementNode manifest = this.mEditor.getUiRootNode();
        AndroidManifestDescriptors manifestDescriptor = this.mEditor.getManifestDescriptors();
        ElementDescriptor[] descriptorFilters = null;
        if (manifestDescriptor != null) {
            descriptorFilters = new ElementDescriptor[]{manifestDescriptor.getInstrumentationElement()};
        }
        this.mTreeBlock = new UiTreeBlock(this.mEditor, manifest, true, descriptorFilters, "Instrumentation", "List of instrumentations defined in the manifest");
        this.mTreeBlock.createContent(managedForm);
    }

    public void refreshUiNode() {
        if (this.mTreeBlock != null) {
            UiElementNode manifest = this.mEditor.getUiRootNode();
            AndroidManifestDescriptors manifestDescriptor = this.mEditor.getManifestDescriptors();
            this.mTreeBlock.changeRootAndDescriptors(manifest, new ElementDescriptor[]{manifestDescriptor.getInstrumentationElement()}, true);
        }
    }
}

