/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.manifest.pages;

import org.eclipse.andmore.internal.editors.manifest.ManifestEditor;
import org.eclipse.andmore.internal.editors.manifest.pages.OverviewPage;
import org.eclipse.andmore.internal.editors.ui.SectionHelper;
import org.eclipse.andmore.internal.project.ExportHelper;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.wizards.export.ExportWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.FileEditorInput;

final class OverviewExportPart
extends SectionHelper.ManifestSectionPart {
    private final OverviewPage mOverviewPage;

    public OverviewExportPart(OverviewPage overviewPage, final Composite body, FormToolkit toolkit, ManifestEditor editor) {
        super(body, toolkit, 66, true);
        Composite table;
        ProjectState state;
        this.mOverviewPage = overviewPage;
        Section section = this.getSection();
        section.setText("Exporting");
        final IProject project = this.getProject();
        boolean isLibrary = false;
        if (project != null && (state = Sdk.getProjectState(project)) != null) {
            isLibrary = state.isLibrary();
        }
        if (isLibrary) {
            section.setDescription("Library project cannot be exported.");
            table = this.createTableLayout(toolkit, 2);
            this.createFormText(table, toolkit, true, "<form></form>", false);
        } else {
            section.setDescription("To export the application for distribution, you have the following options:");
            table = this.createTableLayout(toolkit, 2);
            StringBuffer buf = new StringBuffer();
            buf.append("<form><li><a href=\"wizard\">");
            buf.append("Use the Export Wizard");
            buf.append("</a>");
            buf.append(" to export and sign an APK");
            buf.append("</li>");
            buf.append("<li><a href=\"manual\">");
            buf.append("Export an unsigned APK");
            buf.append("</a>");
            buf.append(" and sign it manually");
            buf.append("</li></form>");
            FormText text = this.createFormText(table, toolkit, true, buf.toString(), false);
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (project != null) {
                        if ("manual".equals(e.data)) {
                            ExportHelper.exportUnsignedReleaseApk(project);
                        } else {
                            StructuredSelection selection = new StructuredSelection((Object)project);
                            ExportWizard wizard = new ExportWizard();
                            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
                            WizardDialog dialog = new WizardDialog(body.getShell(), (IWizard)wizard);
                            dialog.open();
                        }
                    }
                }
            });
        }
        this.layoutChanged();
    }

    private IProject getProject() {
        IEditorInput input = this.mOverviewPage.mEditor.getEditorInput();
        if (input instanceof FileEditorInput) {
            FileEditorInput fileInput = (FileEditorInput)input;
            IFile file = fileInput.getFile();
            return file.getProject();
        }
        return null;
    }
}

