/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.menu;

import com.android.resources.ResourceFolderType;
import com.android.xml.AndroidXPathFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.common.CommonXmlDelegate;
import org.eclipse.andmore.internal.editors.common.CommonXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.menu.MenuContentAssist;
import org.eclipse.andmore.internal.editors.menu.MenuTreePage;
import org.eclipse.andmore.internal.sdk.AndroidTargetData;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MenuEditorDelegate
extends CommonXmlDelegate {
    public static final String LEGACY_EDITOR_ID = "org.eclipse.andmore.editors.menu.MenuEditor";
    private boolean mUpdatingModel;

    private MenuEditorDelegate(CommonXmlEditor editor) {
        super(editor, new MenuContentAssist());
        editor.addDefaultTargetListener();
    }

    @Override
    public void delegateCreateFormPages() {
        try {
            this.getEditor().addPage((IFormPage)new MenuTreePage(this.getEditor()));
        }
        catch (PartInitException e) {
            AndmoreAndroidPlugin.log(e, "Error creating nested page", new Object[0]);
        }
    }

    @Override
    public void delegateXmlModelChanged(Document xml_doc) {
        if (this.mUpdatingModel) {
            return;
        }
        try {
            this.mUpdatingModel = true;
            this.delegateInitUiRootNode(false);
            this.getUiRootNode().setXmlDocument(xml_doc);
            if (xml_doc != null) {
                ElementDescriptor root_desc = this.getUiRootNode().getDescriptor();
                try {
                    XPath xpath = AndroidXPathFactory.newXPath();
                    Node node = (Node)xpath.evaluate("/" + root_desc.getXmlName(), xml_doc, XPathConstants.NODE);
                    if (node == null && root_desc.getMandatory() != ElementDescriptor.Mandatory.NOT_MANDATORY) {
                        node = this.getUiRootNode().createXmlNode();
                    }
                    this.getUiRootNode().loadFromXmlNode(node);
                }
                catch (XPathExpressionException e) {
                    AndmoreAndroidPlugin.log(e, "XPath error when trying to find '%s' element in XML.", root_desc.getXmlName());
                }
            }
        }
        finally {
            this.mUpdatingModel = false;
        }
    }

    @Override
    public void delegateInitUiRootNode(boolean force) {
        if (this.getUiRootNode() == null || force) {
            AndroidTargetData data;
            Document doc = null;
            if (this.getUiRootNode() != null) {
                doc = this.getUiRootNode().getXmlDocument();
            }
            ElementDescriptor desc = (data = this.getEditor().getTargetData()) == null ? new ElementDescriptor("temp", null) : data.getMenuDescriptors().getDescriptor();
            this.setUiRootNode(desc.createUiNode());
            this.getUiRootNode().setEditor(this.getEditor());
            this.onDescriptorsChanged(doc);
        }
    }

    private void onDescriptorsChanged(Document document) {
        if (document != null) {
            this.getUiRootNode().loadFromXmlNode(document);
        } else {
            this.getUiRootNode().reloadFromXmlNode(this.getUiRootNode().getXmlNode());
        }
    }

    /* synthetic */ MenuEditorDelegate(CommonXmlEditor commonXmlEditor, MenuEditorDelegate menuEditorDelegate) {
        this(commonXmlEditor);
    }

    public static class Creator
    implements CommonXmlDelegate.IDelegateCreator {
        public MenuEditorDelegate createForFile(CommonXmlEditor delegator, ResourceFolderType type) {
            if (ResourceFolderType.MENU == type) {
                return new MenuEditorDelegate(delegator, null);
            }
            return null;
        }
    }
}

