/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.ui.tree;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.andmore.internal.editors.AndroidXmlEditor;
import org.eclipse.andmore.internal.editors.descriptors.ElementDescriptor;
import org.eclipse.andmore.internal.editors.layout.descriptors.ViewElementDescriptor;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.AbstractElementListSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.part.FileEditorInput;

public class NewItemSelectionDialog
extends AbstractElementListSelectionDialog {
    private UiElementNode mSelectedUiNode;
    private UiElementNode mChosenRootNode;
    private UiElementNode mLocalRootNode;
    private ElementDescriptor[] mDescriptorFilters;
    private String mLastUsedKey;
    private static final Map<String, String> sLastUsedXmlName = new HashMap<String, String>();
    private String mInitialXmlName;

    public NewItemSelectionDialog(Shell shell, ILabelProvider labelProvider, ElementDescriptor[] descriptorFilters, UiElementNode ui_node, UiElementNode root_node) {
        super(shell, labelProvider);
        this.mDescriptorFilters = descriptorFilters;
        this.mLocalRootNode = root_node;
        if (ui_node != null && ui_node != this.mLocalRootNode) {
            if (ui_node.getDescriptor().hasChildren()) {
                this.mSelectedUiNode = ui_node;
            } else {
                UiElementNode parent = ui_node.getUiParent();
                if (parent != null && parent != this.mLocalRootNode) {
                    this.mSelectedUiNode = parent;
                }
            }
        }
        this.setHelpAvailable(false);
        this.setMultipleSelection(false);
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && selection[0] instanceof ViewElementDescriptor) {
                    return new Status(0, "org.eclipse.andmore", 0, ((ViewElementDescriptor)selection[0]).getFullClassName(), null);
                }
                if (selection.length == 1 && selection[0] instanceof ElementDescriptor) {
                    return new Status(0, "org.eclipse.andmore", 0, "", null);
                }
                return new Status(4, "org.eclipse.andmore", 4, "Invalid selection", null);
            }
        });
        String xmlName = this.getLastUsedXmlName(root_node);
        if (xmlName == null) {
            xmlName = this.getMostUsedXmlName(root_node);
        }
        if (xmlName == null) {
            xmlName = this.getLeafFileName(root_node);
        }
        this.mInitialXmlName = xmlName;
    }

    private String getLeafFileName(UiElementNode ui_node) {
        IFile f;
        IEditorInput editorInput;
        AndroidXmlEditor editor;
        if (ui_node != null && (editor = ui_node.getEditor()) != null && (editorInput = editor.getEditorInput()) instanceof FileEditorInput && (f = ((FileEditorInput)editorInput).getFile()) != null) {
            String leafName = f.getFullPath().removeFileExtension().lastSegment();
            return "*" + leafName;
        }
        return null;
    }

    private String getLastUsedXmlName(UiElementNode ui_node) {
        IFile f;
        IEditorInput editorInput;
        AndroidXmlEditor editor;
        if (ui_node != null && (editor = ui_node.getEditor()) != null && (editorInput = editor.getEditorInput()) instanceof FileEditorInput && (f = ((FileEditorInput)editorInput).getFile()) != null) {
            this.mLastUsedKey = f.getFullPath().toPortableString();
            return sLastUsedXmlName.get(this.mLastUsedKey);
        }
        return null;
    }

    private void setLastUsedXmlName(Object[] objects) {
        if (this.mLastUsedKey != null && objects != null && objects.length > 0 && objects[0] instanceof ElementDescriptor) {
            ElementDescriptor desc = (ElementDescriptor)objects[0];
            sLastUsedXmlName.put(this.mLastUsedKey, desc.getXmlName());
        }
    }

    private String getMostUsedXmlName(UiElementNode ui_node) {
        if (ui_node != null) {
            TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
            int max = -1;
            for (UiElementNode uiElementNode : ui_node.getUiChildren()) {
                String name = uiElementNode.getDescriptor().getXmlName();
                Integer i = (Integer)counts.get(name);
                int count = i == null ? 1 : i + 1;
                counts.put(name, count);
                max = Math.max(max, count);
            }
            if (max > 0) {
                for (Map.Entry entry : counts.entrySet()) {
                    if ((Integer)entry.getValue() != max) continue;
                    return (String)entry.getKey();
                }
            }
        }
        return null;
    }

    public UiElementNode getChosenRootNode() {
        return this.mChosenRootNode;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
        this.setLastUsedXmlName(this.getSelectedElements());
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createRadioControl(contents);
        this.createFilterText(contents);
        this.createFilteredList(contents);
        Label label = this.createMessageArea(contents);
        if (label != null) {
            GridData data = (GridData)label.getLayoutData();
            data.exclude = true;
        }
        this.chooseNode(this.mChosenRootNode);
        this.setInitialSelection(this.mChosenRootNode);
        return contents;
    }

    private void setInitialSelection(UiElementNode rootNode) {
        ElementDescriptor[] elementDescriptorArray;
        ElementDescriptor initialElement = null;
        if (this.mInitialXmlName != null && this.mInitialXmlName.length() > 0) {
            String name = this.mInitialXmlName;
            boolean partial = name.startsWith("*");
            if (partial) {
                name = name.substring(1).toLowerCase(Locale.US);
            }
            ElementDescriptor[] elementDescriptorArray2 = this.getAllowedDescriptors(rootNode);
            int n = elementDescriptorArray2.length;
            int n2 = 0;
            while (n2 < n) {
                String name2;
                ElementDescriptor desc = elementDescriptorArray2[n2];
                if (!partial && desc.getXmlName().equals(name)) {
                    initialElement = desc;
                    break;
                }
                if (partial && (name.startsWith(name2 = desc.getXmlLocalName().toLowerCase(Locale.US)) || name2.startsWith(name))) {
                    initialElement = desc;
                    break;
                }
                ++n2;
            }
        }
        if (initialElement == null) {
            elementDescriptorArray = null;
        } else {
            ElementDescriptor[] elementDescriptorArray3 = new ElementDescriptor[1];
            elementDescriptorArray = elementDescriptorArray3;
            elementDescriptorArray3[0] = initialElement;
        }
        this.setSelection(elementDescriptorArray);
    }

    private Composite createRadioControl(Composite content) {
        if (this.mSelectedUiNode != null) {
            Button radio1 = new Button(content, 16);
            radio1.setText(String.format("Create a new element at the top level, in %1$s.", this.mLocalRootNode.getShortDescription()));
            Button radio2 = new Button(content, 16);
            radio2.setText(String.format("Create a new element in the selected element, %1$s.", this.mSelectedUiNode.getBreadcrumbTrailDescription(false)));
            radio1.setSelection(false);
            radio2.setSelection(true);
            this.mChosenRootNode = this.mSelectedUiNode;
            radio1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    NewItemSelectionDialog.this.chooseNode(NewItemSelectionDialog.this.mLocalRootNode);
                }
            });
            radio2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    NewItemSelectionDialog.this.chooseNode(NewItemSelectionDialog.this.mSelectedUiNode);
                }
            });
        } else {
            this.setMessage(String.format("Create a new element at the top level, in %1$s.", this.mLocalRootNode.getShortDescription()));
            this.createMessageArea(content);
            this.mChosenRootNode = this.mLocalRootNode;
        }
        return content;
    }

    private void chooseNode(UiElementNode ui_node) {
        this.mChosenRootNode = ui_node;
        this.setListElements(this.getAllowedDescriptors(ui_node));
    }

    private ElementDescriptor[] getAllowedDescriptors(UiElementNode ui_node) {
        if (ui_node == this.mLocalRootNode && this.mDescriptorFilters != null && this.mDescriptorFilters.length != 0) {
            return this.mDescriptorFilters;
        }
        return ui_node.getDescriptor().getChildren();
    }
}

