/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.editors.uimodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.internal.editors.descriptors.DocumentDescriptor;
import org.eclipse.andmore.internal.editors.uimodel.IUiUpdateListener;
import org.eclipse.andmore.internal.editors.uimodel.UiElementNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UiDocumentNode
extends UiElementNode {
    public UiDocumentNode(DocumentDescriptor documentDescriptor) {
        super(documentDescriptor);
    }

    @Override
    public String getShortDescription() {
        return "Document";
    }

    @Override
    public String getBreadcrumbTrailDescription(boolean include_root) {
        return "Document";
    }

    @Override
    protected void setUiParent(UiElementNode parent) {
        if (parent != null) {
            throw new UnsupportedOperationException("Documents can't have UI parents");
        }
        super.setUiParent(null);
    }

    @Override
    public boolean loadFromXmlNode(Node xml_node) {
        boolean structure_changed = this.getXmlDocument() != xml_node;
        this.setXmlDocument((Document)xml_node);
        if (structure_changed |= super.loadFromXmlNode(xml_node)) {
            this.invokeUiUpdateListeners(IUiUpdateListener.UiUpdateState.CHILDREN_CHANGED);
        }
        return structure_changed;
    }

    @Override
    public Node createXmlNode() {
        if (this.getXmlDocument() == null) {
            throw new UnsupportedOperationException("Documents cannot be created");
        }
        return this.getXmlDocument();
    }

    @Override
    public Node deleteXmlNode() {
        throw new UnsupportedOperationException("Documents cannot be deleted");
    }

    public static List<UiElementNode> getAllElements(UiDocumentNode document) {
        ArrayList<UiElementNode> elements = new ArrayList<UiElementNode>(64);
        for (UiElementNode child : document.getUiChildren()) {
            UiDocumentNode.addElements(child, elements);
        }
        return elements;
    }

    private static void addElements(UiElementNode node, List<UiElementNode> elements) {
        elements.add(node);
        for (UiElementNode child : node.getUiChildren()) {
            UiDocumentNode.addElements(child, elements);
        }
    }
}

