/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.MultiLineReceiver;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.launch.DelayedLaunchInfo;
import org.eclipse.andmore.internal.launch.ILaunchController;

public class AMReceiver
extends MultiLineReceiver {
    private static final int MAX_ATTEMPT_COUNT = 5;
    private static final Pattern sAmErrorType = Pattern.compile("Error type (\\d+)");
    private final DelayedLaunchInfo mLaunchInfo;
    private final IDevice mDevice;
    private final ILaunchController mLaunchController;

    public AMReceiver(DelayedLaunchInfo launchInfo, IDevice device, ILaunchController launchController) {
        this.mLaunchInfo = launchInfo;
        this.mDevice = device;
        this.mLaunchController = launchController;
    }

    public void processNewLines(String[] lines) {
        ArrayList<String> array = new ArrayList<String>();
        boolean error = false;
        boolean warning = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() != 0) {
                Matcher m;
                if (this.mLaunchInfo.getAttemptCount() < 5 && !this.mLaunchInfo.isCancelled() && (m = sAmErrorType.matcher(s)).matches()) {
                    String msg;
                    int type = Integer.parseInt(m.group(1));
                    switch (type) {
                        case 1: 
                        case 2: {
                            msg = String.format("Device not ready. Waiting %1$d seconds before next attempt.", 3);
                            break;
                        }
                        case 3: {
                            msg = String.format("New package not yet registered with the system. Waiting %1$d seconds before next attempt.", 3);
                            break;
                        }
                        default: {
                            msg = String.format("Device not ready (%2$d). Waiting %1$d seconds before next attempt.", 3, type);
                        }
                    }
                    AndmoreAndroidPlugin.printToConsole(this.mLaunchInfo.getProject(), msg);
                    new Thread("Delayed Launch attempt"){

                        @Override
                        public void run() {
                            try {
                                1.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            AMReceiver.this.mLaunchController.launchApp(AMReceiver.this.mLaunchInfo, AMReceiver.this.mDevice);
                        }
                    }.start();
                    return;
                }
                if (!error && s.startsWith("Error:")) {
                    error = true;
                }
                if (!warning && s.startsWith("Warning:")) {
                    warning = true;
                }
                array.add("ActivityManager: " + s);
            }
            ++n2;
        }
        if (warning || error) {
            AndmoreAndroidPlugin.printErrorToConsole(this.mLaunchInfo.getProject(), array.toArray());
        } else {
            AndmoreAndroidPlugin.printToConsole(this.mLaunchInfo.getProject(), array.toArray());
        }
        if (error) {
            this.mLaunchController.stopLaunch(this.mLaunchInfo);
        }
    }

    public boolean isCancelled() {
        return this.mLaunchInfo.isCancelled();
    }
}

