/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import org.eclipse.andmore.internal.launch.EmulatorConfigTab;
import org.eclipse.andmore.internal.launch.LaunchConfigDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class AndroidLaunchConfiguration {
    public int mLaunchAction = 0;
    public TargetMode mTargetMode = LaunchConfigDelegate.DEFAULT_TARGET_MODE;
    public boolean mWipeData = false;
    public boolean mNoBootAnim = false;
    public String mAvdName = null;
    public String mNetworkSpeed = EmulatorConfigTab.getSpeed(0);
    public String mNetworkDelay = EmulatorConfigTab.getDelay(0);
    public String mEmulatorCommandLine;
    public boolean mReuseLastUsedDevice = false;
    public String mLastUsedDevice = null;

    public void set(ILaunchConfiguration config) {
        try {
            this.mLaunchAction = config.getAttribute("org.eclipse.andmore.action", this.mLaunchAction);
        }
        catch (CoreException coreException) {}
        this.mTargetMode = AndroidLaunchConfiguration.parseTargetMode(config, this.mTargetMode);
        try {
            this.mReuseLastUsedDevice = config.getAttribute("org.eclipse.andmore.reuse.last.used.device", false);
            this.mLastUsedDevice = config.getAttribute("org.eclipse.andmore.last.used.device", null);
        }
        catch (CoreException coreException) {}
        try {
            this.mAvdName = config.getAttribute("org.eclipse.andmore.avd", this.mAvdName);
        }
        catch (CoreException coreException) {}
        int index = 0;
        try {
            index = config.getAttribute("org.eclipse.andmore.speed", index);
        }
        catch (CoreException coreException) {}
        this.mNetworkSpeed = EmulatorConfigTab.getSpeed(index);
        index = 0;
        try {
            index = config.getAttribute("org.eclipse.andmore.delay", index);
        }
        catch (CoreException coreException) {}
        this.mNetworkDelay = EmulatorConfigTab.getDelay(index);
        try {
            this.mEmulatorCommandLine = config.getAttribute("org.eclipse.andmore.commandline", "");
        }
        catch (CoreException coreException) {}
        try {
            this.mWipeData = config.getAttribute("org.eclipse.andmore.wipedata", this.mWipeData);
        }
        catch (CoreException coreException) {}
        try {
            this.mNoBootAnim = config.getAttribute("org.eclipse.andmore.nobootanim", this.mNoBootAnim);
        }
        catch (CoreException coreException) {}
    }

    public static TargetMode parseTargetMode(ILaunchConfiguration config, TargetMode defaultMode) {
        try {
            String value = config.getAttribute("org.eclipse.andmore.target", defaultMode.toString());
            return TargetMode.getMode(value);
        }
        catch (CoreException coreException) {
            try {
                boolean value = config.getAttribute("org.eclipse.andmore.target", true);
                return value ? TargetMode.AUTO : TargetMode.MANUAL;
            }
            catch (CoreException coreException2) {
                return defaultMode;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return defaultMode;
        }
    }

    public static enum TargetMode {
        AUTO,
        MANUAL,
        ALL_DEVICES,
        ALL_EMULATORS,
        ALL_DEVICES_AND_EMULATORS;


        public static TargetMode getMode(String s) {
            TargetMode[] targetModeArray = TargetMode.values();
            int n = targetModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TargetMode m = targetModeArray[n2];
                if (m.toString().equals(s)) {
                    return m;
                }
                ++n2;
            }
            throw new IllegalArgumentException(String.format("Invalid representation (%s) for TargetMode", s));
        }

        public boolean isMultiDevice() {
            return this == ALL_DEVICES || this == ALL_EMULATORS || this == ALL_DEVICES_AND_EMULATORS;
        }
    }
}

