/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmuilib.ImageLoader;
import com.android.ddmuilib.TableHelper;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import com.android.utils.ILogger;
import java.util.ArrayList;
import org.eclipse.andmore.ddms.DdmsPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.launch.AvdCompatibility;
import org.eclipse.andmore.internal.sdk.AdtConsoleSdkLog;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class DeviceChooserDialog
extends Dialog
implements AndroidDebugBridge.IDeviceChangeListener {
    private static final int ICON_WIDTH = 16;
    private Table mDeviceTable;
    private TableViewer mViewer;
    private AvdSelector mPreferredAvdSelector;
    private Image mDeviceImage;
    private Image mEmulatorImage;
    private Image mMatchImage;
    private Image mNoMatchImage;
    private Image mWarningImage;
    private final DeviceChooserResponse mResponse;
    private final String mPackageName;
    private final IAndroidTarget mProjectTarget;
    private final AndroidVersion mMinApiVersion;
    private final Sdk mSdk;
    private Button mDeviceRadioButton;
    private Button mUseDeviceForFutureLaunchesCheckbox;
    private boolean mUseDeviceForFutureLaunches;
    private boolean mDisableAvdSelectionChange = false;

    public DeviceChooserDialog(Shell parent, DeviceChooserResponse response, String packageName, IAndroidTarget projectTarget, AndroidVersion minApiVersion, boolean useDeviceForFutureLaunches) {
        super(parent);
        this.mResponse = response;
        this.mPackageName = packageName;
        this.mProjectTarget = projectTarget;
        this.mMinApiVersion = minApiVersion;
        this.mSdk = Sdk.getCurrent();
        this.mUseDeviceForFutureLaunches = useDeviceForFutureLaunches;
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        this.loadImages();
    }

    private void cleanup() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    protected void okPressed() {
        this.cleanup();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.cleanup();
        super.cancelPressed();
    }

    protected Control createContents(Composite parent) {
        Control content = super.createContents(parent);
        this.updateDefaultSelection();
        return content;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.mUseDeviceForFutureLaunchesCheckbox = new Button(composite, 32);
        this.mUseDeviceForFutureLaunchesCheckbox.setSelection(this.mUseDeviceForFutureLaunches);
        this.mResponse.setUseDeviceForFutureLaunches(this.mUseDeviceForFutureLaunches);
        this.mUseDeviceForFutureLaunchesCheckbox.setText("Use same device for future launches");
        this.mUseDeviceForFutureLaunchesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceChooserDialog.this.mUseDeviceForFutureLaunches = DeviceChooserDialog.this.mUseDeviceForFutureLaunchesCheckbox.getSelection();
                DeviceChooserDialog.this.mResponse.setUseDeviceForFutureLaunches(DeviceChooserDialog.this.mUseDeviceForFutureLaunches);
            }
        });
        this.mUseDeviceForFutureLaunchesCheckbox.setLayoutData((Object)new GridData(768));
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Android Device Chooser");
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        String msg = this.mProjectTarget.isPlatform() ? String.format("Select a device with min API level %s.", this.mMinApiVersion.getApiString()) : String.format("Select a device compatible with target %s.", this.mProjectTarget.getFullName());
        Label label = new Label(top, 0);
        label.setText(msg);
        this.mDeviceRadioButton = new Button(top, 16);
        this.mDeviceRadioButton.setText("Choose a running Android device");
        this.mDeviceRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean deviceMode = DeviceChooserDialog.this.mDeviceRadioButton.getSelection();
                DeviceChooserDialog.this.mDeviceTable.setEnabled(deviceMode);
                DeviceChooserDialog.this.mPreferredAvdSelector.setEnabled(!deviceMode);
                if (deviceMode) {
                    DeviceChooserDialog.this.handleDeviceSelection();
                } else {
                    DeviceChooserDialog.this.mResponse.setAvdToLaunch(DeviceChooserDialog.this.mPreferredAvdSelector.getSelected());
                }
                DeviceChooserDialog.this.enableOkButton();
            }
        });
        this.mDeviceRadioButton.setSelection(true);
        Composite offsetComp = new Composite(top, 0);
        offsetComp.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 30;
        offsetComp.setLayout((Layout)layout);
        this.mDeviceTable = new Table(offsetComp, 67588);
        GridData gd = new GridData(1808);
        this.mDeviceTable.setLayoutData((Object)gd);
        gd.heightHint = 100;
        this.mDeviceTable.setHeaderVisible(true);
        this.mDeviceTable.setLinesVisible(true);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"Serial Number", (int)16384, (String)"AAA+AAAAAAAAAAAAAAAAAAA", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"AVD Name", (int)16384, (String)"AAAAAAAAAAAAAAAAAAA", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"Target", (int)16384, (String)"AAA+Android 9.9.9", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"Debug", (int)16384, (String)"Debug", null, null);
        TableHelper.createTableColumn((Table)this.mDeviceTable, (String)"State", (int)16384, (String)"bootloader", null, null);
        this.mViewer = new TableViewer(this.mDeviceTable);
        this.mViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.mViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.mViewer.setInput((Object)AndroidDebugBridge.getBridge());
        this.mDeviceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceChooserDialog.this.handleDeviceSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DeviceChooserDialog.this.handleDeviceSelection();
                if (DeviceChooserDialog.this.isOkButtonEnabled()) {
                    DeviceChooserDialog.this.okPressed();
                }
            }
        });
        Button radio2 = new Button(top, 16);
        radio2.setText("Launch a new Android Virtual Device");
        offsetComp = new Composite(top, 0);
        offsetComp.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 30;
        offsetComp.setLayout((Layout)layout);
        this.mPreferredAvdSelector = new AvdSelector(offsetComp, this.mSdk.getSdkOsLocation(), this.mSdk.getAvdManager(), (AvdSelector.IAvdFilter)new NonRunningAvdFilter(), AvdSelector.DisplayMode.SIMPLE_SELECTION, (ILogger)new AdtConsoleSdkLog());
        this.mPreferredAvdSelector.setTableHeightHint(100);
        this.mPreferredAvdSelector.setEnabled(false);
        this.mPreferredAvdSelector.setSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DeviceChooserDialog.this.mDisableAvdSelectionChange) {
                    DeviceChooserDialog.this.mResponse.setAvdToLaunch(DeviceChooserDialog.this.mPreferredAvdSelector.getSelected());
                    DeviceChooserDialog.this.enableOkButton();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
                if (DeviceChooserDialog.this.isOkButtonEnabled()) {
                    DeviceChooserDialog.this.okPressed();
                }
            }
        });
        return top;
    }

    private void loadImages() {
        ImageLoader ddmUiLibLoader = ImageLoader.getDdmUiLibLoader();
        Display display = DdmsPlugin.getDisplay();
        IconFactory factory = IconFactory.getInstance();
        if (this.mDeviceImage == null) {
            this.mDeviceImage = ddmUiLibLoader.loadImage(display, "device.png", 16, 16, display.getSystemColor(3));
        }
        if (this.mEmulatorImage == null) {
            this.mEmulatorImage = ddmUiLibLoader.loadImage(display, "emulator.png", 16, 16, display.getSystemColor(9));
        }
        if (this.mMatchImage == null) {
            this.mMatchImage = factory.getIcon("match", 6, 67);
        }
        if (this.mNoMatchImage == null) {
            this.mNoMatchImage = factory.getIcon("error", 4, 67);
        }
        if (this.mWarningImage == null) {
            this.mWarningImage = factory.getIcon("warning", 7, 67);
        }
    }

    private static String getStateString(IDevice d) {
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState == IDevice.DeviceState.ONLINE) {
            return "Online";
        }
        if (deviceState == IDevice.DeviceState.OFFLINE) {
            return "Offline";
        }
        if (deviceState == IDevice.DeviceState.BOOTLOADER) {
            return "Bootloader";
        }
        return "??";
    }

    public void deviceConnected(IDevice device) {
        final DeviceChooserDialog dialog = this;
        this.exec(new Runnable(){

            @Override
            public void run() {
                if (!DeviceChooserDialog.this.mDeviceTable.isDisposed()) {
                    DeviceChooserDialog.this.mViewer.refresh();
                    DeviceChooserDialog.this.updateDefaultSelection();
                    DeviceChooserDialog.this.refillAvdList(false);
                } else {
                    AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)dialog);
                }
            }
        });
    }

    public void deviceDisconnected(IDevice device) {
        this.deviceConnected(device);
    }

    public void deviceChanged(final IDevice device, int changeMask) {
        if ((changeMask & 5) != 0) {
            final DeviceChooserDialog dialog = this;
            this.exec(new Runnable(){

                @Override
                public void run() {
                    if (!DeviceChooserDialog.this.mDeviceTable.isDisposed()) {
                        DeviceChooserDialog.this.mViewer.refresh((Object)device);
                        DeviceChooserDialog.this.updateDefaultSelection();
                        DeviceChooserDialog.this.refillAvdList(false);
                        if (device == DeviceChooserDialog.this.mResponse.getDeviceToUse()) {
                            DeviceChooserDialog.this.enableOkButton();
                        }
                    } else {
                        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)dialog);
                    }
                }
            });
        }
    }

    private boolean isDeviceMode() {
        return this.mDeviceRadioButton.getSelection();
    }

    private void enableOkButton() {
        Button okButton = this.getButton(0);
        if (this.isDeviceMode()) {
            okButton.setEnabled(this.mResponse.getDeviceToUse() != null && this.mResponse.getDeviceToUse().isOnline());
        } else {
            okButton.setEnabled(this.mResponse.getAvdToLaunch() != null);
        }
    }

    private boolean isOkButtonEnabled() {
        Button okButton = this.getButton(0);
        return okButton.isEnabled();
    }

    private void exec(Runnable runnable) {
        try {
            Display display = this.mDeviceTable.getDisplay();
            display.asyncExec(runnable);
        }
        catch (SWTException sWTException) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        }
    }

    private void handleDeviceSelection() {
        int count = this.mDeviceTable.getSelectionCount();
        if (count != 1) {
            this.handleSelection(null);
        } else {
            int index = this.mDeviceTable.getSelectionIndex();
            Object data = this.mViewer.getElementAt(index);
            if (data instanceof IDevice) {
                this.handleSelection((IDevice)data);
            } else {
                this.handleSelection(null);
            }
        }
    }

    private void handleSelection(IDevice device) {
        this.mResponse.setDeviceToUse(device);
        this.enableOkButton();
    }

    private void updateDefaultSelection() {
        if (this.mDeviceTable.getSelectionCount() == 0) {
            IDevice[] devices;
            AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
            IDevice[] iDeviceArray = devices = bridge.getDevices();
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                Client[] clients;
                IDevice device = iDeviceArray[n2];
                Client[] clientArray = clients = device.getClients();
                int n3 = clients.length;
                int n4 = 0;
                while (n4 < n3) {
                    Client client = clientArray[n4];
                    if (this.mPackageName.equals(client.getClientData().getClientDescription())) {
                        this.mViewer.setSelection((ISelection)new StructuredSelection((Object)device));
                        this.handleSelection(device);
                        return;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        this.handleDeviceSelection();
    }

    private void refillAvdList(boolean reloadAvds) {
        AvdInfo selected = this.mPreferredAvdSelector.getSelected();
        this.mDisableAvdSelectionChange = true;
        this.mPreferredAvdSelector.refresh(false);
        if (selected != null && !this.mPreferredAvdSelector.setSelection(selected)) {
            this.mResponse.setAvdToLaunch(null);
            this.enableOkButton();
        }
        this.mDisableAvdSelectionChange = false;
    }

    private class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof AndroidDebugBridge) {
                return this.findCompatibleDevices(((AndroidDebugBridge)inputElement).getDevices());
            }
            return new Object[0];
        }

        private Object[] findCompatibleDevices(IDevice[] devices) {
            if (devices == null) {
                return null;
            }
            ArrayList<IDevice> compatibleDevices = new ArrayList<IDevice>(devices.length);
            IDevice[] iDeviceArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                IDevice device = iDeviceArray[n2];
                AndroidVersion deviceVersion = Sdk.getDeviceVersion(device);
                if (deviceVersion == null || deviceVersion.canRun(DeviceChooserDialog.this.mMinApiVersion)) {
                    compatibleDevices.add(device);
                }
                ++n2;
            }
            return compatibleDevices.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static class DeviceChooserResponse {
        private AvdInfo mAvdToLaunch;
        private IDevice mDeviceToUse;
        private boolean mUseDeviceForFutureLaunches;

        public void setDeviceToUse(IDevice d) {
            this.mDeviceToUse = d;
            this.mAvdToLaunch = null;
        }

        public void setAvdToLaunch(AvdInfo avd) {
            this.mAvdToLaunch = avd;
            this.mDeviceToUse = null;
        }

        public IDevice getDeviceToUse() {
            return this.mDeviceToUse;
        }

        public AvdInfo getAvdToLaunch() {
            return this.mAvdToLaunch;
        }

        public void setUseDeviceForFutureLaunches(boolean en) {
            this.mUseDeviceForFutureLaunches = en;
        }

        public boolean useDeviceForFutureLaunches() {
            return this.mUseDeviceForFutureLaunches;
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof IDevice) {
                IDevice device = (IDevice)element;
                switch (columnIndex) {
                    case 0: {
                        return device.isEmulator() ? DeviceChooserDialog.this.mEmulatorImage : DeviceChooserDialog.this.mDeviceImage;
                    }
                    case 2: {
                        if (!device.isEmulator()) {
                            AndroidVersion deviceVersion = Sdk.getDeviceVersion(device);
                            if (deviceVersion == null) {
                                return DeviceChooserDialog.this.mWarningImage;
                            }
                            if (!deviceVersion.canRun(DeviceChooserDialog.this.mMinApiVersion)) {
                                return DeviceChooserDialog.this.mNoMatchImage;
                            }
                            return DeviceChooserDialog.this.mProjectTarget.isPlatform() ? DeviceChooserDialog.this.mMatchImage : DeviceChooserDialog.this.mWarningImage;
                        }
                        AvdInfo info = DeviceChooserDialog.this.mSdk.getAvdManager().getAvd(device.getAvdName(), true);
                        AvdCompatibility.Compatibility c = AvdCompatibility.canRun(info, DeviceChooserDialog.this.mProjectTarget, DeviceChooserDialog.this.mMinApiVersion);
                        switch (c) {
                            case YES: {
                                return DeviceChooserDialog.this.mMatchImage;
                            }
                            case NO: {
                                return DeviceChooserDialog.this.mNoMatchImage;
                            }
                            case UNKNOWN: {
                                return DeviceChooserDialog.this.mWarningImage;
                            }
                        }
                    }
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IDevice) {
                IDevice device = (IDevice)element;
                switch (columnIndex) {
                    case 0: {
                        return device.getName();
                    }
                    case 1: {
                        if (device.isEmulator()) {
                            return device.getAvdName();
                        }
                        return "N/A";
                    }
                    case 2: {
                        if (device.isEmulator()) {
                            AvdInfo info = DeviceChooserDialog.this.mSdk.getAvdManager().getAvd(device.getAvdName(), true);
                            if (info == null) {
                                return "?";
                            }
                            return info.getTarget().getFullName();
                        }
                        String deviceBuild = device.getProperty("ro.build.version.release");
                        if (deviceBuild == null) {
                            return "unknown";
                        }
                        return deviceBuild;
                    }
                    case 3: {
                        String debuggable = device.getProperty("ro.debuggable");
                        if (debuggable != null && debuggable.equals("1")) {
                            return "Yes";
                        }
                        return "";
                    }
                    case 4: {
                        return DeviceChooserDialog.getStateString(device);
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class NonRunningAvdFilter
    implements AvdSelector.IAvdFilter {
        private IDevice[] mDevices;

        private NonRunningAvdFilter() {
        }

        public void prepare() {
            this.mDevices = AndroidDebugBridge.getBridge().getDevices();
        }

        public boolean accept(AvdInfo avd) {
            if (this.mDevices != null) {
                IDevice[] iDeviceArray = this.mDevices;
                if (this.mDevices.length != 0) {
                    IDevice d = iDeviceArray[0];
                    if (avd.getName().equals(d.getAvdName())) {
                        return false;
                    }
                    AvdCompatibility.Compatibility c = AvdCompatibility.canRun(avd, DeviceChooserDialog.this.mProjectTarget, DeviceChooserDialog.this.mMinApiVersion);
                    return c != AvdCompatibility.Compatibility.NO;
                }
            }
            return true;
        }

        public void cleanup() {
            this.mDevices = null;
        }
    }
}

