/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.launch;

import com.android.ddmuilib.ImageLoader;
import com.android.prefs.AndroidLocation;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdkuilib.internal.widgets.AvdSelector;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.launch.AndroidLaunchConfiguration;
import org.eclipse.andmore.internal.launch.AvdCompatibility;
import org.eclipse.andmore.internal.launch.LaunchConfigDelegate;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.sdk.AdtConsoleSdkLog;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EmulatorConfigTab
extends AbstractLaunchConfigurationTab {
    private static final String[][] NETWORK_SPEEDS = new String[][]{{"Full", "full"}, {"GSM", "gsm"}, {"HSCSD", "hscsd"}, {"GPRS", "gprs"}, {"EDGE", "edge"}, {"UMTS", "umts"}, {"HSPDA", "hsdpa"}};
    private static final String[][] NETWORK_LATENCIES = new String[][]{{"None", "none"}, {"GPRS", "gprs"}, {"EDGE", "edge"}, {"UMTS", "umts"}};
    private Button mAutoTargetButton;
    private Button mManualTargetButton;
    private AvdSelector mPreferredAvdSelector;
    private Combo mSpeedCombo;
    private Combo mDelayCombo;
    private Group mEmulatorOptionsGroup;
    private Text mEmulatorCLOptions;
    private Button mWipeDataButton;
    private Button mNoBootAnimButton;
    private Label mPreferredAvdLabel;
    private IAndroidTarget mProjectTarget;
    private AndroidVersion mProjectMinApiVersion;
    private Button mFutureLaunchesOnSameDevice;
    private boolean mSupportMultiDeviceLaunch;
    private Button mAllDevicesTargetButton;
    private Combo mDeviceTypeCombo;
    private static final String DEVICES_AND_EMULATORS = "Active devices and AVD's";
    private static final String EMULATORS_ONLY = "Active AVD's";
    private static final String DEVICES_ONLY = "Active devices";

    public static String getSpeed(int value) {
        try {
            return NETWORK_SPEEDS[value][1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return NETWORK_SPEEDS[0][1];
        }
    }

    public static String getDelay(int value) {
        try {
            return NETWORK_LATENCIES[value][1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return NETWORK_LATENCIES[0][1];
        }
    }

    public EmulatorConfigTab(boolean supportMultiDeviceLaunch) {
        this.mSupportMultiDeviceLaunch = supportMultiDeviceLaunch;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        try {
            Sdk sdk = Sdk.getCurrent();
            if (sdk != null) {
                AvdManager avdMan = sdk.getAvdManager();
                assert (avdMan != null);
                avdMan.reloadAvds(NullLogger.getLogger());
            }
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {}
        Composite topComp = new Composite(parent, 0);
        this.setControl((Control)topComp);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topLayout.verticalSpacing = 0;
        topComp.setLayout((Layout)topLayout);
        topComp.setFont(font);
        Group targetModeGroup = new Group(topComp, 0);
        targetModeGroup.setText("Deployment Target Selection Mode");
        GridData gd = new GridData(768);
        targetModeGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        targetModeGroup.setLayout((Layout)layout);
        targetModeGroup.setFont(font);
        this.mManualTargetButton = new Button((Composite)targetModeGroup, 16);
        this.mManualTargetButton.setText("Always prompt to pick device");
        this.mAllDevicesTargetButton = new Button((Composite)targetModeGroup, 16);
        this.mAllDevicesTargetButton.setText("Launch on all compatible devices/AVD's");
        this.mAllDevicesTargetButton.setEnabled(this.mSupportMultiDeviceLaunch);
        Composite deviceTypeOffsetComp = new Composite((Composite)targetModeGroup, 0);
        deviceTypeOffsetComp.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 30;
        deviceTypeOffsetComp.setLayout((Layout)layout);
        this.mDeviceTypeCombo = new Combo(deviceTypeOffsetComp, 8);
        this.mDeviceTypeCombo.setItems(new String[]{DEVICES_AND_EMULATORS, EMULATORS_ONLY, DEVICES_ONLY});
        this.mDeviceTypeCombo.select(0);
        this.mDeviceTypeCombo.setEnabled(false);
        this.mAutoTargetButton = new Button((Composite)targetModeGroup, 16);
        this.mAutoTargetButton.setText("Automatically pick compatible device: Always uses preferred AVD if set below, launches on compatible device/AVD otherwise.");
        this.mAutoTargetButton.setSelection(true);
        SelectionAdapter targetModeChangeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorConfigTab.this.targetModeChanged();
            }
        };
        this.mAutoTargetButton.addSelectionListener((SelectionListener)targetModeChangeListener);
        this.mAllDevicesTargetButton.addSelectionListener((SelectionListener)targetModeChangeListener);
        this.mManualTargetButton.addSelectionListener((SelectionListener)targetModeChangeListener);
        Composite avdOffsetComp = new Composite((Composite)targetModeGroup, 0);
        avdOffsetComp.setLayoutData((Object)new GridData(768));
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginRight = 0;
        layout.marginLeft = 30;
        avdOffsetComp.setLayout((Layout)layout);
        this.mPreferredAvdLabel = new Label(avdOffsetComp, 0);
        this.mPreferredAvdLabel.setText("Select a preferred Android Virtual Device for deployment:");
        this.mPreferredAvdSelector = new AvdSelector(avdOffsetComp, Sdk.getCurrent().getSdkOsLocation(), null, AvdSelector.DisplayMode.SIMPLE_CHECK, (ILogger)new AdtConsoleSdkLog());
        this.mPreferredAvdSelector.setTableHeightHint(100);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.mPreferredAvdSelector.setSelectionListener((SelectionListener)listener);
        this.mDeviceTypeCombo.addSelectionListener((SelectionListener)listener);
        this.mFutureLaunchesOnSameDevice = new Button((Composite)targetModeGroup, 32);
        this.mFutureLaunchesOnSameDevice.setText("Use same device for future launches");
        this.mFutureLaunchesOnSameDevice.addSelectionListener((SelectionListener)listener);
        this.mEmulatorOptionsGroup = new Group(topComp, 0);
        this.mEmulatorOptionsGroup.setText("Emulator launch parameters:");
        this.mEmulatorOptionsGroup.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.numColumns = 2;
        this.mEmulatorOptionsGroup.setLayout((Layout)layout);
        this.mEmulatorOptionsGroup.setFont(font);
        Label l = new Label((Composite)this.mEmulatorOptionsGroup, 0);
        l.setText("If no compatible and active devices or AVD's are found, then an AVD might be launched. Provide options for the AVD launch below.");
        gd = new GridData();
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        new Label((Composite)this.mEmulatorOptionsGroup, 0).setText("Network Speed:");
        this.mSpeedCombo = new Combo((Composite)this.mEmulatorOptionsGroup, 8);
        String[][] stringArray = NETWORK_SPEEDS;
        int n = NETWORK_SPEEDS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] speed = stringArray[n2];
            this.mSpeedCombo.add(speed[0]);
            ++n2;
        }
        this.mSpeedCombo.addSelectionListener((SelectionListener)listener);
        this.mSpeedCombo.pack();
        new Label((Composite)this.mEmulatorOptionsGroup, 0).setText("Network Latency:");
        this.mDelayCombo = new Combo((Composite)this.mEmulatorOptionsGroup, 8);
        stringArray = NETWORK_LATENCIES;
        n = NETWORK_LATENCIES.length;
        n2 = 0;
        while (n2 < n) {
            String[] delay = stringArray[n2];
            this.mDelayCombo.add(delay[0]);
            ++n2;
        }
        this.mDelayCombo.addSelectionListener((SelectionListener)listener);
        this.mDelayCombo.pack();
        this.mWipeDataButton = new Button((Composite)this.mEmulatorOptionsGroup, 32);
        this.mWipeDataButton.setText("Wipe User Data");
        this.mWipeDataButton.setToolTipText("Check this if you want to wipe your user data each time you start the emulator. You will be prompted for confirmation when the emulator starts.");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mWipeDataButton.setLayoutData((Object)gd);
        this.mWipeDataButton.addSelectionListener((SelectionListener)listener);
        this.mNoBootAnimButton = new Button((Composite)this.mEmulatorOptionsGroup, 32);
        this.mNoBootAnimButton.setText("Disable Boot Animation");
        this.mNoBootAnimButton.setToolTipText("Check this if you want to disable the boot animation. This can help the emulator start faster on slow machines.");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mNoBootAnimButton.setLayoutData((Object)gd);
        this.mNoBootAnimButton.addSelectionListener((SelectionListener)listener);
        l = new Label((Composite)this.mEmulatorOptionsGroup, 0);
        l.setText("Additional Emulator Command Line Options");
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        this.mEmulatorCLOptions = new Text((Composite)this.mEmulatorOptionsGroup, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.mEmulatorCLOptions.setLayoutData((Object)gd);
        this.mEmulatorCLOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EmulatorConfigTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void targetModeChanged() {
        this.updateLaunchConfigurationDialog();
        boolean auto = this.mAutoTargetButton.getSelection();
        this.mPreferredAvdSelector.setEnabled(auto);
        this.mPreferredAvdLabel.setEnabled(auto);
        boolean all = this.mAllDevicesTargetButton.getSelection();
        this.mDeviceTypeCombo.setEnabled(all);
    }

    public String getName() {
        return "Target";
    }

    public Image getImage() {
        return ImageLoader.getDdmUiLibLoader().loadImage("emulator.png", null);
    }

    private void updateAvdList(AvdManager avdManager) {
        if (avdManager == null) {
            avdManager = Sdk.getCurrent().getAvdManager();
        }
        this.mPreferredAvdSelector.setManager(avdManager);
        this.mPreferredAvdSelector.refresh(false);
        this.mPreferredAvdSelector.setFilter(new AvdSelector.IAvdFilter(){

            public void prepare() {
            }

            public void cleanup() {
            }

            public boolean accept(AvdInfo avd) {
                AvdCompatibility.Compatibility c = AvdCompatibility.canRun(avd, EmulatorConfigTab.this.mProjectTarget, EmulatorConfigTab.this.mProjectMinApiVersion);
                return c != AvdCompatibility.Compatibility.NO;
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean reuseLastUsedDevice;
        AvdManager avdManager = Sdk.getCurrent().getAvdManager();
        AndroidLaunchConfiguration.TargetMode mode = AndroidLaunchConfiguration.parseTargetMode(configuration, LaunchConfigDelegate.DEFAULT_TARGET_MODE);
        boolean multipleDevices = mode.isMultiDevice();
        if (multipleDevices && !this.mSupportMultiDeviceLaunch) {
            multipleDevices = false;
            mode = LaunchConfigDelegate.DEFAULT_TARGET_MODE;
        }
        this.mAutoTargetButton.setSelection(mode == AndroidLaunchConfiguration.TargetMode.AUTO);
        this.mManualTargetButton.setSelection(mode == AndroidLaunchConfiguration.TargetMode.MANUAL);
        this.mAllDevicesTargetButton.setSelection(multipleDevices);
        this.targetModeChanged();
        try {
            reuseLastUsedDevice = configuration.getAttribute("org.eclipse.andmore.reuse.last.used.device", false);
        }
        catch (CoreException coreException) {
            reuseLastUsedDevice = false;
        }
        this.mFutureLaunchesOnSameDevice.setSelection(reuseLastUsedDevice);
        this.mDeviceTypeCombo.setEnabled(multipleDevices);
        if (multipleDevices) {
            int index = 0;
            if (mode == AndroidLaunchConfiguration.TargetMode.ALL_EMULATORS) {
                index = 1;
            } else if (mode == AndroidLaunchConfiguration.TargetMode.ALL_DEVICES) {
                index = 2;
            }
            this.mDeviceTypeCombo.select(index);
        }
        String stringValue = "";
        try {
            stringValue = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, stringValue);
        }
        catch (CoreException coreException) {}
        IProject project = null;
        IJavaProject[] projects = BaseProjectHelper.getAndroidProjects(null);
        if (projects != null) {
            IJavaProject[] iJavaProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject p = iJavaProjectArray[n2];
                if (p.getElementName().equals(stringValue)) {
                    project = p.getProject();
                    break;
                }
                ++n2;
            }
        }
        if (project != null) {
            this.mProjectTarget = Sdk.getCurrent().getTarget(project);
            ManifestInfo mi = ManifestInfo.get(project);
            int minApiLevel = mi.getMinSdkVersion();
            String minApiCodeName = mi.getMinSdkCodeName();
            this.mProjectMinApiVersion = new AndroidVersion(minApiLevel, minApiCodeName);
        }
        this.updateAvdList(avdManager);
        stringValue = "";
        try {
            stringValue = configuration.getAttribute("org.eclipse.andmore.avd", stringValue);
        }
        catch (CoreException coreException) {}
        if (stringValue != null && stringValue.length() > 0 && avdManager != null) {
            AvdInfo targetAvd = avdManager.getAvd(stringValue, true);
            this.mPreferredAvdSelector.setSelection(targetAvd);
        } else {
            this.mPreferredAvdSelector.setSelection(null);
        }
        boolean value = false;
        try {
            value = configuration.getAttribute("org.eclipse.andmore.wipedata", value);
        }
        catch (CoreException coreException) {}
        this.mWipeDataButton.setSelection(value);
        value = false;
        try {
            value = configuration.getAttribute("org.eclipse.andmore.nobootanim", value);
        }
        catch (CoreException coreException) {}
        this.mNoBootAnimButton.setSelection(value);
        int index = -1;
        index = 0;
        try {
            index = configuration.getAttribute("org.eclipse.andmore.speed", index);
        }
        catch (CoreException coreException) {}
        if (index == -1) {
            this.mSpeedCombo.clearSelection();
        } else {
            this.mSpeedCombo.select(index);
        }
        index = 0;
        try {
            index = configuration.getAttribute("org.eclipse.andmore.delay", index);
        }
        catch (CoreException coreException) {}
        if (index == -1) {
            this.mDelayCombo.clearSelection();
        } else {
            this.mDelayCombo.select(index);
        }
        String commandLine = null;
        try {
            commandLine = configuration.getAttribute("org.eclipse.andmore.commandline", "");
        }
        catch (CoreException coreException) {}
        if (commandLine != null) {
            this.mEmulatorCLOptions.setText(commandLine);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.andmore.target", this.getCurrentTargetMode().toString());
        configuration.setAttribute("org.eclipse.andmore.reuse.last.used.device", this.mFutureLaunchesOnSameDevice.getSelection());
        AvdInfo avd = this.mPreferredAvdSelector.getSelected();
        if (avd != null) {
            configuration.setAttribute("org.eclipse.andmore.avd", avd.getName());
        } else {
            configuration.setAttribute("org.eclipse.andmore.avd", null);
        }
        configuration.setAttribute("org.eclipse.andmore.speed", this.mSpeedCombo.getSelectionIndex());
        configuration.setAttribute("org.eclipse.andmore.delay", this.mDelayCombo.getSelectionIndex());
        configuration.setAttribute("org.eclipse.andmore.commandline", this.mEmulatorCLOptions.getText());
        configuration.setAttribute("org.eclipse.andmore.wipedata", this.mWipeDataButton.getSelection());
        configuration.setAttribute("org.eclipse.andmore.nobootanim", this.mNoBootAnimButton.getSelection());
    }

    private AndroidLaunchConfiguration.TargetMode getCurrentTargetMode() {
        if (this.mAutoTargetButton.getSelection()) {
            return AndroidLaunchConfiguration.TargetMode.AUTO;
        }
        if (this.mManualTargetButton.getSelection()) {
            return AndroidLaunchConfiguration.TargetMode.MANUAL;
        }
        String selection = this.mDeviceTypeCombo.getText();
        if (DEVICES_AND_EMULATORS.equals(selection)) {
            return AndroidLaunchConfiguration.TargetMode.ALL_DEVICES_AND_EMULATORS;
        }
        if (DEVICES_ONLY.equals(selection)) {
            return AndroidLaunchConfiguration.TargetMode.ALL_DEVICES;
        }
        if (EMULATORS_ONLY.equals(selection)) {
            return AndroidLaunchConfiguration.TargetMode.ALL_EMULATORS;
        }
        return AndroidLaunchConfiguration.TargetMode.AUTO;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.andmore.target", LaunchConfigDelegate.DEFAULT_TARGET_MODE.toString());
        configuration.setAttribute("org.eclipse.andmore.speed", 0);
        configuration.setAttribute("org.eclipse.andmore.delay", 0);
        configuration.setAttribute("org.eclipse.andmore.wipedata", false);
        configuration.setAttribute("org.eclipse.andmore.nobootanim", false);
        IPreferenceStore store = AndmoreAndroidPlugin.getDefault().getPreferenceStore();
        String emuOptions = store.getString("org.eclipse.andmore.emuOptions");
        configuration.setAttribute("org.eclipse.andmore.commandline", emuOptions);
    }
}

