/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.ApiDetector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

class AddSuppressAnnotation
implements IMarkerResolution2 {
    private final IMarker mMarker;
    private final String mId;
    private final BodyDeclaration mNode;
    private final String mDescription;
    private final String mTargetApi;

    private AddSuppressAnnotation(String id, IMarker marker, BodyDeclaration node, String description, String targetApi) {
        this.mId = id;
        this.mMarker = marker;
        this.mNode = node;
        this.mDescription = description;
        this.mTargetApi = targetApi;
    }

    public String getLabel() {
        return this.mDescription;
    }

    public String getDescription() {
        return null;
    }

    public Image getImage() {
        return IconFactory.getInstance().getIcon("newannotation");
    }

    public void run(IMarker marker) {
        IEditorInput editorInput;
        ITextEditor textEditor = AdtUtils.getActiveTextEditor();
        IDocumentProvider provider = textEditor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)(editorInput = textEditor.getEditorInput()));
        if (document == null) {
            return;
        }
        IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
        ICompilationUnit compilationUnit = manager.getWorkingCopy(editorInput);
        try {
            MultiTextEdit edit = this.mTargetApi == null ? this.addSuppressAnnotation(document, compilationUnit, this.mNode) : this.addTargetApiAnnotation(document, compilationUnit, this.mNode);
            if (edit != null) {
                edit.apply(document);
                this.mMarker.delete();
            }
        }
        catch (Exception ex) {
            AndmoreAndroidPlugin.log(ex, "Could not add suppress annotation", new Object[0]);
        }
    }

    private MultiTextEdit addSuppressAnnotation(IDocument document, ICompilationUnit compilationUnit, BodyDeclaration declaration) throws CoreException {
        List modifiers = declaration.modifiers();
        SingleMemberAnnotation existing = null;
        for (Object o : modifiers) {
            SingleMemberAnnotation annotation;
            String type;
            if (!(o instanceof SingleMemberAnnotation) || !(type = (annotation = (SingleMemberAnnotation)o).getTypeName().getFullyQualifiedName()).equals("android.annotation.SuppressLint") && !type.endsWith("SuppressLint")) continue;
            existing = annotation;
            break;
        }
        ImportRewrite importRewrite = ImportRewrite.create((ICompilationUnit)compilationUnit, (boolean)true);
        String local = importRewrite.addImport("android.annotation.SuppressLint");
        AST ast = declaration.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        if (existing == null) {
            SingleMemberAnnotation newAnnotation = ast.newSingleMemberAnnotation();
            newAnnotation.setTypeName((Name)ast.newSimpleName(local));
            StringLiteral value = ast.newStringLiteral();
            value.setLiteralValue(this.mId);
            newAnnotation.setValue((Expression)value);
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)declaration, declaration.getModifiersProperty());
            listRewrite.insertFirst((ASTNode)newAnnotation, null);
        } else {
            Expression existingValue = existing.getValue();
            if (existingValue instanceof StringLiteral) {
                StringLiteral stringLiteral = (StringLiteral)existingValue;
                if (this.mId.equals(stringLiteral.getLiteralValue())) {
                    return null;
                }
                ArrayInitializer array = ast.newArrayInitializer();
                StringLiteral old = ast.newStringLiteral();
                old.setLiteralValue(stringLiteral.getLiteralValue());
                array.expressions().add(old);
                StringLiteral value = ast.newStringLiteral();
                value.setLiteralValue(this.mId);
                array.expressions().add(value);
                rewriter.set((ASTNode)existing, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)array, null);
            } else if (existingValue instanceof ArrayInitializer) {
                ArrayInitializer array = (ArrayInitializer)existingValue;
                List expressions = array.expressions();
                if (expressions != null) {
                    for (Object o : expressions) {
                        if (!(o instanceof StringLiteral) || !this.mId.equals(((StringLiteral)o).getLiteralValue())) continue;
                        return null;
                    }
                }
                StringLiteral value = ast.newStringLiteral();
                value.setLiteralValue(this.mId);
                ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)array, ArrayInitializer.EXPRESSIONS_PROPERTY);
                listRewrite.insertLast((ASTNode)value, null);
            } else {
                assert (false) : existingValue;
                return null;
            }
        }
        TextEdit importEdits = importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
        TextEdit annotationEdits = rewriter.rewriteAST(document, null);
        MultiTextEdit edit = new MultiTextEdit();
        if (importEdits.hasChildren()) {
            edit.addChild(importEdits);
        }
        edit.addChild(annotationEdits);
        return edit;
    }

    private MultiTextEdit addTargetApiAnnotation(IDocument document, ICompilationUnit compilationUnit, BodyDeclaration declaration) throws CoreException {
        List modifiers = declaration.modifiers();
        SingleMemberAnnotation existing = null;
        for (Object o : modifiers) {
            SingleMemberAnnotation annotation;
            String type;
            if (!(o instanceof SingleMemberAnnotation) || !(type = (annotation = (SingleMemberAnnotation)o).getTypeName().getFullyQualifiedName()).equals("android.annotation.TargetApi") && !type.endsWith("TargetApi")) continue;
            existing = annotation;
            break;
        }
        ImportRewrite importRewrite = ImportRewrite.create((ICompilationUnit)compilationUnit, (boolean)true);
        importRewrite.addImport("android.os.Build");
        String local = importRewrite.addImport("android.annotation.TargetApi");
        AST ast = declaration.getAST();
        ASTRewrite rewriter = ASTRewrite.create((AST)ast);
        if (existing == null) {
            SingleMemberAnnotation newAnnotation = ast.newSingleMemberAnnotation();
            newAnnotation.setTypeName((Name)ast.newSimpleName(local));
            Expression value = this.createLiteral(ast);
            newAnnotation.setValue(value);
            ListRewrite listRewrite = rewriter.getListRewrite((ASTNode)declaration, declaration.getModifiersProperty());
            listRewrite.insertFirst((ASTNode)newAnnotation, null);
        } else {
            Expression value = this.createLiteral(ast);
            rewriter.set((ASTNode)existing, (StructuralPropertyDescriptor)SingleMemberAnnotation.VALUE_PROPERTY, (Object)value, null);
        }
        TextEdit importEdits = importRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor());
        TextEdit annotationEdits = rewriter.rewriteAST(document, null);
        MultiTextEdit edit = new MultiTextEdit();
        if (importEdits.hasChildren()) {
            edit.addChild(importEdits);
        }
        edit.addChild(annotationEdits);
        return edit;
    }

    private Expression createLiteral(AST ast) {
        Object value = !this.isCodeName() ? ast.newQualifiedName((Name)ast.newQualifiedName((Name)ast.newSimpleName("Build"), ast.newSimpleName("VERSION_CODES")), ast.newSimpleName(this.mTargetApi)) : ast.newNumberLiteral(this.mTargetApi);
        return value;
    }

    private boolean isCodeName() {
        return Character.isDigit(this.mTargetApi.charAt(0));
    }

    public static void createFixes(IMarker marker, String id, List<IMarkerResolution> resolutions) {
        CompilationUnit coveringNode;
        Issue issue;
        boolean isClassDetector;
        Pattern pattern;
        Matcher matcher;
        String message;
        IEditorInput editorInput;
        ITextEditor textEditor = AdtUtils.getActiveTextEditor();
        IDocumentProvider provider = textEditor.getDocumentProvider();
        IDocument document = provider.getDocument((Object)(editorInput = textEditor.getEditorInput()));
        if (document == null) {
            return;
        }
        IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
        ICompilationUnit compilationUnit = manager.getWorkingCopy(editorInput);
        int offset = 0;
        int length = 0;
        int start = marker.getAttribute("charStart", -1);
        int end = marker.getAttribute("charEnd", -1);
        offset = start;
        length = end - start;
        CompilationUnit root = SharedASTProvider.getAST((ITypeRoot)compilationUnit, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        if (root == null) {
            return;
        }
        int api = -1;
        if ((id.equals(ApiDetector.UNSUPPORTED.getId()) || id.equals(ApiDetector.INLINED.getId())) && (message = marker.getAttribute("message", null)) != null && (matcher = (pattern = Pattern.compile("\\s(\\d+)\\s")).matcher(message)).find()) {
            api = Integer.parseInt(matcher.group(1));
        }
        boolean bl = isClassDetector = (issue = EclipseLintClient.getRegistry().getIssue(id)) != null && issue.getImplementation().getScope().contains(Scope.CLASS_FILE);
        if (issue == AnnotationDetector.INSIDE_METHOD) {
            return;
        }
        NodeFinder nodeFinder = new NodeFinder((ASTNode)root, offset, length);
        if (offset <= 0) {
            Object type;
            coveringNode = root;
            if (root.types() != null && root.types().size() > 0 && (type = root.types().get(0)) instanceof ASTNode) {
                coveringNode = (ASTNode)type;
            }
        } else {
            coveringNode = nodeFinder.getCoveringNode();
        }
        CompilationUnit body = coveringNode;
        while (body != null) {
            if (body instanceof BodyDeclaration) {
                BodyDeclaration declaration = (BodyDeclaration)body;
                String target = null;
                if (body instanceof MethodDeclaration) {
                    target = String.valueOf(((MethodDeclaration)body).getName().toString()) + "()";
                } else if (body instanceof FieldDeclaration) {
                    ASTNode first;
                    target = "field";
                    FieldDeclaration field = (FieldDeclaration)body;
                    if (field.fragments() != null && field.fragments().size() > 0 && (first = (ASTNode)field.fragments().get(0)) instanceof VariableDeclarationFragment) {
                        VariableDeclarationFragment decl = (VariableDeclarationFragment)first;
                        target = decl.getName().toString();
                    }
                } else {
                    target = body instanceof AnonymousClassDeclaration ? "anonymous class" : (body instanceof TypeDeclaration ? ((TypeDeclaration)body).getName().toString() : body.getClass().getSimpleName());
                }
                if (!isClassDetector || body instanceof MethodDeclaration || body instanceof TypeDeclaration || body instanceof FieldDeclaration) {
                    String desc = String.format("Add @SuppressLint '%1$s' to '%2$s'", id, target);
                    resolutions.add((IMarkerResolution)new AddSuppressAnnotation(id, marker, declaration, desc, null));
                    if (api != -1 && (body instanceof MethodDeclaration || body instanceof TypeDeclaration)) {
                        String apiString = SdkVersionInfo.getBuildCode((int)api);
                        if (apiString == null) {
                            apiString = Integer.toString(api);
                        }
                        desc = String.format("Add @TargetApi(%1$s) to '%2$s'", apiString, target);
                        resolutions.add((IMarkerResolution)new AddSuppressAnnotation(id, marker, declaration, desc, apiString));
                    }
                }
            }
            body = body.getParent();
        }
    }
}

