/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.client.api.IssueRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.lint.LintJob;
import org.eclipse.andmore.internal.lint.LintViewPart;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;

public class EclipseLintRunner {
    static final String MARKER_CHECKID_PROPERTY = "checkid";

    private static boolean runLint(List<? extends IResource> resources, IResource source, IDocument doc, boolean fatalOnly) {
        resources = EclipseLintRunner.addLibraries(resources);
        LintJob job = (LintJob)EclipseLintRunner.startLint(resources, source, doc, fatalOnly, false);
        try {
            job.join();
            boolean fatal = job.isFatal();
            if (fatal) {
                LintViewPart.show(resources);
            }
            return fatal;
        }
        catch (InterruptedException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return false;
        }
    }

    public static Job startLint(List<? extends IResource> resources, IResource source, IDocument doc, boolean fatalOnly, boolean show) {
        IssueRegistry registry = EclipseLintClient.getRegistry();
        EclipseLintClient client = new EclipseLintClient(registry, resources, doc, fatalOnly);
        return EclipseLintRunner.startLint(client, resources, source, show);
    }

    public static Job startLint(EclipseLintClient client, List<? extends IResource> resources, IResource source, boolean show) {
        if (resources != null && !resources.isEmpty()) {
            if (!AdtPrefs.getPrefs().getSkipLibrariesFromLint()) {
                resources = EclipseLintRunner.addLibraries(resources);
            }
            EclipseLintRunner.cancelCurrentJobs(false);
            LintJob job = new LintJob(client, resources, source);
            job.schedule();
            if (show) {
                LintViewPart.show(resources);
            }
            return job;
        }
        return null;
    }

    public static boolean runLintOnExport(Shell shell, IProject project) {
        boolean fatal;
        if (AdtPrefs.getPrefs().isLintOnExport() && (fatal = EclipseLintRunner.runLint(Collections.singletonList(project), null, null, true))) {
            MessageDialog.openWarning((Shell)shell, (String)"Export Aborted", (String)"Export aborted because fatal lint errors were found. These are listed in the Lint View. Either fix these before running Export again, or turn off \"Run full error check when exporting app\" in the Android > Lint Error Checking preference page.");
            return false;
        }
        return true;
    }

    static void cancelCurrentJobs(boolean wait) {
        Job job;
        Job[] currentJobs;
        Job[] jobArray = currentJobs = LintJob.getCurrentJobs();
        int n = currentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            job = jobArray[n2];
            job.cancel();
            ++n2;
        }
        if (wait) {
            jobArray = currentJobs;
            n = currentJobs.length;
            n2 = 0;
            while (n2 < n) {
                job = jobArray[n2];
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                }
                ++n2;
            }
        }
    }

    private static List<? extends IResource> addLibraries(List<? extends IResource> resources) {
        if (resources != null && !resources.isEmpty()) {
            boolean haveProjects = false;
            for (IResource iResource : resources) {
                if (!(iResource instanceof IProject)) continue;
                haveProjects = true;
                break;
            }
            if (haveProjects) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                IdentityHashMap<IProject, IProject> allProjects = new IdentityHashMap<IProject, IProject>();
                ArrayList<IProject> projects = new ArrayList<IProject>();
                for (IResource iResource : resources) {
                    if (iResource instanceof IProject) {
                        IProject project = (IProject)iResource;
                        allProjects.put(project, project);
                        projects.add(project);
                        continue;
                    }
                    arrayList.add(iResource);
                }
                for (IProject iProject : projects) {
                    ProjectState state = Sdk.getProjectState(iProject);
                    if (state == null) continue;
                    for (IProject library : state.getFullLibraryProjects()) {
                        allProjects.put(library, library);
                    }
                }
                for (IProject iProject : allProjects.keySet()) {
                    arrayList.add(iProject);
                }
                return arrayList;
            }
        }
        return resources;
    }
}

