/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.utils.SdkUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

public final class LintJob
extends Job {
    private static final Object FAMILY_RUN_LINT = new Object();
    private final EclipseLintClient mClient;
    private final List<? extends IResource> mResources;
    private final IResource mSource;
    private final IssueRegistry mRegistry;
    private LintDriver mLint;
    private boolean mFatal;

    public LintJob(EclipseLintClient client, List<? extends IResource> resources, IResource source, IssueRegistry registry) {
        super("Running Android Lint");
        this.mClient = client;
        this.mResources = resources;
        this.mSource = source;
        this.mRegistry = registry;
    }

    public LintJob(EclipseLintClient client, List<? extends IResource> resources, IResource source) {
        this(client, resources, source, EclipseLintClient.getRegistry());
    }

    public boolean belongsTo(Object family) {
        return family == FAMILY_RUN_LINT;
    }

    protected void canceling() {
        super.canceling();
        if (this.mLint != null) {
            this.mLint.cancel();
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Looking for errors", -1);
            EnumSet<Scope> scope = null;
            ArrayList<File> files = new ArrayList<File>(this.mResources.size());
            for (IResource iResource : this.mResources) {
                File file = AdtUtils.getAbsolutePath(iResource).toFile();
                files.add(file);
                if (iResource instanceof IProject && this.mSource == null) {
                    scope = Scope.ALL;
                    continue;
                }
                String name = iResource.getName();
                if (SdkUtils.endsWithIgnoreCase((String)name, (String)".xml")) {
                    if (name.equals("AndroidManifest.xml")) {
                        scope = EnumSet.of(Scope.MANIFEST);
                        continue;
                    }
                    scope = Scope.RESOURCE_FILE_SCOPE;
                    continue;
                }
                if (name.endsWith(".java") && iResource instanceof IFile) {
                    if (scope != null) {
                        if (scope.contains(Scope.JAVA_FILE)) continue;
                        scope = EnumSet.copyOf(scope);
                        scope.add(Scope.JAVA_FILE);
                        continue;
                    }
                    scope = Scope.JAVA_FILE_SCOPE;
                    continue;
                }
                if (name.endsWith(".class") && iResource instanceof IFile) {
                    if (scope != null) {
                        if (scope.contains(Scope.CLASS_FILE)) continue;
                        scope = EnumSet.copyOf(scope);
                        scope.add(Scope.CLASS_FILE);
                        continue;
                    }
                    scope = Scope.CLASS_FILE_SCOPE;
                    continue;
                }
                Status iStatus = new Status(4, "org.eclipse.andmore", 4, "Only XML & Java files are supported for single file lint", null);
                return iStatus;
            }
            if (scope == null) {
                scope = Scope.ALL;
            }
            if (this.mSource == null) assert (!Scope.checkSingleFile((EnumSet)scope)) : scope + " with " + this.mResources;
            if (this.mSource != null) {
                IMarker[] iMarkerArray;
                IMarker[] iMarkerArray2 = iMarkerArray = EclipseLintClient.getMarkers(this.mSource);
                int n = iMarkerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray2[n2];
                    String id = marker.getAttribute("checkid", "");
                    Issue issue = this.mRegistry.getIssue(id);
                    if (issue != null && issue.getImplementation().isAdequate(scope)) {
                        marker.delete();
                    }
                    ++n2;
                }
                this.mClient.setSearchForSuperClasses(true);
            } else {
                EclipseLintClient.clearMarkers(this.mResources);
            }
            this.mLint = new LintDriver(this.mRegistry, (LintClient)this.mClient);
            this.mLint.analyze(new LintRequest((LintClient)this.mClient, files).setScope(scope));
            this.mFatal = this.mClient.hasFatalErrors();
            IStatus status = Status.OK_STATUS;
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.andmore", 4, "Failed", (Throwable)e);
            return status;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public boolean isFatal() {
        return this.mFatal;
    }

    public EclipseLintClient getLintClient() {
        return this.mClient;
    }

    static Job[] getCurrentJobs() {
        IJobManager jobManager = Job.getJobManager();
        return jobManager.find(FAMILY_RUN_LINT);
    }
}

