/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.detector.api.LintUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.lint.EclipseLintClient;
import org.eclipse.andmore.internal.lint.EclipseLintRunner;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunLintAction
implements IObjectActionDelegate,
IMenuCreator,
IWorkbenchWindowPulldownDelegate {
    private ISelection mSelection;
    private Menu mMenu;
    private static final int ACTION_RUN = 1;
    private static final int ACTION_CLEAR = 2;
    private static final int ACTION_TOGGLE_EXCLUDE = 3;

    public void selectionChanged(IAction action, ISelection selection) {
        this.mSelection = selection;
    }

    public void run(IAction action) {
        List<IProject> projects = RunLintAction.getProjects(this.mSelection, true);
        if (!projects.isEmpty()) {
            EclipseLintRunner.startLint(projects, null, null, false, true);
        }
    }

    static List<IProject> getProjects(ISelection selection, boolean warn) {
        List<IProject> projects = AdtUtils.getSelectedProjects(selection);
        if (projects.isEmpty() && warn) {
            MessageDialog.openWarning((Shell)AndmoreAndroidPlugin.getShell(), (String)"Lint", (String)"Could not run Lint: Select an Android project first.");
        }
        return projects;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void dispose() {
        if (this.mMenu != null) {
            this.mMenu.dispose();
        }
    }

    public void init(IWorkbenchWindow window) {
    }

    public Menu getMenu(Control parent) {
        IFile file;
        this.mMenu = new Menu(parent);
        IconFactory iconFactory = IconFactory.getInstance();
        ImageDescriptor allIcon = iconFactory.getImageDescriptor("lintrun");
        LintMenuAction allAction = new LintMenuAction("Check All Projects", allIcon, 1, null);
        this.addAction((IAction)allAction);
        this.addSeparator();
        IJavaProject[] projects = AdtUtils.getOpenAndroidProjects();
        JavaElementLabelProvider provider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            IProject p = project.getProject();
            ImageDescriptor icon = ImageDescriptor.createFromImage((Image)provider.getImage((Object)p));
            String label = String.format("Check %1$s", p.getName());
            LintMenuAction projectAction = new LintMenuAction(label, icon, 1, (IResource)p);
            this.addAction((IAction)projectAction);
            ++n2;
        }
        ITextEditor textEditor = AdtUtils.getActiveTextEditor();
        if (textEditor != null && (file = AdtUtils.getActiveFile()) != null && LintUtils.endsWith((String)file.getName(), (String)".xml")) {
            ImageDescriptor icon = ImageDescriptor.createFromImage((Image)provider.getImage((Object)file));
            LintMenuAction fileAction = new LintMenuAction("Check Current File", icon, 1, (IResource)file);
            this.addSeparator();
            this.addAction((IAction)fileAction);
        }
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor clear = images.getImageDescriptor("IMG_ELCL_REMOVEALL");
        LintMenuAction clearAction = new LintMenuAction("Clear Lint Warnings", clear, 2, null);
        this.addSeparator();
        this.addAction((IAction)clearAction);
        LintMenuAction excludeAction = new LintMenuAction("Skip Library Project Dependencies", allIcon, 3, null);
        this.addSeparator();
        this.addAction((IAction)excludeAction);
        excludeAction.setChecked(AdtPrefs.getPrefs().getSkipLibrariesFromLint());
        return this.mMenu;
    }

    private void addAction(IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(this.mMenu, -1);
    }

    private void addSeparator() {
        new Separator().fill(this.mMenu, -1);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private static class LintMenuAction
    extends Action {
        private final IResource mResource;
        private final int mAction;

        private LintMenuAction(String text, ImageDescriptor descriptor, int action, IResource resource) {
            super(text, action == 3 ? 2 : 1);
            if (descriptor != null) {
                this.setImageDescriptor(descriptor);
            }
            this.mAction = action;
            this.mResource = resource;
        }

        public void run() {
            if (this.mAction == 3) {
                AdtPrefs prefs;
                prefs.setSkipLibrariesFromLint(!(prefs = AdtPrefs.getPrefs()).getSkipLibrariesFromLint());
                return;
            }
            ArrayList<Object> resources = new ArrayList<Object>();
            if (this.mResource == null) {
                IJavaProject[] open;
                IJavaProject[] iJavaProjectArray = open = AdtUtils.getOpenAndroidProjects();
                int n = open.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaProject project = iJavaProjectArray[n2];
                    resources.add(project.getProject());
                    ++n2;
                }
            } else {
                resources.add(this.mResource);
            }
            EclipseLintRunner.cancelCurrentJobs(false);
            if (this.mAction == 2) {
                EclipseLintClient.clearMarkers(resources);
            } else {
                assert (this.mAction == 1);
                EclipseLintRunner.startLint(resources, null, null, false, true);
            }
        }
    }
}

