/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.lint;

import com.android.tools.lint.checks.TypographyDetector;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.lint.DocumentFix;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class TypographyFix
extends DocumentFix {
    private TypographyFix(String id, IMarker marker) {
        super(id, marker);
    }

    @Override
    public boolean needsFocus() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public boolean isBulkCapable() {
        return false;
    }

    @Override
    protected void apply(IDocument document, IStructuredModel model, Node node, int start, int end) {
        if (node instanceof Element) {
            Element element = (Element)node;
            NodeList childNodes = element.getChildNodes();
            int i = 0;
            int n = childNodes.getLength();
            while (i < n) {
                Node child = childNodes.item(i);
                if (child.getNodeType() == 3) {
                    IndexedRegion region = (IndexedRegion)child;
                    String message = this.mMarker.getAttribute("message", "");
                    List edits = TypographyDetector.getEdits((String)this.mId, (String)message, (Node)child);
                    for (TypographyDetector.ReplaceEdit edit : edits) {
                        try {
                            document.replace(edit.offset + region.getStartOffset(), edit.length, edit.replaceWith);
                        }
                        catch (BadLocationException e) {
                            AndmoreAndroidPlugin.log(e, null, new Object[0]);
                        }
                    }
                }
                ++i;
            }
        }
    }

    @Override
    public String getDisplayString() {
        return "Replace with suggested characters";
    }

    @Override
    public Image getImage() {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        return sharedImages.getImage("IMG_OBJ_ELEMENTS");
    }
}

