/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.preferences;

import com.android.sdklib.IAndroidTarget;
import com.android.sdkstats.DdmsPreferenceStore;
import com.android.sdkuilib.internal.widgets.SdkTargetSelector;
import java.io.File;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.preferences.Messages;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AndroidPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private SdkDirectoryFieldEditor mDirectoryField;

    public AndroidPreferencePage() {
        super(1);
        this.setPreferenceStore(AndmoreAndroidPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.AndroidPreferencePage_Title);
    }

    public void createFieldEditors() {
        this.mDirectoryField = new SdkDirectoryFieldEditor("org.eclipse.andmore.sdk", Messages.AndroidPreferencePage_SDK_Location_, this.getFieldEditorParent());
        this.addField((FieldEditor)this.mDirectoryField);
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
        if (this.mDirectoryField != null) {
            this.mDirectoryField.dispose();
            this.mDirectoryField = null;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private static class SdkDirectoryFieldEditor
    extends DirectoryFieldEditor {
        private SdkTargetSelector mTargetSelector;
        private TargetChangedListener mTargetChangeListener;

        public SdkDirectoryFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setEmptyStringAllowed(false);
        }

        protected boolean doCheckState() {
            String fileName = this.getTextControl().getText();
            if ((fileName = fileName.trim()).indexOf(44) >= 0 || fileName.indexOf(59) >= 0) {
                this.setErrorMessage(Messages.AndroidPreferencePage_ERROR_Reserved_Char);
                return false;
            }
            File file = new File(fileName);
            if (!file.isDirectory()) {
                this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
                return false;
            }
            boolean ok = AndmoreAndroidPlugin.getDefault().checkSdkLocationAndId(fileName, new AndmoreAndroidPlugin.CheckSdkErrorHandler(){

                @Override
                public boolean handleError(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution solution, String message) {
                    SdkDirectoryFieldEditor.this.setErrorMessage(message.replaceAll("\n", " "));
                    return false;
                }

                @Override
                public boolean handleWarning(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution solution, String message) {
                    SdkDirectoryFieldEditor.this.showMessage(message.replaceAll("\n", " "));
                    return true;
                }
            });
            if (ok) {
                this.clearMessage();
            }
            return ok;
        }

        protected void doStore() {
            super.doStore();
            String path = AdtPrefs.getPrefs().getOsSdkFolder();
            if (path != null && path.length() > 0 && new File(path).exists()) {
                DdmsPreferenceStore ddmsStore = new DdmsPreferenceStore();
                ddmsStore.setLastSdkPath(path);
            }
        }

        public Text getTextControl(Composite parent) {
            this.setValidateStrategy(0);
            return super.getTextControl(parent);
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            super.doFillIntoGrid(parent, numColumns);
            Label l = new Label(parent, 0);
            l.setText("Note: The list of SDK Targets below is only reloaded once you hit 'Apply' or 'OK'.");
            GridData gd = new GridData(768);
            gd.horizontalSpan = numColumns;
            l.setLayoutData((Object)gd);
            try {
                Sdk sdk = Sdk.getCurrent();
                IAndroidTarget[] targets = sdk != null ? sdk.getTargets() : null;
                this.mTargetSelector = new SdkTargetSelector(parent, targets, false);
                gd = (GridData)this.mTargetSelector.getLayoutData();
                gd.horizontalSpan = numColumns;
                if (this.mTargetChangeListener == null) {
                    this.mTargetChangeListener = new TargetChangedListener();
                    AndmoreAndroidPlugin.getDefault().addTargetListener(this.mTargetChangeListener);
                    AndmoreAndroidPlugin.getDefault().refreshSdk();
                }
            }
            catch (Exception e) {
                AndmoreAndroidPlugin.log(e, "SdkTargetSelector failed", new Object[0]);
            }
        }

        public void dispose() {
            super.dispose();
            if (this.mTargetChangeListener != null) {
                AndmoreAndroidPlugin.getDefault().removeTargetListener(this.mTargetChangeListener);
                this.mTargetChangeListener = null;
            }
        }

        private class TargetChangedListener
        implements Sdk.ITargetChangeListener {
            private TargetChangedListener() {
            }

            @Override
            public void onSdkLoaded() {
                if (SdkDirectoryFieldEditor.this.mTargetSelector != null) {
                    Sdk sdk = Sdk.getCurrent();
                    IAndroidTarget[] targets = sdk != null ? sdk.getTargets() : null;
                    SdkDirectoryFieldEditor.this.mTargetSelector.setTargets(targets);
                }
            }

            @Override
            public void onProjectTargetChange(IProject changedProject) {
            }

            @Override
            public void onTargetLoaded(IAndroidTarget target) {
            }
        }
    }
}

