/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.refactorings.core;

import com.android.ide.common.xml.ManifestData;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.gle2.DomUtilities;
import org.eclipse.andmore.internal.editors.manifest.ManifestInfo;
import org.eclipse.andmore.internal.project.AndroidManifestHelper;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.refactorings.core.RefactoringUtil;
import org.eclipse.andmore.internal.refactorings.core.RenameResourceParticipant;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameCompilationUnitProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameTypeProcessor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidTypeRenameParticipant
extends RenameParticipant {
    private IProject mProject;
    private IFile mManifestFile;
    private String mOldFqcn;
    private String mNewFqcn;
    private String mOldSimpleName;
    private String mNewSimpleName;
    private String mOldDottedName;
    private String mNewDottedName;
    private boolean mIsCustomView;
    private static boolean sIgnore;

    public String getName() {
        return "Android Type Rename";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    protected boolean initialize(Object element) {
        if (sIgnore) {
            return false;
        }
        if (element instanceof IType) {
            IType type = (IType)element;
            IJavaProject javaProject = (IJavaProject)type.getAncestor(2);
            this.mProject = javaProject.getProject();
            IResource manifestResource = this.mProject.findMember("/AndroidManifest.xml");
            if (manifestResource == null || !manifestResource.exists() || !(manifestResource instanceof IFile)) {
                RefactoringUtil.logInfo(String.format("Invalid or missing file %1$s in project %2$s", "AndroidManifest.xml", this.mProject.getName()));
                return false;
            }
            try {
                ITypeHierarchy hierarchy;
                IType classView = javaProject.findType("android.view.View");
                if (classView != null && (hierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor())).contains(classView)) {
                    this.mIsCustomView = true;
                }
            }
            catch (CoreException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
            this.mManifestFile = (IFile)manifestResource;
            ManifestData manifestData = AndroidManifestHelper.parseForData(this.mManifestFile);
            if (manifestData == null) {
                return false;
            }
            this.mOldSimpleName = type.getElementName();
            this.mOldDottedName = String.valueOf('.') + this.mOldSimpleName;
            this.mOldFqcn = type.getFullyQualifiedName();
            String packageName = type.getPackageFragment().getElementName();
            this.mNewSimpleName = this.getArguments().getNewName();
            this.mNewDottedName = String.valueOf('.') + this.mNewSimpleName;
            this.mNewFqcn = packageName != null ? String.valueOf(packageName) + this.mNewDottedName : this.mNewSimpleName;
            if (this.mOldFqcn == null || this.mNewFqcn == null) {
                return false;
            }
            if (!RefactoringUtil.isRefactorAppPackage() && this.mNewFqcn.indexOf(46) == -1) {
                this.mNewFqcn = String.valueOf(packageName) + this.mNewDottedName;
            }
            return true;
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RenameTypeProcessor rtp;
        if (pm.isCanceled()) {
            return null;
        }
        if (!this.getArguments().getUpdateReferences()) {
            return null;
        }
        RefactoringProcessor p = this.getProcessor();
        if (p instanceof RenameCompilationUnitProcessor && (rtp = ((RenameCompilationUnitProcessor)p).getRenameTypeProcessor()) != null) {
            String pattern = rtp.getFilePatterns();
            boolean updQualf = rtp.getUpdateQualifiedNames();
            if (updQualf && pattern != null && pattern.contains("xml")) {
                return null;
            }
        }
        CompositeChange result = new CompositeChange(this.getName());
        result.markAsSynthetic();
        this.addManifestFileChanges(this.mManifestFile, result);
        this.addLayoutFileChanges(this.mProject, result);
        this.addJavaChanges(this.mProject, result, pm);
        ProjectState projectState = Sdk.getProjectState(this.mProject);
        if (projectState != null) {
            Collection<ProjectState> parentProjects = projectState.getFullParentProjects();
            for (ProjectState parentProject : parentProjects) {
                IProject project = parentProject.getProject();
                IResource manifestResource = project.findMember("/AndroidManifest.xml");
                if (manifestResource != null && manifestResource.exists() && manifestResource instanceof IFile) {
                    this.addManifestFileChanges((IFile)manifestResource, result);
                }
                this.addLayoutFileChanges(project, result);
                this.addJavaChanges(project, result, pm);
            }
        }
        RenameResourceParticipant.disableRClassChanges((Change)result);
        return result.getChildren().length == 0 ? null : result;
    }

    private void addJavaChanges(IProject project, CompositeChange result, IProgressMonitor monitor) {
        block12: {
            if (!this.mIsCustomView) {
                return;
            }
            try {
                IJavaProject javaProject = BaseProjectHelper.getJavaProject(project);
                ManifestInfo info = ManifestInfo.get(project);
                info.getPackage();
                String rFqcn = String.valueOf(info.getPackage()) + '.' + "R";
                IType styleable = javaProject.findType(String.valueOf(rFqcn) + '.' + ResourceType.STYLEABLE.getName());
                if (styleable == null) break block12;
                IField[] fields = styleable.getFields();
                CompositeChange fieldChanges = null;
                IField[] iFieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        IField field = iFieldArray[n2];
                        String name = field.getElementName();
                        if (name.equals(this.mOldSimpleName) || name.startsWith(this.mOldSimpleName) && name.length() > this.mOldSimpleName.length() && name.charAt(this.mOldSimpleName.length()) == '_') {
                            String newName = name.equals(this.mOldSimpleName) ? this.mNewSimpleName : String.valueOf(this.mNewSimpleName) + name.substring(this.mOldSimpleName.length());
                            RenameRefactoring refactoring = RenameResourceParticipant.createFieldRefactoring(field, newName, true);
                            try {
                                try {
                                    Change fieldChange;
                                    sIgnore = true;
                                    RefactoringStatus status = refactoring.checkAllConditions(monitor);
                                    if (status != null && !status.hasError() && (fieldChange = refactoring.createChange(monitor)) != null) {
                                        if (fieldChanges == null) {
                                            fieldChanges = new CompositeChange("Update custom view styleable fields");
                                            fieldChanges.setEnabled(false);
                                        }
                                        fieldChange.setEnabled(false);
                                        fieldChanges.add(fieldChange);
                                    }
                                }
                                catch (CoreException e) {
                                    AndmoreAndroidPlugin.log(e, null, new Object[0]);
                                    sIgnore = false;
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                sIgnore = false;
                                throw throwable;
                            }
                            sIgnore = false;
                        }
                    }
                    ++n2;
                }
                if (fieldChanges != null) {
                    result.add(fieldChanges);
                }
            }
            catch (CoreException e) {
                AndmoreAndroidPlugin.log(e, null, new Object[0]);
            }
        }
    }

    private void addManifestFileChanges(IFile manifestFile, CompositeChange result) {
        this.addXmlFileChanges(manifestFile, result, null);
    }

    private void addLayoutFileChanges(IProject project, CompositeChange result) {
        try {
            IResource[] folders;
            IFolder resFolder = project.getFolder("res");
            IResource[] iResourceArray = folders = resFolder.members();
            int n = folders.length;
            int n2 = 0;
            while (n2 < n) {
                IResource folder = iResourceArray[n2];
                String folderName = folder.getName();
                ResourceFolderType folderType = ResourceFolderType.getFolderType((String)folderName);
                if ((folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.VALUES) && folder instanceof IFolder) {
                    IResource[] files = ((IFolder)folder).members();
                    int i = 0;
                    while (i < files.length) {
                        IResource member = files[i];
                        if (member instanceof IFile && member.exists()) {
                            IFile file = (IFile)member;
                            String fileName = member.getName();
                            if (SdkUtils.endsWith((CharSequence)fileName, (CharSequence)".xml")) {
                                this.addXmlFileChanges(file, result, folderType);
                            }
                        }
                        ++i;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            RefactoringUtil.log(e);
        }
    }

    private boolean addXmlFileChanges(IFile file, CompositeChange changes, ResourceFolderType folderType) {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getExistingModelForRead(file);
            if (model == null) {
                model = modelManager.getModelForRead(file);
            }
            if (model != null) {
                IStructuredDocument document = model.getStructuredDocument();
                if (model instanceof IDOMModel) {
                    IDOMModel domModel = (IDOMModel)model;
                    Element root = domModel.getDocument().getDocumentElement();
                    if (root != null) {
                        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
                        if (folderType == null) {
                            assert (file.getName().equals("AndroidManifest.xml"));
                            this.addManifestReplacements(edits, root, document);
                        } else if (folderType == ResourceFolderType.VALUES) {
                            this.addValueReplacements(edits, root, document);
                        } else {
                            assert (folderType == ResourceFolderType.LAYOUT);
                            this.addLayoutReplacements(edits, root, document);
                        }
                        if (!edits.isEmpty()) {
                            MultiTextEdit rootEdit = new MultiTextEdit();
                            rootEdit.addChildren(edits.toArray(new TextEdit[edits.size()]));
                            TextFileChange change = new TextFileChange(file.getName(), file);
                            change.setTextType("xml");
                            change.setEdit((TextEdit)rootEdit);
                            changes.add((Change)change);
                        }
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        catch (IOException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
        catch (CoreException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return false;
    }

    private void addLayoutReplacements(List<TextEdit> edits, Element element, IStructuredDocument document) {
        int end;
        int start;
        String tag = element.getTagName();
        if (tag.equals(this.mOldFqcn)) {
            int start2 = RefactoringUtil.getTagNameRangeStart(element, (IDocument)document);
            if (start2 != -1) {
                int end2 = start2 + this.mOldFqcn.length();
                edits.add((TextEdit)new ReplaceEdit(start2, end2 - start2, this.mNewFqcn));
            }
        } else if (tag.equals("view")) {
            Attr classNode = element.getAttributeNode("class");
            if (classNode != null && classNode.getValue().equals(this.mOldFqcn) && (start = RefactoringUtil.getAttributeValueRangeStart(classNode, (IDocument)document)) != -1) {
                end = start + this.mOldFqcn.length();
                edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
            }
        } else if (tag.equals("fragment")) {
            Attr classNode = element.getAttributeNode("class");
            if (classNode == null) {
                classNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            }
            if (classNode != null && classNode.getValue().equals(this.mOldFqcn) && (start = RefactoringUtil.getAttributeValueRangeStart(classNode, (IDocument)document)) != -1) {
                end = start + this.mOldFqcn.length();
                edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
            }
        } else if (element.hasAttributeNS("http://schemas.android.com/tools", "context")) {
            Attr classNode = element.getAttributeNodeNS("http://schemas.android.com/tools", "context");
            if (classNode != null && classNode.getValue().equals(this.mOldFqcn)) {
                start = RefactoringUtil.getAttributeValueRangeStart(classNode, (IDocument)document);
                if (start != -1) {
                    end = start + this.mOldFqcn.length();
                    edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
                }
            } else if (classNode != null && classNode.getValue().equals(this.mOldDottedName) && (start = RefactoringUtil.getAttributeValueRangeStart(classNode, (IDocument)document)) != -1) {
                end = start + this.mOldDottedName.length();
                edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewDottedName));
            }
        }
        NodeList children = element.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.addLayoutReplacements(edits, (Element)child, document);
            }
            ++i;
        }
    }

    private void addValueReplacements(List<TextEdit> edits, Element root, IStructuredDocument document) {
        String declareStyleable = ResourceType.DECLARE_STYLEABLE.getName();
        List<Element> topLevel = DomUtilities.getChildren(root);
        for (Element element : topLevel) {
            int start;
            Attr nameNode;
            String tag = element.getTagName();
            if (!declareStyleable.equals(tag) || (nameNode = element.getAttributeNode("name")) == null || !this.mOldSimpleName.equals(nameNode.getValue()) || (start = RefactoringUtil.getAttributeValueRangeStart(nameNode, (IDocument)document)) == -1) continue;
            int end = start + this.mOldSimpleName.length();
            edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewSimpleName));
        }
    }

    private void addManifestReplacements(List<TextEdit> edits, Element element, IStructuredDocument document) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        int n = attributes.getLength();
        while (i < n) {
            Attr attr = (Attr)attributes.item(i);
            if (RefactoringUtil.isManifestClassAttribute(attr)) {
                int end;
                int start;
                String value = attr.getValue();
                if (value.equals(this.mOldFqcn)) {
                    start = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document);
                    if (start != -1) {
                        end = start + this.mOldFqcn.length();
                        edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewFqcn));
                    }
                } else if (value.equals(this.mOldDottedName) && (start = RefactoringUtil.getAttributeValueRangeStart(attr, (IDocument)document)) != -1) {
                    end = start + this.mOldDottedName.length();
                    edits.add((TextEdit)new ReplaceEdit(start, end - start, this.mNewDottedName));
                }
            }
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        int n2 = children.getLength();
        while (i2 < n2) {
            Node child = children.item(i2);
            if (child.getNodeType() == 1) {
                this.addManifestReplacements(edits, (Element)child, document);
            }
            ++i2;
        }
    }
}

