/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.sdk;

import com.android.ide.common.rendering.LayoutLibrary;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.sdk.LoadStatus;
import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.common.resources.platform.AttributeInfo;
import org.eclipse.andmore.internal.editors.animator.AnimDescriptors;
import org.eclipse.andmore.internal.editors.animator.AnimatorDescriptors;
import org.eclipse.andmore.internal.editors.color.ColorDescriptors;
import org.eclipse.andmore.internal.editors.descriptors.IDescriptorProvider;
import org.eclipse.andmore.internal.editors.drawable.DrawableDescriptors;
import org.eclipse.andmore.internal.editors.layout.descriptors.LayoutDescriptors;
import org.eclipse.andmore.internal.editors.manifest.descriptors.AndroidManifestDescriptors;
import org.eclipse.andmore.internal.editors.menu.descriptors.MenuDescriptors;
import org.eclipse.andmore.internal.editors.otherxml.descriptors.OtherXmlDescriptors;
import org.eclipse.andmore.internal.editors.values.descriptors.ValuesDescriptors;

public class AndroidTargetData {
    public static final int DESCRIPTOR_MANIFEST = 1;
    public static final int DESCRIPTOR_LAYOUT = 2;
    public static final int DESCRIPTOR_MENU = 3;
    public static final int DESCRIPTOR_OTHER_XML = 4;
    public static final int DESCRIPTOR_RESOURCES = 5;
    public static final int DESCRIPTOR_SEARCHABLE = 6;
    public static final int DESCRIPTOR_PREFERENCES = 7;
    public static final int DESCRIPTOR_APPWIDGET_PROVIDER = 8;
    public static final int DESCRIPTOR_DRAWABLE = 9;
    public static final int DESCRIPTOR_ANIMATOR = 10;
    public static final int DESCRIPTOR_ANIM = 11;
    public static final int DESCRIPTOR_COLOR = 12;
    private final IAndroidTarget mTarget;
    private Hashtable<String, String[]> mAttributeValues = new Hashtable();
    private AndroidManifestDescriptors mManifestDescriptors;
    private DrawableDescriptors mDrawableDescriptors;
    private AnimatorDescriptors mAnimatorDescriptors;
    private AnimDescriptors mAnimDescriptors;
    private ColorDescriptors mColorDescriptors;
    private LayoutDescriptors mLayoutDescriptors;
    private MenuDescriptors mMenuDescriptors;
    private OtherXmlDescriptors mOtherXmlDescriptors;
    private Map<String, Map<String, Integer>> mEnumValueMap;
    private ResourceRepository mFrameworkResources;
    private LayoutLibrary mLayoutLibrary;
    private Map<String, AttributeInfo> mAttributeMap;
    private boolean mLayoutBridgeInit = false;

    AndroidTargetData(IAndroidTarget androidTarget) {
        this.mTarget = androidTarget;
    }

    public void setAttributeMap(Map<String, AttributeInfo> attributeMap) {
        this.mAttributeMap = attributeMap;
    }

    public Map<String, AttributeInfo> getAttributeMap() {
        return this.mAttributeMap;
    }

    void setExtraData(AndroidManifestDescriptors manifestDescriptors, LayoutDescriptors layoutDescriptors, MenuDescriptors menuDescriptors, OtherXmlDescriptors otherXmlDescriptors, DrawableDescriptors drawableDescriptors, AnimatorDescriptors animatorDescriptors, AnimDescriptors animDescriptors, ColorDescriptors colorDescriptors, Map<String, Map<String, Integer>> enumValueMap, String[] permissionValues, String[] activityIntentActionValues, String[] broadcastIntentActionValues, String[] serviceIntentActionValues, String[] intentCategoryValues, String[] platformLibraries, List<IAndroidTarget.OptionalLibrary> optionalLibraries, ResourceRepository frameworkResources, LayoutLibrary layoutLibrary) {
        this.mManifestDescriptors = manifestDescriptors;
        this.mDrawableDescriptors = drawableDescriptors;
        this.mAnimatorDescriptors = animatorDescriptors;
        this.mAnimDescriptors = animDescriptors;
        this.mColorDescriptors = colorDescriptors;
        this.mLayoutDescriptors = layoutDescriptors;
        this.mMenuDescriptors = menuDescriptors;
        this.mOtherXmlDescriptors = otherXmlDescriptors;
        this.mEnumValueMap = enumValueMap;
        this.mFrameworkResources = frameworkResources;
        this.mLayoutLibrary = layoutLibrary;
        this.setPermissions(permissionValues);
        this.setIntentFilterActionsAndCategories(activityIntentActionValues, broadcastIntentActionValues, serviceIntentActionValues, intentCategoryValues);
        this.setOptionalLibraries(platformLibraries, optionalLibraries);
    }

    public IDescriptorProvider getDescriptorProvider(int descriptorId) {
        switch (descriptorId) {
            case 1: {
                return this.mManifestDescriptors;
            }
            case 2: {
                return this.mLayoutDescriptors;
            }
            case 3: {
                return this.mMenuDescriptors;
            }
            case 4: {
                return this.mOtherXmlDescriptors;
            }
            case 5: {
                return ValuesDescriptors.getInstance();
            }
            case 7: {
                return this.mOtherXmlDescriptors.getPreferencesProvider();
            }
            case 8: {
                return this.mOtherXmlDescriptors.getAppWidgetProvider();
            }
            case 6: {
                return this.mOtherXmlDescriptors.getSearchableProvider();
            }
            case 9: {
                return this.mDrawableDescriptors;
            }
            case 10: {
                return this.mAnimatorDescriptors;
            }
            case 11: {
                return this.mAnimDescriptors;
            }
            case 12: {
                return this.mColorDescriptors;
            }
        }
        throw new IllegalArgumentException();
    }

    public AndroidManifestDescriptors getManifestDescriptors() {
        return this.mManifestDescriptors;
    }

    public DrawableDescriptors getDrawableDescriptors() {
        return this.mDrawableDescriptors;
    }

    public AnimDescriptors getAnimDescriptors() {
        return this.mAnimDescriptors;
    }

    public ColorDescriptors getColorDescriptors() {
        return this.mColorDescriptors;
    }

    public AnimatorDescriptors getAnimatorDescriptors() {
        return this.mAnimatorDescriptors;
    }

    public LayoutDescriptors getLayoutDescriptors() {
        return this.mLayoutDescriptors;
    }

    public MenuDescriptors getMenuDescriptors() {
        return this.mMenuDescriptors;
    }

    public OtherXmlDescriptors getXmlDescriptors() {
        return this.mOtherXmlDescriptors;
    }

    public String[] getAttributeValues(String elementName, String attributeName) {
        String key = String.format("(%1$s,%2$s)", elementName, attributeName);
        return this.mAttributeValues.get(key);
    }

    public String[] getAttributeValues(String elementName, String attributeName, String greatGrandParentElementName) {
        String key;
        String[] values;
        if (greatGrandParentElementName != null && (values = this.mAttributeValues.get(key = String.format("(%1$s,%2$s,%3$s)", greatGrandParentElementName, elementName, attributeName))) != null) {
            return values;
        }
        return this.getAttributeValues(elementName, attributeName);
    }

    public Map<String, Map<String, Integer>> getEnumValueMap() {
        return this.mEnumValueMap;
    }

    public ResourceRepository getFrameworkResources() {
        return this.mFrameworkResources;
    }

    public synchronized LayoutLibrary getLayoutLibrary() {
        if (!this.mLayoutBridgeInit && this.mLayoutLibrary.getStatus() == LoadStatus.LOADED) {
            boolean ok = this.mLayoutLibrary.init(this.mTarget.getProperties(), new File(this.mTarget.getPath(12)), this.getEnumValueMap(), new LayoutLog(){

                public void error(String tag, String message, Throwable throwable, Object data) {
                    AndmoreAndroidPlugin.log(throwable, message, new Object[0]);
                }

                public void error(String tag, String message, Object data) {
                    AndmoreAndroidPlugin.log(4, message, new Object[0]);
                }

                public void warning(String tag, String message, Object data) {
                    AndmoreAndroidPlugin.log(2, message, new Object[0]);
                }
            });
            if (!ok) {
                AndmoreAndroidPlugin.log(4, "LayoutLibrary initialization failed", new Object[0]);
            }
            this.mLayoutBridgeInit = true;
        }
        return this.mLayoutLibrary;
    }

    private void setPermissions(String[] permissionValues) {
        this.setValues("(uses-permission,android:name)", permissionValues);
        this.setValues("(application,android:permission)", permissionValues);
        this.setValues("(activity,android:permission)", permissionValues);
        this.setValues("(receiver,android:permission)", permissionValues);
        this.setValues("(service,android:permission)", permissionValues);
        this.setValues("(provider,android:permission)", permissionValues);
    }

    private void setIntentFilterActionsAndCategories(String[] activityIntentActions, String[] broadcastIntentActions, String[] serviceIntentActions, String[] intentCategoryValues) {
        this.setValues("(activity,action,android:name)", activityIntentActions);
        this.setValues("(receiver,action,android:name)", broadcastIntentActions);
        this.setValues("(service,action,android:name)", serviceIntentActions);
        this.setValues("(category,android:name)", intentCategoryValues);
    }

    private void setOptionalLibraries(String[] platformLibraries, List<IAndroidTarget.OptionalLibrary> optionalLibraries) {
        ArrayList<String> libs = new ArrayList<String>();
        if (platformLibraries != null) {
            String[] stringArray = platformLibraries;
            int n = platformLibraries.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                libs.add(name);
                ++n2;
            }
        }
        if (optionalLibraries != null) {
            for (IAndroidTarget.OptionalLibrary optionalLibrary : optionalLibraries) {
                libs.add(optionalLibrary.getName());
            }
        }
        this.setValues("(uses-library,android:name)", libs.toArray(new String[libs.size()]));
    }

    private void setValues(String name, String[] values) {
        this.mAttributeValues.remove(name);
        this.mAttributeValues.put(name, values);
    }

    public void dispose() {
        if (this.mLayoutLibrary != null) {
            this.mLayoutLibrary.dispose();
        }
    }
}

