/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.sdk;

import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.internal.project.ProjectPropertiesWorkingCopy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class ProjectState {
    public static final String NO_VERSION_VECTORS_PROPERTY = "no-version-vectors.enabled";
    private final IProject mProject;
    private final ProjectProperties mProperties;
    private IAndroidTarget mTarget;
    private BuildToolInfo mBuildToolInfo;
    private final ArrayList<LibraryState> mLibraries = new ArrayList();
    private List<IProject> mLibraryProjects = Collections.emptyList();
    private final ArrayList<ProjectState> mParentProjects = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProjectState(IProject project, ProjectProperties properties) {
        if (project == null || properties == null) {
            throw new NullPointerException();
        }
        this.mProject = project;
        this.mProperties = properties;
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            String propName;
            String rootPath;
            int index = 1;
            while ((rootPath = this.mProperties.getProperty(propName = "android.library.reference." + Integer.toString(index++))) != null) {
                this.mLibraries.add(new LibraryState(this.convertPath(rootPath)));
            }
        }
    }

    public IProject getProject() {
        return this.mProject;
    }

    public ProjectProperties getProperties() {
        return this.mProperties;
    }

    public String getProperty(String name) {
        if (this.mProperties != null) {
            return this.mProperties.getProperty(name);
        }
        return null;
    }

    public void setTarget(IAndroidTarget target) {
        this.mTarget = target;
    }

    public String getTargetHashString() {
        if (this.mTarget != null) {
            return this.mTarget.hashString();
        }
        return this.mProperties.getProperty("target");
    }

    public IAndroidTarget getTarget() {
        return this.mTarget;
    }

    public void setBuildToolInfo(BuildToolInfo buildToolInfo) {
        this.mBuildToolInfo = buildToolInfo;
    }

    public BuildToolInfo getBuildToolInfo() {
        return this.mBuildToolInfo;
    }

    public String getBuildToolInfoVersion() {
        return this.mProperties.getProperty("sdk.buildtools");
    }

    public boolean getRenderScriptSupportMode() {
        String supportModeValue = this.mProperties.getProperty("renderscript.support.mode");
        if (supportModeValue != null) {
            return Boolean.parseBoolean(supportModeValue);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryDifference reloadProperties() {
        this.mTarget = null;
        this.mProperties.reload();
        LibraryDifference diff = new LibraryDifference();
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            String propName;
            String rootPath;
            ArrayList<LibraryState> oldLibraries = new ArrayList<LibraryState>(this.mLibraries);
            this.mLibraries.clear();
            int index = 1;
            while ((rootPath = this.mProperties.getProperty(propName = "android.library.reference." + Integer.toString(index++))) != null) {
                String convertedPath = this.convertPath(rootPath);
                boolean found = false;
                int i = 0;
                while (i < oldLibraries.size()) {
                    LibraryState libState = (LibraryState)oldLibraries.get(i);
                    if (libState.equals(convertedPath)) {
                        found = true;
                        this.mLibraries.add(libState);
                        oldLibraries.remove(i);
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                diff.added = true;
                this.mLibraries.add(new LibraryState(convertedPath));
            }
            diff.removed = oldLibraries.size() > 0;
            this.updateFullLibraryList();
        }
        return diff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LibraryState> getLibraries() {
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            return Collections.unmodifiableList(this.mLibraries);
        }
    }

    public List<IProject> getFullLibraryProjects() {
        return this.mLibraryProjects;
    }

    public boolean isLibrary() {
        String value = this.mProperties.getProperty("android.library");
        return value != null && Boolean.valueOf(value) != false;
    }

    public boolean isNoVersionVectors() {
        return Boolean.parseBoolean(this.mProperties.getProperty(NO_VERSION_VECTORS_PROPERTY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasLibraries() {
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            return this.mLibraries.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isMissingLibraries() {
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            LibraryState state;
            Iterator<LibraryState> iterator = this.mLibraries.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((state = iterator.next()).getProjectState() != null);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryState getLibrary(IProject library) {
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            for (LibraryState state : this.mLibraries) {
                ProjectState ps = state.getProjectState();
                if (ps == null || !ps.getProject().equals((Object)library)) continue;
                return state;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryState getLibrary(String name) {
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            for (LibraryState state : this.mLibraries) {
                ProjectState ps = state.getProjectState();
                if (ps == null || !ps.getProject().getName().equals(name)) continue;
                return state;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryState needs(ProjectState libraryProject) {
        File projectFile = this.mProject.getLocation().toFile();
        File libraryFile = libraryProject.getProject().getLocation().toFile();
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            for (LibraryState state : this.mLibraries) {
                if (state.getProjectState() != null) continue;
                File library = new File(projectFile, state.getRelativePath());
                try {
                    File absPath = library.getCanonicalFile();
                    if (!absPath.equals(libraryFile)) continue;
                    state.setProject(libraryProject);
                    return state;
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dependsOn(ProjectState library) {
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            LibraryState state;
            Iterator<LibraryState> iterator = this.mLibraries.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while ((state = iterator.next()) == null || state.getProjectState() == null || !library.getProject().equals((Object)state.getProjectState().getProject()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryState updateLibrary(String oldRelativePath, String newRelativePath, ProjectState newLibraryState) {
        File projectFile = this.mProject.getLocation().toFile();
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            for (LibraryState state : this.mLibraries) {
                if (state.getProjectState() != null) continue;
                try {
                    File library1 = new File(projectFile, oldRelativePath);
                    File library2 = new File(projectFile, state.getRelativePath());
                    if (!library1.getCanonicalPath().equals(library2.getCanonicalPath())) continue;
                    String oldProperty = state.getRelativePath();
                    state.setRelativePath(newRelativePath);
                    state.setProject(newLibraryState);
                    IStatus status = this.replaceLibraryProperty(oldProperty, newRelativePath);
                    if (status != null) {
                        status.getSeverity();
                    }
                    return state;
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void addParentProject(ProjectState parentState) {
        this.mParentProjects.add(parentState);
    }

    private void removeParentProject(ProjectState parentState) {
        this.mParentProjects.remove(parentState);
    }

    public List<ProjectState> getParentProjects() {
        return Collections.unmodifiableList(this.mParentProjects);
    }

    public Collection<ProjectState> getFullParentProjects() {
        HashSet<ProjectState> result = new HashSet<ProjectState>();
        ProjectState.addParentProjects(result, this);
        return result;
    }

    private static void addParentProjects(Set<ProjectState> parents, ProjectState state) {
        for (ProjectState s : state.mParentProjects) {
            if (parents.contains(s)) continue;
            parents.add(s);
            ProjectState.addParentProjects(parents, s);
        }
    }

    private IStatus replaceLibraryProperty(String oldValue, String newValue) {
        String propName;
        String rootPath;
        int index = 1;
        while ((rootPath = this.mProperties.getProperty(propName = "android.library.reference." + Integer.toString(index++))) != null) {
            if (!rootPath.equals(oldValue)) continue;
            ProjectPropertiesWorkingCopy workingCopy = this.mProperties.makeWorkingCopy();
            workingCopy.setProperty(propName, newValue);
            try {
                workingCopy.save();
                this.mProperties.reload();
            }
            catch (Exception e) {
                return new Status(4, "org.eclipse.andmore", String.format("Failed to save %1$s for project %2$s", this.mProperties.getType().getFilename(), this.mProject.getName()), (Throwable)e);
            }
            return Status.OK_STATUS;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFullLibraryList() {
        ArrayList<IProject> list = new ArrayList<IProject>();
        ArrayList<LibraryState> arrayList = this.mLibraries;
        synchronized (arrayList) {
            this.buildFullLibraryDependencies(this.mLibraries, list);
        }
        this.mLibraryProjects = Collections.unmodifiableList(list);
    }

    private void buildFullLibraryDependencies(List<LibraryState> inLibraries, ArrayList<IProject> outLibraries) {
        int i = inLibraries.size() - 1;
        while (i >= 0) {
            LibraryState library = inLibraries.get(i);
            ProjectState libProjectState = library.getProjectState();
            if (libProjectState != null) {
                List<LibraryState> dependencies = libProjectState.getLibraries();
                this.buildFullLibraryDependencies(dependencies, outLibraries);
                if (!outLibraries.contains(libProjectState.getProject())) {
                    outLibraries.add(0, libProjectState.getProject());
                }
            }
            --i;
        }
    }

    private String convertPath(String path) {
        return path.replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    private String normalizePath(String path) {
        if ((path = this.convertPath(path)).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProjectState) {
            return this.mProject.equals((Object)((ProjectState)obj).mProject);
        }
        if (obj instanceof IProject) {
            return this.mProject.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.mProject.hashCode();
    }

    public String toString() {
        return this.mProject.getName();
    }

    public static class LibraryDifference {
        public boolean removed = false;
        public boolean added = false;

        public boolean hasDiff() {
            return this.removed || this.added;
        }
    }

    public final class LibraryState {
        private String mRelativePath;
        private ProjectState mProjectState;
        private String mPath;

        private LibraryState(String relativePath) {
            this.mRelativePath = relativePath;
        }

        public ProjectState getMainProjectState() {
            return ProjectState.this;
        }

        public void close() {
            this.mProjectState.removeParentProject(this.getMainProjectState());
            this.mProjectState = null;
            this.mPath = null;
            this.getMainProjectState().updateFullLibraryList();
        }

        private void setRelativePath(String relativePath) {
            this.mRelativePath = relativePath;
        }

        private void setProject(ProjectState project) {
            this.mProjectState = project;
            this.mPath = project.getProject().getLocation().toOSString();
            this.mProjectState.addParentProject(this.getMainProjectState());
            this.getMainProjectState().updateFullLibraryList();
        }

        public String getRelativePath() {
            return this.mRelativePath;
        }

        public ProjectState getProjectState() {
            return this.mProjectState;
        }

        public String getProjectLocation() {
            return this.mPath;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LibraryState) {
                LibraryState objState = (LibraryState)obj;
                return this.mRelativePath.equals(objState.mRelativePath) && this.getMainProjectState().equals(objState.getMainProjectState());
            }
            if (obj instanceof ProjectState || obj instanceof IProject) {
                return this.mProjectState != null && this.mProjectState.equals(obj);
            }
            if (obj instanceof String) {
                return ProjectState.this.normalizePath(this.mRelativePath).equals(ProjectState.this.normalizePath((String)obj));
            }
            return false;
        }

        public int hashCode() {
            return ProjectState.this.normalizePath(this.mRelativePath).hashCode();
        }
    }
}

