/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.welcome;

import com.android.SdkConstants;
import com.android.sdkstats.DdmsPreferenceStore;
import com.android.utils.GrabProcessOutput;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.editors.layout.gle2.LayoutWindowCoordinator;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.welcome.WelcomeWizard;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AdtStartup
implements IStartup,
IWindowListener {
    private DdmsPreferenceStore mStore = new DdmsPreferenceStore();

    public void earlyStartup() {
        boolean showSdkInstallationPage;
        File bundledSdk;
        if (!this.isSdkSpecified() && (bundledSdk = this.getBundledSdk()) != null) {
            AdtPrefs.getPrefs().setSdkLocation(bundledSdk);
        }
        boolean bl = showSdkInstallationPage = !this.isSdkSpecified() && this.isFirstTime();
        if (showSdkInstallationPage) {
            this.showWelcomeWizard(showSdkInstallationPage);
        }
        this.initializeWindowCoordinator();
        AndmoreAndroidPlugin.getDefault().workbenchStarted();
    }

    private boolean isSdkSpecified() {
        String osSdkFolder = AdtPrefs.getPrefs().getOsSdkFolder();
        return osSdkFolder != null && !osSdkFolder.isEmpty();
    }

    private File getBundledSdk() {
        File sdkFolder;
        File toolsFolder;
        Location install = Platform.getInstallLocation();
        if (install != null && install.getURL() != null && (toolsFolder = new File(install.getURL().getFile()).getParentFile()) != null && (sdkFolder = new File(toolsFolder, "sdk")).exists() && AndmoreAndroidPlugin.getDefault().checkSdkLocationAndId(sdkFolder.getAbsolutePath(), new SdkValidator())) {
            return sdkFolder;
        }
        return null;
    }

    private boolean isFirstTime() {
        int i = 0;
        while (i < 2) {
            String osSdkPath = null;
            if (i == 0) {
                osSdkPath = this.mStore.getLastSdkPath();
            } else if (i == 1) {
                osSdkPath = this.getSdkPathFromWindowsRegistry();
            }
            if (osSdkPath != null && osSdkPath.length() > 0) {
                boolean ok = new File(osSdkPath).isDirectory();
                if (!ok) {
                    osSdkPath = osSdkPath.trim();
                    ok = new File(osSdkPath).isDirectory();
                }
                if (ok && (ok = AndmoreAndroidPlugin.getDefault().checkSdkLocationAndId(osSdkPath, new SdkValidator()))) {
                    AdtPrefs.getPrefs().setSdkLocation(new File(osSdkPath));
                    return false;
                }
            }
            ++i;
        }
        return !this.mStore.isAdtUsed();
    }

    private String getSdkPathFromWindowsRegistry() {
        if (SdkConstants.CURRENT_PLATFORM != 2) {
            return null;
        }
        final AtomicReference result = new AtomicReference();
        final Pattern regexp = Pattern.compile("^\\s+Path\\s+REG_SZ\\s+(.*)$");
        String[] stringArray = new String[]{"HKLM\\Software\\Android SDK Tools", "HKLM\\Software\\Wow6432Node\\Android SDK Tools"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String[] command = new String[]{"reg", "query", key, "/v", "Path"};
            try {
                Process process = Runtime.getRuntime().exec(command);
                GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                    public void out(String line) {
                        Matcher m;
                        if (line != null && (m = regexp.matcher(line)).matches()) {
                            result.set(m.group(1));
                        }
                    }

                    public void err(String line) {
                    }
                });
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {}
            String str = (String)result.get();
            if (str != null) {
                if (new File(str).isDirectory()) {
                    return str;
                }
                if (new File(str = str.trim()).isDirectory()) {
                    return str;
                }
            }
            ++n2;
        }
        return null;
    }

    private void initializeWindowCoordinator() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this);
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow[] iWorkbenchWindowArray = workbench.getWorkbenchWindows();
                int n = iWorkbenchWindowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                    LayoutWindowCoordinator.get(window, true);
                    ++n2;
                }
            }
        });
    }

    private void showWelcomeWizard(final boolean showSdkInstallPage) {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    WelcomeWizard wizard = new WelcomeWizard(AdtStartup.this.mStore, showSdkInstallPage);
                    WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)wizard);
                    dialog.open();
                }
            }
        });
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        LayoutWindowCoordinator listener = LayoutWindowCoordinator.get(window, false);
        if (listener != null) {
            listener.dispose();
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        LayoutWindowCoordinator.get(window, true);
    }

    private static class SdkValidator
    extends AndmoreAndroidPlugin.CheckSdkErrorHandler {
        private SdkValidator() {
        }

        @Override
        public boolean handleError(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution solution, String message) {
            return false;
        }

        @Override
        public boolean handleWarning(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution solution, String message) {
            return true;
        }
    }
}

