/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.welcome;

import com.android.sdkstats.DdmsPreferenceStore;
import com.android.sdkuilib.internal.repository.ui.AdtUpdateDialog;
import com.android.utils.ILogger;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.preferences.AdtPrefs;
import org.eclipse.andmore.internal.sdk.AdtConsoleSdkLog;
import org.eclipse.andmore.internal.welcome.WelcomeWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WelcomeWizard
extends Wizard {
    private final DdmsPreferenceStore mStore;
    private WelcomeWizardPage mWelcomePage;
    private final boolean mShowWelcomePage;

    public WelcomeWizard(DdmsPreferenceStore store, boolean showInstallSdkPage) {
        this.mStore = store;
        this.mShowWelcomePage = showInstallSdkPage;
        this.setWindowTitle("Welcome to Android Development");
        ImageDescriptor image = AndmoreAndroidPlugin.getImageDescriptor("icons/android-64.png");
        this.setDefaultPageImageDescriptor(image);
    }

    public void addPages() {
        if (this.mShowWelcomePage) {
            this.mWelcomePage = new WelcomeWizardPage();
            this.addPage((IWizardPage)this.mWelcomePage);
        }
    }

    public boolean performFinish() {
        if (this.mWelcomePage != null) {
            final File path = this.mWelcomePage.getPath();
            final boolean installCommon = this.mWelcomePage.isInstallCommon();
            final boolean installLatest = this.mWelcomePage.isInstallLatest();
            final boolean createNew = this.mWelcomePage.isCreateNew();
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (createNew) {
                        try {
                            HashSet<Integer> apiLevels = new HashSet<Integer>();
                            if (installCommon) {
                                apiLevels.add(8);
                            }
                            if (installLatest) {
                                apiLevels.add(0);
                            }
                            WelcomeWizard.this.installSdk(path, apiLevels);
                        }
                        catch (Exception e) {
                            AndmoreAndroidPlugin.logAndPrintError(e, "Andmore Welcome Wizard", "Installation failed", new Object[0]);
                        }
                    }
                    AdtPrefs.getPrefs().setSdkLocation(path);
                }
            });
        }
        return true;
    }

    private boolean installSdk(File path, Set<Integer> apiLevels) {
        IWorkbench workbench;
        IWorkbenchWindow window;
        if (!path.isDirectory() && !path.mkdirs()) {
            AndmoreAndroidPlugin.logAndPrintError(null, "Andmore Welcome Wizard", "Failed to create directory %1$s", path.getAbsolutePath());
            return false;
        }
        Display display = AndmoreAndroidPlugin.getDisplay();
        Shell shell = display.getActiveShell();
        if (shell == null && (window = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        boolean disposeShell = false;
        if (shell == null) {
            shell = new Shell(display);
            AndmoreAndroidPlugin.log(2, "No parent shell for SDK installation dialog", new Object[0]);
            disposeShell = true;
        }
        AdtUpdateDialog updater = new AdtUpdateDialog(shell, (ILogger)new AdtConsoleSdkLog(), path.getAbsolutePath());
        boolean result = updater.installNewSdk(apiLevels);
        if (disposeShell) {
            shell.dispose();
        }
        if (!result) {
            AndmoreAndroidPlugin.printErrorToConsole("Failed to install Android SDK.", new Object[0]);
            return false;
        }
        return true;
    }
}

