/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.welcome;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WelcomeWizardPage
extends WizardPage
implements ModifyListener,
SelectionListener {
    private Text mExistingDirText;
    private Button mExistingDirButton;
    private Button mInstallLatestCheckbox;
    private Button mInstallCommonCheckbox;
    private Button mInstallNewRadio;
    private Button mUseExistingRadio;
    private Text mNewDirText;
    private Button mNewDirButton;

    public WelcomeWizardPage() {
        super("welcomePage");
        this.setTitle("Welcome to Android Development");
        this.setDescription("Configure SDK");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(4, false));
        Label overviewLabel = new Label(container, 96);
        GridData gdOverviewLabel = new GridData(4, 0x1000000, false, false, 4, 1);
        gdOverviewLabel.widthHint = 580;
        overviewLabel.setLayoutData((Object)gdOverviewLabel);
        overviewLabel.setText("To develop for Android, you need an Android SDK, and at least one version of the Android APIs to compile against. You may also want additional versions of Android to test with.");
        Label spacing = new Label(container, 0);
        spacing.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mInstallNewRadio = new Button(container, 16);
        this.mInstallNewRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mInstallNewRadio.setSelection(true);
        this.mInstallNewRadio.setText("Install new SDK");
        this.mInstallNewRadio.addSelectionListener((SelectionListener)this);
        Label indentLabel = new Label(container, 0);
        GridData gdIndentLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdIndentLabel.widthHint = 20;
        indentLabel.setLayoutData((Object)gdIndentLabel);
        this.mInstallLatestCheckbox = new Button(container, 32);
        this.mInstallLatestCheckbox.setSelection(true);
        this.mInstallLatestCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.mInstallLatestCheckbox.setText("Install the latest available version of Android APIs (supports all the latest features)");
        this.mInstallLatestCheckbox.addSelectionListener((SelectionListener)this);
        new Label(container, 0);
        this.mInstallCommonCheckbox = new Button(container, 32);
        this.mInstallCommonCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.mInstallCommonCheckbox.setText("Install Android 2.2, a version which is supported by ~96% phones and tablets");
        this.mInstallCommonCheckbox.addSelectionListener((SelectionListener)this);
        new Label(container, 0);
        Label addHintLabel = new Label(container, 0);
        addHintLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        addHintLabel.setText("     (You can add additional platforms using the SDK Manager.)");
        new Label(container, 0);
        Label targetLabel = new Label(container, 0);
        targetLabel.setText("Target Location:");
        this.mNewDirText = new Text(container, 2048);
        this.mNewDirText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        String defaultPath = String.valueOf(System.getProperty("user.home")) + File.separator + "android-sdks";
        this.mNewDirText.setText(defaultPath);
        this.mNewDirText.addModifyListener((ModifyListener)this);
        this.mNewDirButton = new Button(container, 0x800000);
        this.mNewDirButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.mNewDirButton.setText("Browse...");
        this.mNewDirButton.addSelectionListener((SelectionListener)this);
        Label spacing2 = new Label(container, 0);
        spacing2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mUseExistingRadio = new Button(container, 16);
        this.mUseExistingRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.mUseExistingRadio.setText("Use existing SDKs");
        this.mUseExistingRadio.addSelectionListener((SelectionListener)this);
        new Label(container, 0);
        Label installationLabel = new Label(container, 0);
        installationLabel.setText("Existing Location:");
        this.mExistingDirText = new Text(container, 2048);
        this.mExistingDirText.setEnabled(false);
        this.mExistingDirText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mExistingDirText.addModifyListener((ModifyListener)this);
        this.mExistingDirButton = new Button(container, 0x800000);
        this.mExistingDirButton.setEnabled(false);
        this.mExistingDirButton.setText("Browse...");
        this.mExistingDirButton.addSelectionListener((SelectionListener)this);
    }

    boolean isCreateNew() {
        return this.mInstallNewRadio.getSelection();
    }

    boolean isInstallLatest() {
        return this.mInstallLatestCheckbox.getSelection();
    }

    boolean isInstallCommon() {
        return this.mInstallCommonCheckbox.getSelection();
    }

    File getPath() {
        Text text = this.isCreateNew() ? this.mNewDirText : this.mExistingDirText;
        return new File(text.getText());
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.mExistingDirButton) {
            DirectoryDialog dialog = new DirectoryDialog(this.mExistingDirButton.getShell(), 4096);
            String file = dialog.open();
            String path = this.mExistingDirText.getText().trim();
            if (path.length() > 0) {
                dialog.setFilterPath(path);
            }
            if (file != null) {
                this.mExistingDirText.setText(file);
            }
        } else if (source == this.mNewDirButton) {
            String file;
            DirectoryDialog dialog = new DirectoryDialog(this.mNewDirButton.getShell(), 4096);
            String path = this.mNewDirText.getText().trim();
            if (path.length() > 0) {
                dialog.setFilterPath(path);
            }
            if ((file = dialog.open()) != null) {
                this.mNewDirText.setText(file);
            }
        } else if (source == this.mInstallNewRadio) {
            this.mExistingDirButton.setEnabled(false);
            this.mExistingDirText.setEnabled(false);
            this.mNewDirButton.setEnabled(true);
            this.mNewDirText.setEnabled(true);
        } else if (source == this.mUseExistingRadio) {
            this.mExistingDirButton.setEnabled(true);
            this.mExistingDirText.setEnabled(true);
            this.mNewDirButton.setEnabled(false);
            this.mNewDirText.setEnabled(false);
        }
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        this.validatePage();
    }

    private void validatePage() {
        String error = null;
        String warning = null;
        if (this.isCreateNew()) {
            String path = this.mNewDirText.getText().trim();
            if (path.length() == 0) {
                error = "Please enter a new directory to install the SDK into";
            } else {
                File file = new File(path);
                if (file.exists()) {
                    if (file.isDirectory()) {
                        File[] children;
                        if (!file.canWrite()) {
                            error = "Missing write permission in target directory";
                        }
                        if ((children = file.listFiles()) != null && children.length > 0) {
                            warning = "The directory is not empty";
                        }
                    } else {
                        error = "The target must be a directory";
                    }
                } else {
                    File parent = file.getParentFile();
                    if (parent == null || !parent.exists()) {
                        error = "The parent directory does not exist";
                    } else if (!parent.canWrite()) {
                        error = "No write permission in parent directory";
                    }
                }
            }
            if (error == null && !this.mInstallLatestCheckbox.getSelection() && !this.mInstallCommonCheckbox.getSelection()) {
                error = "You must choose at least one Android version to install";
            }
        } else {
            String path = this.mExistingDirText.getText().trim();
            if (path.length() == 0) {
                error = "Please enter an existing SDK installation directory";
            } else {
                File file = new File(path);
                if (!file.exists()) {
                    error = "The chosen installation directory does not exist";
                } else {
                    final AtomicReference errorReference = new AtomicReference();
                    final AtomicReference warningReference = new AtomicReference();
                    AndmoreAndroidPlugin.getDefault().checkSdkLocationAndId(path, new AndmoreAndroidPlugin.CheckSdkErrorHandler(){

                        @Override
                        public boolean handleError(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution solution, String message) {
                            message = message.replaceAll("\n", " ");
                            errorReference.set(message);
                            return false;
                        }

                        @Override
                        public boolean handleWarning(AndmoreAndroidPlugin.CheckSdkErrorHandler.Solution solution, String message) {
                            message = message.replaceAll("\n", " ");
                            warningReference.set(message);
                            return true;
                        }
                    });
                    error = (String)errorReference.get();
                    if (warning == null) {
                        warning = (String)warningReference.get();
                    }
                }
            }
        }
        this.setPageComplete(error == null);
        if (error != null) {
            this.setMessage(error, 3);
        } else if (warning != null) {
            this.setMessage(warning, 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }
}

