/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.export;

import java.io.File;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.wizards.export.ExportWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class KeystoreSelectionPage
extends ExportWizard.ExportWizardPage {
    private final ExportWizard mWizard;
    private Button mUseExistingKeystore;
    private Button mCreateKeystore;
    private Text mKeystore;
    private Text mKeystorePassword;
    private Label mConfirmLabel;
    private Text mKeystorePassword2;
    private boolean mDisableOnChange = false;

    protected KeystoreSelectionPage(ExportWizard wizard, String pageName) {
        super(pageName);
        this.mWizard = wizard;
        this.setTitle("Keystore selection");
        this.setDescription("");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(3, false);
        composite.setLayout((Layout)gl);
        this.mUseExistingKeystore = new Button(composite, 16);
        this.mUseExistingKeystore.setText("Use existing keystore");
        GridData gd = new GridData(768);
        this.mUseExistingKeystore.setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        this.mUseExistingKeystore.setSelection(true);
        this.mCreateKeystore = new Button(composite, 16);
        this.mCreateKeystore.setText("Create new keystore");
        gd = new GridData(768);
        this.mCreateKeystore.setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        new Label(composite, 0).setText("Location:");
        this.mKeystore = new Text(composite, 2048);
        gd = new GridData(768);
        this.mKeystore.setLayoutData((Object)gd);
        final Button browseButton = new Button(composite, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog;
                if (KeystoreSelectionPage.this.mUseExistingKeystore.getSelection()) {
                    fileDialog = new FileDialog(browseButton.getShell(), 4096);
                    fileDialog.setText("Load Keystore");
                } else {
                    fileDialog = new FileDialog(browseButton.getShell(), 8192);
                    fileDialog.setText("Select Keystore Name");
                }
                String fileName = fileDialog.open();
                if (fileName != null) {
                    KeystoreSelectionPage.this.mKeystore.setText(fileName);
                }
            }
        });
        new Label(composite, 0).setText("Password:");
        this.mKeystorePassword = new Text(composite, 0x400800);
        gd = new GridData(768);
        this.mKeystorePassword.setLayoutData((Object)gd);
        this.mKeystorePassword.addVerifyListener(sPasswordVerifier);
        gd = new GridData();
        new Composite(composite, 0).setLayoutData((Object)gd);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.mConfirmLabel = new Label(composite, 0);
        this.mConfirmLabel.setText("Confirm:");
        this.mKeystorePassword2 = new Text(composite, 0x400800);
        gd = new GridData(768);
        this.mKeystorePassword2.setLayoutData((Object)gd);
        this.mKeystorePassword2.addVerifyListener(sPasswordVerifier);
        gd = new GridData();
        new Composite(composite, 0).setLayoutData((Object)gd);
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.mKeystorePassword2.setEnabled(false);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        this.mUseExistingKeystore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean createStore = !KeystoreSelectionPage.this.mUseExistingKeystore.getSelection();
                KeystoreSelectionPage.this.mKeystorePassword2.setEnabled(createStore);
                KeystoreSelectionPage.this.mConfirmLabel.setEnabled(createStore);
                KeystoreSelectionPage.this.mWizard.setKeystoreCreationMode(createStore);
                KeystoreSelectionPage.this.onChange();
            }
        });
        this.mKeystore.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeystoreSelectionPage.this.mWizard.setKeystore(KeystoreSelectionPage.this.mKeystore.getText().trim());
                KeystoreSelectionPage.this.onChange();
            }
        });
        this.mKeystorePassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeystoreSelectionPage.this.mWizard.setKeystorePassword(KeystoreSelectionPage.this.mKeystorePassword.getText());
                KeystoreSelectionPage.this.onChange();
            }
        });
        this.mKeystorePassword2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeystoreSelectionPage.this.onChange();
            }
        });
    }

    public IWizardPage getNextPage() {
        if (this.mUseExistingKeystore.getSelection()) {
            return this.mWizard.getKeySelectionPage();
        }
        return this.mWizard.getKeyCreationPage();
    }

    @Override
    void onShow() {
        if ((this.mProjectDataChanged & 1) != 0) {
            IProject project = this.mWizard.getProject();
            this.mDisableOnChange = true;
            String keystore = ProjectHelper.loadStringProperty((IResource)project, "keystore");
            if (keystore != null) {
                this.mKeystore.setText(keystore);
            }
            this.mKeystorePassword.setText("");
            this.mKeystorePassword2.setText("");
            this.mDisableOnChange = false;
            this.onChange();
        }
    }

    private void onChange() {
        String value;
        if (this.mDisableOnChange) {
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        boolean createStore = !this.mUseExistingKeystore.getSelection();
        String keystore = this.mKeystore.getText().trim();
        if (keystore.length() == 0) {
            this.setErrorMessage("Enter path to keystore.");
            this.setPageComplete(false);
            return;
        }
        File f = new File(keystore);
        if (!f.exists()) {
            if (!createStore) {
                this.setErrorMessage("Keystore does not exist.");
                this.setPageComplete(false);
                return;
            }
        } else {
            if (f.isDirectory()) {
                this.setErrorMessage("Keystore path is a directory.");
                this.setPageComplete(false);
                return;
            }
            if (f.isFile() && createStore) {
                this.setErrorMessage("File already exists.");
                this.setPageComplete(false);
                return;
            }
        }
        if ((value = this.mKeystorePassword.getText()).length() == 0) {
            this.setErrorMessage("Enter keystore password.");
            this.setPageComplete(false);
            return;
        }
        if (createStore && value.length() < 6) {
            this.setErrorMessage("Keystore password is too short - must be at least 6 characters.");
            this.setPageComplete(false);
            return;
        }
        if (createStore) {
            if (this.mKeystorePassword2.getText().length() == 0) {
                this.setErrorMessage("Confirm keystore password.");
                this.setPageComplete(false);
                return;
            }
            if (!this.mKeystorePassword.getText().equals(this.mKeystorePassword2.getText())) {
                this.setErrorMessage("Keystore passwords do not match.");
                this.setPageComplete(false);
                return;
            }
        }
        this.setPageComplete(true);
    }
}

