/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.export;

import com.android.ide.common.xml.ManifestData;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.project.AndroidManifestHelper;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.project.ProjectChooserHelper;
import org.eclipse.andmore.internal.project.ProjectHelper;
import org.eclipse.andmore.internal.wizards.export.ExportWizard;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

final class ProjectCheckPage
extends ExportWizard.ExportWizardPage {
    private static final String IMG_ERROR = "error.png";
    private static final String IMG_WARNING = "warning.png";
    private final ExportWizard mWizard;
    private Image mError;
    private Image mWarning;
    private boolean mHasMessage = false;
    private Composite mTopComposite;
    private Composite mErrorComposite;
    private Text mProjectText;
    private ProjectChooserHelper mProjectChooserHelper;
    private boolean mFirstOnShow = true;

    protected ProjectCheckPage(ExportWizard wizard, String pageName) {
        super(pageName);
        this.mWizard = wizard;
        this.setTitle("Project Checks");
        this.setDescription("Performs a set of checks to make sure the application can be exported.");
    }

    public void createControl(Composite parent) {
        this.mProjectChooserHelper = new ProjectChooserHelper(parent.getShell(), new ProjectChooserHelper.NonLibraryProjectOnlyFilter());
        GridLayout gl = null;
        GridData gd = null;
        this.mTopComposite = new Composite(parent, 0);
        this.mTopComposite.setLayoutData((Object)new GridData(1808));
        this.mTopComposite.setLayout((Layout)new GridLayout(1, false));
        Composite projectComposite = new Composite(this.mTopComposite, 0);
        projectComposite.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(3, false);
        projectComposite.setLayout((Layout)gl);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        Label label = new Label(projectComposite, 0);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        gd.horizontalSpan = 3;
        label.setText("Select the project to export:");
        new Label(projectComposite, 0).setText("Project:");
        this.mProjectText = new Text(projectComposite, 2048);
        gd = new GridData(768);
        this.mProjectText.setLayoutData((Object)gd);
        this.mProjectText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectCheckPage.this.handleProjectNameChange();
            }
        });
        Button browseButton = new Button(projectComposite, 8);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IJavaProject javaProject = ProjectCheckPage.this.mProjectChooserHelper.chooseJavaProject(ProjectCheckPage.this.mProjectText.getText().trim(), "Please select a project to export");
                if (javaProject != null) {
                    IProject project = javaProject.getProject();
                    ProjectCheckPage.this.mProjectText.setText(project.getName());
                }
            }
        });
        this.setControl((Control)this.mTopComposite);
    }

    @Override
    void onShow() {
        if (this.mFirstOnShow) {
            IProject project = this.mWizard.getProject();
            if (project != null) {
                this.mProjectText.setText(project.getName());
            }
            this.mFirstOnShow = false;
        }
    }

    private void buildErrorUi(IProject project) {
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
        this.mHasMessage = false;
        GridLayout gl = null;
        this.mErrorComposite = new Composite(this.mTopComposite, 0);
        this.mErrorComposite.setLayoutData((Object)new GridData(768));
        gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing *= 3;
        this.mErrorComposite.setLayout((Layout)gl);
        if (project == null) {
            this.setErrorMessage("Select project to export.");
            this.mHasMessage = true;
        } else {
            try {
                if (!project.hasNature("org.eclipse.andmore.AndroidNature")) {
                    this.addError(this.mErrorComposite, "Project is not an Android project.");
                } else {
                    IFolder outputIFolder;
                    if (ProjectHelper.hasError(project, true)) {
                        this.addError(this.mErrorComposite, "Project has compilation error(s)");
                    }
                    if ((outputIFolder = BaseProjectHelper.getJavaOutputFolder(project)) == null) {
                        this.addError(this.mErrorComposite, "Unable to get the output folder of the project!");
                    }
                    ManifestData manifestData = AndroidManifestHelper.parseForData(project);
                    Boolean debuggable = null;
                    if (manifestData != null) {
                        debuggable = manifestData.getDebuggable();
                    }
                    if (debuggable != null && debuggable == Boolean.TRUE) {
                        this.addWarning(this.mErrorComposite, "The manifest 'debuggable' attribute is set to true.\nYou should set it to false for applications that you release to the public.\n\nApplications with debuggable=true are compiled in debug mode always.");
                    }
                }
            }
            catch (CoreException coreException) {
                this.addError(this.mErrorComposite, "Unable to get project nature");
            }
        }
        if (!this.mHasMessage) {
            Label label = new Label(this.mErrorComposite, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            label.setText("No errors found. Click Next.");
        }
        this.mTopComposite.layout();
    }

    private void addError(Composite parent, String message) {
        if (this.mError == null) {
            this.mError = IconFactory.getInstance().getIcon(IMG_ERROR);
        }
        new Label(parent, 0).setImage(this.mError);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(message);
        this.setErrorMessage("Application cannot be exported due to the error(s) below.");
        this.setPageComplete(false);
        this.mHasMessage = true;
    }

    private void addWarning(Composite parent, String message) {
        if (this.mWarning == null) {
            this.mWarning = IconFactory.getInstance().getIcon(IMG_WARNING);
        }
        new Label(parent, 0).setImage(this.mWarning);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(message);
        this.mHasMessage = true;
    }

    private void handleProjectNameChange() {
        this.setPageComplete(false);
        if (this.mErrorComposite != null) {
            this.mErrorComposite.dispose();
            this.mErrorComposite = null;
        }
        this.mWizard.setProject(null);
        String text = this.mProjectText.getText().trim();
        if (text.length() == 0) {
            this.setErrorMessage("Select project to export.");
        } else if (!text.matches("[a-zA-Z0-9_ \\.-]+")) {
            this.setErrorMessage("Project name contains unsupported characters!");
        } else {
            IJavaProject[] projects = this.mProjectChooserHelper.getAndroidProjects(null);
            IProject found = null;
            IJavaProject[] iJavaProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject javaProject = iJavaProjectArray[n2];
                if (javaProject.getProject().getName().equals(text)) {
                    found = javaProject.getProject();
                    break;
                }
                ++n2;
            }
            if (found != null) {
                this.setErrorMessage(null);
                this.mWizard.setProject(found);
                this.buildErrorUi(found);
            } else {
                this.setErrorMessage(String.format("There is no android project named '%1$s'", text));
            }
        }
    }
}

