/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.exportgradle;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.wizards.exportgradle.BuildFileCreator;
import org.eclipse.andmore.internal.wizards.exportgradle.ConfirmationPage;
import org.eclipse.andmore.internal.wizards.exportgradle.ExportMessages;
import org.eclipse.andmore.internal.wizards.exportgradle.FinalPage;
import org.eclipse.andmore.internal.wizards.exportgradle.GradleModule;
import org.eclipse.andmore.internal.wizards.exportgradle.ImportInsteadPage;
import org.eclipse.andmore.internal.wizards.exportgradle.ProjectSelectionPage;
import org.eclipse.andmore.internal.wizards.exportgradle.ProjectSetupBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class GradleExportWizard
extends Wizard
implements IExportWizard {
    private ProjectSetupBuilder mBuilder = new ProjectSetupBuilder();
    private ProjectSelectionPage mFirstPage;
    private ConfirmationPage mSecondPage;
    private FinalPage mFinalPage;

    public boolean performFinish() {
        if (this.mBuilder.canGenerate()) {
            this.generateBuildfiles(this.mSecondPage);
            this.getContainer().showPage((IWizardPage)this.mFinalPage);
            return false;
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ImportInsteadPage());
        this.mFirstPage = new ProjectSelectionPage(this.mBuilder);
        this.addPage((IWizardPage)this.mFirstPage);
        this.mSecondPage = new ConfirmationPage(this.mBuilder);
        this.addPage((IWizardPage)this.mSecondPage);
        this.mFinalPage = new FinalPage(this.mBuilder);
        this.addPage((IWizardPage)this.mFinalPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ExportMessages.WindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public boolean canFinish() {
        return this.mBuilder.canFinish() || this.mBuilder.canGenerate();
    }

    public boolean generateBuildfiles(final WizardPage page) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InterruptedException {
                Collection<GradleModule> modules = GradleExportWizard.this.mBuilder.getModules();
                int count = modules.size();
                SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)pm, (String)ExportMessages.StatusMessage, (int)count);
                BuildFileCreator.createBuildFiles(GradleExportWizard.this.mBuilder, page.getShell(), (IProgressMonitor)localmonitor.newChild(count));
            }
        };
        try {
            this.getContainer().run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return false;
        }
        catch (InterruptedException e) {
            AndmoreAndroidPlugin.log(e, null, new Object[0]);
            return false;
        }
        return page.getErrorMessage() == null;
    }
}

