/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.exportgradle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.andmore.internal.project.BaseProjectHelper;
import org.eclipse.andmore.internal.sdk.ProjectState;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.wizards.exportgradle.ExportStatus;
import org.eclipse.andmore.internal.wizards.exportgradle.GradleModule;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectSetupBuilder {
    private boolean mCanFinish = false;
    private boolean mCanGenerate = false;
    private final List<GradleModule> mOriginalModules = Lists.newArrayList();
    private final Map<IJavaProject, GradleModule> mModules = Maps.newHashMap();
    private IPath mCommonRoot;
    private ExportStatus mStatus;

    public void setCanGenerate(boolean generate) {
        this.mCanGenerate = generate;
    }

    public void setCanFinish(boolean canFinish) {
        this.mCanFinish = canFinish;
    }

    public boolean canFinish() {
        return this.mCanFinish;
    }

    public boolean canGenerate() {
        return this.mCanGenerate;
    }

    public void setStatus(ExportStatus status) {
        this.mStatus = status;
    }

    public ExportStatus getStatus() {
        return this.mStatus;
    }

    public String setProject(List<IJavaProject> selectedProjects) throws CoreException {
        this.mModules.clear();
        try {
            for (IJavaProject javaProject : selectedProjects) {
                GradleModule module = javaProject.getProject().hasNature("org.eclipse.andmore.AndroidNature") ? this.processAndroidProject(javaProject) : this.processJavaProject(javaProject);
                this.mOriginalModules.add(module);
            }
            Collection<GradleModule> modules = this.mModules.values();
            this.computeRootAndPaths(modules);
            return null;
        }
        catch (InternalException e) {
            return e.getMessage();
        }
    }

    public Collection<GradleModule> getModules() {
        return this.mModules.values();
    }

    public int getModuleCount() {
        return this.mModules.size();
    }

    public IPath getCommonRoot() {
        return this.mCommonRoot;
    }

    public GradleModule getModule(IJavaProject javaProject) {
        return this.mModules.get(javaProject);
    }

    public boolean isOriginalProject(IJavaProject javaProject) {
        GradleModule module = this.mModules.get(javaProject);
        return this.mOriginalModules.contains(module);
    }

    public List<GradleModule> getOriginalModules() {
        return this.mOriginalModules;
    }

    public List<GradleModule> getShortestDependencyTo(GradleModule module) {
        return this.findModule(module, this.mOriginalModules);
    }

    public List<GradleModule> findModule(GradleModule toFind, GradleModule rootModule) {
        if (toFind == rootModule) {
            ArrayList list = Lists.newArrayList();
            list.add(toFind);
            return list;
        }
        List<GradleModule> shortestChain = this.findModule(toFind, rootModule.getDependencies());
        if (shortestChain != null) {
            shortestChain.add(0, rootModule);
        }
        return shortestChain;
    }

    public List<GradleModule> findModule(GradleModule toFind, List<GradleModule> modules) {
        List<GradleModule> currentChain = null;
        for (GradleModule child : modules) {
            List<GradleModule> newChain = this.findModule(toFind, child);
            if (currentChain == null) {
                currentChain = newChain;
                continue;
            }
            if (newChain == null || currentChain.size() <= newChain.size()) continue;
            currentChain = newChain;
        }
        return currentChain;
    }

    private GradleModule processAndroidProject(IJavaProject javaProject) throws InternalException, CoreException {
        GradleModule module = this.createModuleOnDemand(javaProject);
        if (module.isConfigured()) {
            return module;
        }
        module.setType(GradleModule.Type.ANDROID);
        ProjectState projectState = Sdk.getProjectState(javaProject.getProject());
        assert (projectState != null);
        List<ProjectState.LibraryState> libraryProjects = projectState.getLibraries();
        for (ProjectState.LibraryState libraryState : libraryProjects) {
            ProjectState libProjectState = libraryState.getProjectState();
            if (libProjectState != null) {
                IJavaProject javaLib = this.getJavaProject(libProjectState);
                if (javaLib != null) {
                    GradleModule libModule = this.processAndroidProject(javaLib);
                    module.addDependency(libModule);
                    continue;
                }
                throw new InternalException(String.format("Project %1$s is missing. Needed by %2$s.\nMake sure all dependencies are opened.", libraryState.getRelativePath(), javaProject.getProject().getName()));
            }
            throw new InternalException(String.format("Project %1$s is missing. Needed by %2$s.\nMake sure all dependencies are opened.", libraryState.getRelativePath(), javaProject.getProject().getName()));
        }
        List<IJavaProject> javaDepProjects = ProjectSetupBuilder.getReferencedProjects(javaProject);
        for (IJavaProject javaDep : javaDepProjects) {
            GradleModule libModule = this.processJavaProject(javaDep);
            module.addDependency(libModule);
        }
        return module;
    }

    private GradleModule processJavaProject(IJavaProject javaProject) throws InternalException, CoreException {
        GradleModule module = this.createModuleOnDemand(javaProject);
        if (module.isConfigured()) {
            return module;
        }
        module.setType(GradleModule.Type.JAVA);
        List<IJavaProject> javaDepProjects = ProjectSetupBuilder.getReferencedProjects(javaProject);
        for (IJavaProject javaDep : javaDepProjects) {
            if (javaDep.getProject().hasNature("org.eclipse.andmore.AndroidNature")) {
                throw new InternalException(String.format("Java project %1$s depends on Android project %2$s!\nThis is not a valid dependency", javaProject.getProject().getName(), javaDep.getProject().getName()));
            }
            GradleModule libModule = this.processJavaProject(javaDep);
            module.addDependency(libModule);
        }
        return module;
    }

    private void computeRootAndPaths(Collection<GradleModule> modules) throws InternalException {
        this.mCommonRoot = ProjectSetupBuilder.determineCommonRoot(modules);
        for (GradleModule module : modules) {
            String path = ProjectSetupBuilder.getGradlePath(module.getJavaProject().getProject().getLocation(), this.mCommonRoot);
            module.setPath(path);
        }
    }

    private static IPath determineCommonRoot(Collection<GradleModule> modules) throws InternalException {
        IPath commonRoot = null;
        for (GradleModule module : modules) {
            commonRoot = commonRoot == null ? module.getJavaProject().getProject().getLocation() : ProjectSetupBuilder.findCommonRoot(commonRoot, module.getJavaProject().getProject().getLocation());
        }
        return commonRoot;
    }

    private static String getGradlePath(IPath path, IPath root) {
        IPath relativePath = path.makeRelativeTo(root);
        String relativeString = relativePath.toOSString();
        return ":" + relativeString.replaceAll(Pattern.quote(File.separator), ":");
    }

    private static IPath findCommonRoot(IPath path1, IPath path2) throws InternalException {
        if (path1.getDevice() != null && !path1.getDevice().equals(path2.getDevice())) {
            throw new InternalException("Different modules have been detected on different drives.\nThis prevents finding a common root to all modules.");
        }
        IPath result = path1.uptoSegment(0);
        int count = Math.min(path1.segmentCount(), path2.segmentCount());
        int i = 0;
        while (i < count) {
            if (path1.segment(i).equals(path2.segment(i))) {
                result = result.append(String.valueOf('/') + path2.segment(i));
            }
            ++i;
        }
        return result;
    }

    private IJavaProject getJavaProject(ProjectState projectState) {
        try {
            return BaseProjectHelper.getJavaProject(projectState.getProject());
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private GradleModule createModuleOnDemand(IJavaProject javaProject) {
        GradleModule module = this.mModules.get(javaProject);
        if (module == null) {
            module = new GradleModule(javaProject);
            this.mModules.put(javaProject, module);
        }
        return module;
    }

    private static List<IJavaProject> getReferencedProjects(IJavaProject javaProject) throws JavaModelException, InternalException {
        IClasspathEntry[] entries;
        ArrayList projects = Lists.newArrayList();
        IClasspathEntry[] iClasspathEntryArray = entries = javaProject.getRawClasspath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getContentKind() == 1 && classpathEntry.getEntryKind() == 2) {
                String subProjectRoot = classpathEntry.getPath().toString();
                IJavaProject subProject = ProjectSetupBuilder.getJavaProject(subProjectRoot);
                if (subProject != null) {
                    projects.add(subProject);
                } else {
                    throw new InternalException(String.format("Project '%s' is missing project dependency '%s' in Eclipse workspace.\nMake sure all dependencies are opened.", javaProject.getProject().getName(), classpathEntry.getPath().toString()));
                }
            }
            ++n2;
        }
        return projects;
    }

    private static IJavaProject getJavaProject(String root) {
        Path path = new Path(root);
        if (path.segmentCount() == 1) {
            return ProjectSetupBuilder.getJavaProjectByName(root);
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        if (resource != null && resource.getType() == 4 && resource.exists()) {
            return (IJavaProject)JavaCore.create((IResource)resource);
        }
        return null;
    }

    private static IJavaProject getJavaProjectByName(String name) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            if (project.exists()) {
                return JavaCore.create((IProject)project);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return null;
    }

    private static final class InternalException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InternalException(String message) {
            super(message);
        }
    }
}

