/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.newproject;

import com.android.sdklib.IAndroidTarget;
import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import org.eclipse.andmore.AndmoreAndroidPlugin;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.wizards.newproject.NewProjectWizardState;
import org.eclipse.andmore.internal.wizards.newproject.ProjectNamePage;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ApplicationInfoPage
extends WizardPage
implements SelectionListener,
ModifyListener,
Sdk.ITargetChangeListener {
    private static final String JDK_15 = "1.5";
    private static final String DUMMY_PACKAGE = "your.package.namespace";
    static final String ACTIVITY_NAME_SUFFIX = "Activity";
    private final NewProjectWizardState mValues;
    private Text mApplicationText;
    private Text mPackageText;
    private Text mActivityText;
    private Button mCreateActivityCheckbox;
    private Combo mSdkCombo;
    private boolean mIgnore;
    private Button mCreateTestCheckbox;
    private Text mTestProjectNameText;
    private Text mTestApplicationText;
    private Text mTestPackageText;
    private Label mTestProjectNameLabel;
    private Label mTestApplicationLabel;
    private Label mTestPackageLabel;

    ApplicationInfoPage(NewProjectWizardState values) {
        super("appInfo");
        this.mValues = values;
        this.setTitle("Application Info");
        this.setDescription("Configure the new Android Project");
        AndmoreAndroidPlugin.getDefault().addTargetListener(this);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label applicationLabel = new Label(container, 0);
        applicationLabel.setText("Application Name:");
        this.mApplicationText = new Text(container, 2048);
        this.mApplicationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mApplicationText.addModifyListener((ModifyListener)this);
        Label packageLabel = new Label(container, 0);
        packageLabel.setText("Package Name:");
        this.mPackageText = new Text(container, 2048);
        this.mPackageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mPackageText.addModifyListener((ModifyListener)this);
        if (this.mValues.mode != NewProjectWizardState.Mode.TEST) {
            this.mCreateActivityCheckbox = new Button(container, 32);
            this.mCreateActivityCheckbox.setText("Create Activity:");
            this.mCreateActivityCheckbox.addSelectionListener((SelectionListener)this);
            this.mActivityText = new Text(container, 2048);
            this.mActivityText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.mActivityText.addModifyListener((ModifyListener)this);
        }
        Label minSdkLabel = new Label(container, 0);
        minSdkLabel.setText("Minimum SDK:");
        this.mSdkCombo = new Combo(container, 0);
        GridData gdSdkCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdSdkCombo.widthHint = 200;
        this.mSdkCombo.setLayoutData((Object)gdSdkCombo);
        this.mSdkCombo.addSelectionListener((SelectionListener)this);
        this.mSdkCombo.addModifyListener((ModifyListener)this);
        this.onSdkLoaded();
        this.setControl((Control)container);
        new Label(container, 0);
        new Label(container, 0);
        this.mCreateTestCheckbox = new Button(container, 32);
        this.mCreateTestCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.mCreateTestCheckbox.setText("Create a Test Project");
        this.mCreateTestCheckbox.addSelectionListener((SelectionListener)this);
        this.mTestProjectNameLabel = new Label(container, 0);
        this.mTestProjectNameLabel.setText("Test Project Name:");
        this.mTestProjectNameText = new Text(container, 2048);
        this.mTestProjectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mTestProjectNameText.addModifyListener((ModifyListener)this);
        this.mTestApplicationLabel = new Label(container, 0);
        this.mTestApplicationLabel.setText("Test Application:");
        this.mTestApplicationText = new Text(container, 2048);
        this.mTestApplicationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mTestApplicationText.addModifyListener((ModifyListener)this);
        this.mTestPackageLabel = new Label(container, 0);
        this.mTestPackageLabel.setText("Test Package:");
        this.mTestPackageText = new Text(container, 2048);
        this.mTestPackageText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.mTestPackageText.addModifyListener((ModifyListener)this);
    }

    private void showTestOptions(boolean visible) {
        if (this.mValues.mode == NewProjectWizardState.Mode.SAMPLE) {
            visible = false;
        }
        this.mCreateTestCheckbox.setVisible(visible);
        this.mTestProjectNameLabel.setVisible(visible);
        this.mTestProjectNameText.setVisible(visible);
        this.mTestApplicationLabel.setVisible(visible);
        this.mTestApplicationText.setVisible(visible);
        this.mTestPackageLabel.setVisible(visible);
        this.mTestPackageText.setVisible(visible);
    }

    private void enableTestOptions(boolean enabled) {
        this.mTestProjectNameLabel.setEnabled(enabled);
        this.mTestProjectNameText.setEnabled(enabled);
        this.mTestApplicationLabel.setEnabled(enabled);
        this.mTestApplicationText.setEnabled(enabled);
        this.mTestPackageLabel.setEnabled(enabled);
        this.mTestPackageText.setEnabled(enabled);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.mIgnore = true;
                if (this.mValues.applicationName != null) {
                    this.mApplicationText.setText(this.mValues.applicationName);
                }
                if (this.mValues.packageName != null) {
                    this.mPackageText.setText(this.mValues.packageName);
                } else {
                    this.mPackageText.setText(DUMMY_PACKAGE);
                }
                if (this.mValues.mode != NewProjectWizardState.Mode.TEST) {
                    this.mCreateActivityCheckbox.setSelection(this.mValues.createActivity);
                    this.mActivityText.setEnabled(this.mValues.createActivity);
                    if (this.mValues.activityName != null) {
                        this.mActivityText.setText(this.mValues.activityName);
                    }
                }
                if (this.mValues.minSdk != null && this.mValues.minSdk.length() > 0) {
                    this.mSdkCombo.setText(this.mValues.minSdk);
                }
                this.showTestOptions(this.mValues.mode == NewProjectWizardState.Mode.ANY);
                this.enableTestOptions(this.mCreateTestCheckbox.getSelection());
                if (this.mValues.testProjectName != null) {
                    this.mTestProjectNameText.setText(this.mValues.testProjectName);
                }
                if (this.mValues.testApplicationName != null) {
                    this.mTestApplicationText.setText(this.mValues.testApplicationName);
                }
                if (this.mValues.testProjectName != null) {
                    this.mTestPackageText.setText(this.mValues.testProjectName);
                }
            }
            finally {
                this.mIgnore = false;
            }
        }
        this.mPackageText.setFocus();
        this.mPackageText.selectAll();
        this.validatePage();
    }

    protected void setSdkTargets(IAndroidTarget[] targets, IAndroidTarget target) {
        if (targets == null) {
            targets = new IAndroidTarget[]{};
        }
        int selectionIndex = -1;
        String[] items = new String[targets.length];
        int i = 0;
        int n = targets.length;
        while (i < n) {
            items[i] = this.targetLabel(targets[i]);
            if (targets[i] == target) {
                selectionIndex = i;
            }
            ++i;
        }
        try {
            this.mIgnore = true;
            this.mSdkCombo.setItems(items);
            this.mSdkCombo.setData((Object)targets);
            if (selectionIndex != -1) {
                this.mSdkCombo.select(selectionIndex);
            }
        }
        finally {
            this.mIgnore = false;
        }
    }

    private String targetLabel(IAndroidTarget target) {
        return String.format("%1$s (%2$s)", target.getVersion().getApiString(), target.getFullName());
    }

    public void dispose() {
        AndmoreAndroidPlugin.getDefault().removeTargetListener(this);
        super.dispose();
    }

    public boolean isPageComplete() {
        if (this.mValues.useExisting || this.mValues.mode != NewProjectWizardState.Mode.ANY) {
            return true;
        }
        if (this.mValues.packageName == null) {
            return false;
        }
        return super.isPageComplete();
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mSdkCombo) {
            int separator;
            IAndroidTarget target;
            this.mValues.minSdk = this.mSdkCombo.getText().trim();
            IAndroidTarget[] targets = (IAndroidTarget[])this.mSdkCombo.getData();
            int index = this.mSdkCombo.getSelectionIndex();
            if (index != -1 && index >= 0 && index < targets.length && this.targetLabel(target = targets[index]).equals(this.mValues.minSdk)) {
                this.mValues.minSdk = target.getVersion().getApiString();
            }
            if ((separator = this.mValues.minSdk.indexOf(32)) != -1) {
                this.mValues.minSdk = this.mValues.minSdk.substring(0, separator);
            }
            this.mValues.minSdkModifiedByUser = true;
            this.mValues.updateSdkTargetToMatchMinSdkVersion();
        } else if (source == this.mApplicationText) {
            this.mValues.applicationName = this.mApplicationText.getText().trim();
            this.mValues.applicationNameModifiedByUser = true;
            if (!this.mValues.testApplicationNameModified) {
                this.mValues.testApplicationName = ApplicationInfoPage.suggestTestApplicationName(this.mValues.applicationName);
                try {
                    this.mIgnore = true;
                    this.mTestApplicationText.setText(this.mValues.testApplicationName);
                }
                finally {
                    this.mIgnore = false;
                }
            }
        } else if (source == this.mPackageText) {
            this.mValues.packageName = this.mPackageText.getText().trim();
            this.mValues.packageNameModifiedByUser = true;
            if (!this.mValues.testPackageModified) {
                this.mValues.testPackageName = ApplicationInfoPage.suggestTestPackage(this.mValues.packageName);
                try {
                    this.mIgnore = true;
                    this.mTestPackageText.setText(this.mValues.testPackageName);
                }
                finally {
                    this.mIgnore = false;
                }
            }
        } else if (source == this.mActivityText) {
            this.mValues.activityName = this.mActivityText.getText().trim();
            this.mValues.activityNameModifiedByUser = true;
        } else if (source == this.mTestApplicationText) {
            this.mValues.testApplicationName = this.mTestApplicationText.getText().trim();
            this.mValues.testApplicationNameModified = true;
        } else if (source == this.mTestPackageText) {
            this.mValues.testPackageName = this.mTestPackageText.getText().trim();
            this.mValues.testPackageModified = true;
        } else if (source == this.mTestProjectNameText) {
            this.mValues.testProjectName = this.mTestProjectNameText.getText().trim();
            this.mValues.testProjectModified = true;
        }
        this.validatePage();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mCreateActivityCheckbox) {
            this.mValues.createActivity = this.mCreateActivityCheckbox.getSelection();
            this.mActivityText.setEnabled(this.mValues.createActivity);
        } else if (source == this.mSdkCombo) {
            int index = this.mSdkCombo.getSelectionIndex();
            IAndroidTarget[] targets = (IAndroidTarget[])this.mSdkCombo.getData();
            if (index != -1) {
                if (index >= 0 && index < targets.length) {
                    IAndroidTarget target = targets[index];
                    this.mValues.minSdk = target.getVersion().getApiString();
                }
            } else {
                String text = this.mSdkCombo.getText();
                boolean found = false;
                IAndroidTarget[] iAndroidTargetArray = targets;
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    IAndroidTarget target = iAndroidTargetArray[n2];
                    if (this.targetLabel(target).equals(text)) {
                        this.mValues.minSdk = target.getVersion().getApiString();
                        found = true;
                        break;
                    }
                    ++n2;
                }
                if (!found) {
                    this.mValues.minSdk = text;
                }
            }
        } else if (source == this.mCreateTestCheckbox) {
            this.mValues.createPairProject = this.mCreateTestCheckbox.getSelection();
            this.enableTestOptions(this.mValues.createPairProject);
            if (this.mValues.createPairProject) {
                if (this.mValues.testProjectName == null || this.mValues.testProjectName.length() == 0) {
                    this.mValues.testProjectName = ApplicationInfoPage.suggestTestProjectName(this.mValues.projectName);
                }
                if (this.mValues.testApplicationName == null || this.mValues.testApplicationName.length() == 0) {
                    this.mValues.testApplicationName = ApplicationInfoPage.suggestTestApplicationName(this.mValues.applicationName);
                }
                if (this.mValues.testPackageName == null || this.mValues.testPackageName.length() == 0) {
                    this.mValues.testPackageName = ApplicationInfoPage.suggestTestPackage(this.mValues.packageName);
                }
                try {
                    this.mIgnore = true;
                    this.mTestProjectNameText.setText(this.mValues.testProjectName);
                    this.mTestApplicationText.setText(this.mValues.testApplicationName);
                    this.mTestPackageText.setText(this.mValues.testPackageName);
                }
                finally {
                    this.mIgnore = false;
                }
            }
        }
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void validatePage() {
        IStatus validSourceFolder;
        IStatus validMinSdk;
        IStatus validActivity;
        IStatus status = ApplicationInfoPage.validatePackage(this.mValues.packageName);
        if ((status == null || status.getSeverity() != 4) && (validActivity = this.validateActivity()) != null) {
            status = validActivity;
        }
        if ((status == null || status.getSeverity() != 4) && (validMinSdk = this.validateMinSdk()) != null) {
            status = validMinSdk;
        }
        if ((status == null || status.getSeverity() != 4) && (validSourceFolder = this.validateSourceFolder()) != null) {
            status = validSourceFolder;
        }
        if ((status == null || status.getSeverity() != 4) && this.mValues.createPairProject) {
            IStatus validTestPackage;
            IStatus validTestLocation;
            IStatus validTestProject = ProjectNamePage.validateProjectName(this.mValues.testProjectName);
            if (validTestProject != null) {
                status = validTestProject;
            }
            if ((status == null || status.getSeverity() != 4) && (validTestLocation = this.validateTestProjectLocation()) != null) {
                status = validTestLocation;
            }
            if ((status == null || status.getSeverity() != 4) && (validTestPackage = ApplicationInfoPage.validatePackage(this.mValues.testPackageName)) != null) {
                status = new Status(validTestPackage.getSeverity(), "org.eclipse.andmore", String.valueOf(validTestPackage.getMessage()) + " (in test package)");
            }
            if ((status == null || status.getSeverity() != 4) && this.mValues.projectName.equals(this.mValues.testProjectName)) {
                status = new Status(4, "org.eclipse.andmore", "The main project name and the test project name must be different.");
            }
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    private IStatus validateTestProjectLocation() {
        assert (this.mValues.createPairProject);
        Path path = new Path(this.mValues.projectLocation.getPath());
        if (!this.mValues.useExisting) {
            if (!this.mValues.useDefaultLocation) {
                String[] l;
                IProject handle;
                URI uri = URIUtil.toURI((String)path.toOSString());
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus locationStatus = workspace.validateProjectLocationURI(handle = workspace.getRoot().getProject(this.mValues.testProjectName), uri);
                if (!locationStatus.isOK()) {
                    return locationStatus;
                }
                File f = path.toFile();
                if (f.exists() && !f.isDirectory()) {
                    return new Status(4, "org.eclipse.andmore", "A directory name must be specified.");
                }
                if (f.isDirectory() && (l = f.list()) != null && l.length != 0) {
                    return new Status(2, "org.eclipse.andmore", "The selected output directory is not empty.");
                }
            } else {
                IPath destPath = path.removeLastSegments(1).append(this.mValues.testProjectName);
                File dest = destPath.toFile();
                if (dest.exists()) {
                    return new Status(4, "org.eclipse.andmore", String.format("There is already a file or directory named \"%1$s\" in the selected location.", this.mValues.testProjectName));
                }
            }
        }
        return null;
    }

    private IStatus validateSourceFolder() {
        this.mValues.sourceFolder = "src";
        if (!this.mValues.useExisting || !this.mValues.createActivity) {
            return null;
        }
        String osTarget = this.mValues.activityName;
        if (osTarget.indexOf(46) == -1) {
            osTarget = String.valueOf(this.mValues.packageName) + File.separator + osTarget;
        } else if (osTarget.indexOf(46) == 0) {
            osTarget = String.valueOf(this.mValues.packageName) + osTarget;
        }
        osTarget = String.valueOf(osTarget.replace('.', File.separatorChar)) + ".java";
        File projectDir = this.mValues.projectLocation;
        File[] allDirs = projectDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (allDirs != null) {
            boolean found = false;
            File[] fileArray = allDirs;
            int n = allDirs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                Path path = new Path(f.getAbsolutePath());
                File java_activity = path.append(osTarget).toFile();
                if (java_activity.isFile()) {
                    this.mValues.sourceFolder = f.getName();
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                String projectPath = projectDir.getPath();
                if (allDirs.length > 0) {
                    return new Status(4, "org.eclipse.andmore", String.format("%1$s can not be found under %2$s.", osTarget, projectPath));
                }
                return new Status(4, "org.eclipse.andmore", String.format("No source folders can be found in %1$s.", projectPath));
            }
        }
        return null;
    }

    private IStatus validateMinSdk() {
        if (this.mValues.minSdk == null || this.mValues.minSdk.length() == 0) {
            return null;
        }
        IAndroidTarget target = this.mValues.target;
        if (target == null) {
            return null;
        }
        if (target.getVersion().isPreview() && !target.getVersion().equals((Object)this.mValues.minSdk)) {
            return new Status(4, "org.eclipse.andmore", String.format("The SDK target is a preview. Min SDK Version must be set to '%s'.", target.getVersion().getCodename()));
        }
        if (!target.getVersion().equals((Object)this.mValues.minSdk)) {
            return new Status(target.getVersion().isPreview() ? 4 : 2, "org.eclipse.andmore", "The API level for the selected SDK target does not match the Min SDK Version.");
        }
        return null;
    }

    public static IStatus validatePackage(String packageFieldContents) {
        if (packageFieldContents == null || packageFieldContents.length() == 0) {
            return new Status(4, "org.eclipse.andmore", "Package name must be specified.");
        }
        if (packageFieldContents.equals(DUMMY_PACKAGE)) {
            return new Status(4, "org.eclipse.andmore", "Package name must be specified.");
        }
        IStatus status = JavaConventions.validatePackageName((String)packageFieldContents, (String)JDK_15, (String)JDK_15);
        if (!status.isOK()) {
            return status;
        }
        if (packageFieldContents.indexOf(46) == -1) {
            return new Status(4, "org.eclipse.andmore", "Package name must have at least two identifiers.");
        }
        return null;
    }

    public static IStatus validateClass(String className) {
        if (className == null || className.length() == 0) {
            return new Status(4, "org.eclipse.andmore", "Class name must be specified.");
        }
        if (className.indexOf(46) != -1) {
            return new Status(4, "org.eclipse.andmore", "Enter just a class name, not a full package name");
        }
        return JavaConventions.validateJavaTypeName((String)className, (String)JDK_15, (String)JDK_15);
    }

    private IStatus validateActivity() {
        if (!this.mValues.createActivity) {
            return null;
        }
        return ApplicationInfoPage.validateActivity(this.mValues.activityName);
    }

    public static IStatus validateActivity(String activityFieldContents) {
        IStatus status;
        if (activityFieldContents == null || activityFieldContents.length() == 0) {
            return new Status(4, "org.eclipse.andmore", "Activity name must be specified.");
        }
        if (ACTIVITY_NAME_SUFFIX.equals(activityFieldContents)) {
            return new Status(4, "org.eclipse.andmore", "Enter a valid activity name");
        }
        if (activityFieldContents.contains("..")) {
            return new Status(4, "org.eclipse.andmore", "Package segments in activity name cannot be empty (..)");
        }
        String packageName = "";
        int pos = activityFieldContents.lastIndexOf(46);
        if (pos >= 0) {
            packageName = activityFieldContents.substring(0, pos);
            if (packageName.startsWith(".")) {
                packageName = packageName.substring(1);
            }
            activityFieldContents = activityFieldContents.substring(pos + 1);
        }
        if (activityFieldContents.length() > 0 && activityFieldContents.charAt(0) == '.') {
            activityFieldContents = activityFieldContents.substring(1);
        }
        if (!(status = JavaConventions.validateTypeVariableName((String)activityFieldContents, (String)JDK_15, (String)JDK_15)).isOK()) {
            return status;
        }
        if (packageName.length() > 0 && !(status = JavaConventions.validatePackageName((String)packageName, (String)JDK_15, (String)JDK_15)).isOK()) {
            return new Status(4, "org.eclipse.andmore", String.valueOf(status.getMessage()) + " (in the activity name)");
        }
        return null;
    }

    @Override
    public void onSdkLoaded() {
        if (this.mSdkCombo == null) {
            return;
        }
        IAndroidTarget[] targets = null;
        if (Sdk.getCurrent() != null) {
            targets = Sdk.getCurrent().getTargets();
        }
        this.setSdkTargets(targets, this.mValues.target);
    }

    @Override
    public void onProjectTargetChange(IProject changedProject) {
    }

    @Override
    public void onTargetLoaded(IAndroidTarget target) {
    }

    public static String suggestTestApplicationName(String applicationName) {
        if (applicationName == null) {
            applicationName = "";
        }
        if (applicationName.indexOf(32) != -1) {
            return String.valueOf(applicationName) + " Test";
        }
        return String.valueOf(applicationName) + "Test";
    }

    public static String suggestTestProjectName(String projectName) {
        if (projectName == null) {
            projectName = "";
        }
        if (projectName.length() > 0 && Character.isUpperCase(projectName.charAt(0))) {
            return String.valueOf(projectName) + "Test";
        }
        return String.valueOf(projectName) + "-test";
    }

    public static String suggestTestPackage(String packagePath) {
        if (packagePath == null) {
            packagePath = "";
        }
        return String.valueOf(packagePath) + ".test";
    }
}

