/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.andmore.internal.wizards.templates;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.andmore.AdtUtils;
import org.eclipse.andmore.internal.editors.IconFactory;
import org.eclipse.andmore.internal.sdk.Sdk;
import org.eclipse.andmore.internal.wizards.newproject.ApplicationInfoPage;
import org.eclipse.andmore.internal.wizards.newproject.ProjectNamePage;
import org.eclipse.andmore.internal.wizards.templates.NewProjectWizardState;
import org.eclipse.andmore.internal.wizards.templates.NewTemplatePage;
import org.eclipse.andmore.internal.wizards.templates.Parameter;
import org.eclipse.andmore.internal.wizards.templates.ProjectContentsPage;
import org.eclipse.andmore.internal.wizards.templates.TemplateMetadata;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewProjectPage
extends WizardPage
implements ModifyListener,
SelectionListener,
FocusListener {
    private static final int FIELD_WIDTH = 300;
    private static final String SAMPLE_PACKAGE_PREFIX = "com.example.";
    static final String ACTIVITY_NAME_SUFFIX = "Activity";
    static final String LAYOUT_NAME_PREFIX = "activity_";
    private static final int INITIAL_MIN_SDK = 8;
    private final NewProjectWizardState mValues;
    private Map<String, Integer> mMinNameToApi;
    private Parameter mThemeParameter;
    private Combo mThemeCombo;
    private Text mProjectText;
    private Text mPackageText;
    private Text mApplicationText;
    private Combo mMinSdkCombo;
    private Combo mTargetSdkCombo;
    private Combo mBuildSdkCombo;
    private Label mHelpIcon;
    private Label mTipLabel;
    private boolean mIgnore;
    private ControlDecoration mApplicationDec;
    private ControlDecoration mProjectDec;
    private ControlDecoration mPackageDec;
    private ControlDecoration mBuildTargetDec;
    private ControlDecoration mMinSdkDec;
    private ControlDecoration mTargetSdkDec;
    private ControlDecoration mThemeDec;

    NewProjectPage(NewProjectWizardState values) {
        super("newAndroidApp");
        this.mValues = values;
        this.setTitle("New Android Application");
        this.setDescription("Creates a new Android Application");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout gl_container = new GridLayout(4, false);
        gl_container.horizontalSpacing = 10;
        container.setLayout((Layout)gl_container);
        Label applicationLabel = new Label(container, 0);
        applicationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        applicationLabel.setText("Application Name:");
        this.mApplicationText = new Text(container, 2048);
        GridData gdApplicationText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gdApplicationText.widthHint = 300;
        this.mApplicationText.setLayoutData((Object)gdApplicationText);
        this.mApplicationText.addModifyListener((ModifyListener)this);
        this.mApplicationText.addFocusListener((FocusListener)this);
        this.mApplicationDec = this.createFieldDecoration((Control)this.mApplicationText, "The application name is shown in the Play Store, as well as in the Manage Application list in Settings.");
        Label projectLabel = new Label(container, 0);
        projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        projectLabel.setText("Project Name:");
        this.mProjectText = new Text(container, 2048);
        GridData gdProjectText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gdProjectText.widthHint = 300;
        this.mProjectText.setLayoutData((Object)gdProjectText);
        this.mProjectText.addModifyListener((ModifyListener)this);
        this.mProjectText.addFocusListener((FocusListener)this);
        this.mProjectDec = this.createFieldDecoration((Control)this.mProjectText, "The project name is only used by Eclipse, but must be unique within the workspace. This can typically be the same as the application name.");
        Label packageLabel = new Label(container, 0);
        packageLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        packageLabel.setText("Package Name:");
        this.mPackageText = new Text(container, 2048);
        GridData gdPackageText = new GridData(16384, 0x1000000, true, false, 2, 1);
        gdPackageText.widthHint = 300;
        this.mPackageText.setLayoutData((Object)gdPackageText);
        this.mPackageText.addModifyListener((ModifyListener)this);
        this.mPackageText.addFocusListener((FocusListener)this);
        this.mPackageDec = this.createFieldDecoration((Control)this.mPackageText, "The package name must be a unique identifier for your application.\nIt is typically not shown to users, but it *must* stay the same for the lifetime of your application; it is how multiple versions of the same application are considered the \"same app\".\nThis is typically the reverse domain name of your organization plus one or more application identifiers, and it must be a valid Java package name.");
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label minSdkLabel = new Label(container, 0);
        minSdkLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        minSdkLabel.setText("Minimum Required SDK:");
        this.mMinSdkCombo = new Combo(container, 8);
        GridData gdMinSdkCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdMinSdkCombo.widthHint = 300;
        this.mMinSdkCombo.setLayoutData((Object)gdMinSdkCombo);
        IAndroidTarget[] targets = this.getCompilationTargets();
        this.mMinNameToApi = Maps.newHashMap();
        ArrayList<String> targetLabels = new ArrayList<String>(targets.length);
        IAndroidTarget[] iAndroidTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget target = iAndroidTargetArray[n2];
            String targetLabel = target.isPlatform() && target.getVersion().getApiLevel() <= AdtUtils.getHighestKnownApiLevel() ? AdtUtils.getAndroidName(target.getVersion().getApiLevel()) : AdtUtils.getTargetLabel(target);
            targetLabels.add(targetLabel);
            this.mMinNameToApi.put(targetLabel, target.getVersion().getApiLevel());
            ++n2;
        }
        ArrayList codeNames = Lists.newArrayList();
        int buildTargetIndex = -1;
        int i = 0;
        int n3 = targets.length;
        while (i < n3) {
            IAndroidTarget target = targets[i];
            AndroidVersion version = target.getVersion();
            int apiLevel = version.getApiLevel();
            if (version.isPreview()) {
                String codeName = version.getCodename();
                String targetLabel = String.valueOf(codeName) + " Preview";
                codeNames.add(targetLabel);
                this.mMinNameToApi.put(targetLabel, apiLevel);
            } else if (target.isPlatform() && (this.mValues.target == null || apiLevel > this.mValues.target.getVersion().getApiLevel())) {
                this.mValues.target = target;
                buildTargetIndex = i;
            }
            ++i;
        }
        ArrayList<String> labels = new ArrayList<String>(24);
        String[] apiLevel = AdtUtils.getKnownVersions();
        int version = apiLevel.length;
        int target = 0;
        while (target < version) {
            String label = apiLevel[target];
            labels.add(label);
            ++target;
        }
        assert (labels.size() >= 15);
        for (String codeName : codeNames) {
            labels.add(codeName);
        }
        String[] versions = labels.toArray(new String[labels.size()]);
        this.mMinSdkCombo.setItems(versions);
        if (this.mValues.target != null && this.mValues.target.getVersion().isPreview()) {
            this.mValues.minSdk = this.mValues.target.getVersion().getCodename();
            this.mMinSdkCombo.setText(this.mValues.minSdk);
            this.mValues.minSdkLevel = this.mValues.iconState.minSdk = this.mValues.target.getVersion().getApiLevel();
        } else {
            this.mMinSdkCombo.select(7);
            this.mValues.minSdk = Integer.toString(8);
            this.mValues.minSdkLevel = 8;
            this.mValues.iconState.minSdk = 8;
        }
        this.mMinSdkCombo.addSelectionListener((SelectionListener)this);
        this.mMinSdkCombo.addFocusListener((FocusListener)this);
        this.mMinSdkDec = this.createFieldDecoration((Control)this.mMinSdkCombo, "Choose the lowest version of Android that your application will support. Lower API levels target more devices, but means fewer features are available. By targeting API 8 and later, you reach approximately 95% of the market.");
        new Label(container, 0);
        Label targetSdkLabel = new Label(container, 0);
        targetSdkLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        targetSdkLabel.setText("Target SDK:");
        this.mTargetSdkCombo = new Combo(container, 8);
        GridData gdTargetSdkCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdTargetSdkCombo.widthHint = 300;
        this.mTargetSdkCombo.setLayoutData((Object)gdTargetSdkCombo);
        this.mTargetSdkCombo.setItems(versions);
        this.mTargetSdkCombo.select(this.mValues.targetSdkLevel - 1);
        this.mTargetSdkCombo.addSelectionListener((SelectionListener)this);
        this.mTargetSdkCombo.addFocusListener((FocusListener)this);
        this.mTargetSdkDec = this.createFieldDecoration((Control)this.mTargetSdkCombo, "Choose the highest API level that the application is known to work with. This attribute informs the system that you have tested against the target version and the system should not enable any compatibility behaviors to maintain your app's forward-compatibility with the target version. The application is still able to run on older versions (down to minSdkVersion). Your application may look dated if you are not targeting the current version.");
        new Label(container, 0);
        Label buildSdkLabel = new Label(container, 0);
        buildSdkLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        buildSdkLabel.setText("Compile With:");
        this.mBuildSdkCombo = new Combo(container, 8);
        GridData gdBuildSdkCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdBuildSdkCombo.widthHint = 300;
        this.mBuildSdkCombo.setLayoutData((Object)gdBuildSdkCombo);
        this.mBuildSdkCombo.setData((Object)targets);
        this.mBuildSdkCombo.setItems(targetLabels.toArray(new String[targetLabels.size()]));
        if (buildTargetIndex != -1) {
            this.mBuildSdkCombo.select(buildTargetIndex);
        }
        this.mBuildSdkCombo.addSelectionListener((SelectionListener)this);
        this.mBuildSdkCombo.addFocusListener((FocusListener)this);
        this.mBuildTargetDec = this.createFieldDecoration((Control)this.mBuildSdkCombo, "Choose a target API to compile your code against, from your installed SDKs. This is typically the most recent version, or the first version that supports all the APIs you want to directly access without reflection.");
        new Label(container, 0);
        TemplateMetadata metadata = this.mValues.template.getTemplate();
        if (metadata != null) {
            this.mThemeParameter = metadata.getParameter("baseTheme");
            if (this.mThemeParameter != null && this.mThemeParameter.element != null) {
                Label themeLabel = new Label(container, 0);
                themeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
                themeLabel.setText("Theme:");
                this.mThemeCombo = NewTemplatePage.createOptionCombo(this.mThemeParameter, container, this.mValues.parameters, this, this);
                GridData gdThemeCombo = new GridData(16384, 0x1000000, true, false, 1, 1);
                gdThemeCombo.widthHint = 300;
                this.mThemeCombo.setLayoutData((Object)gdThemeCombo);
                new Label(container, 0);
                this.mThemeDec = this.createFieldDecoration((Control)this.mThemeCombo, "Choose the base theme to use for the application");
            }
        }
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
        this.mHelpIcon = new Label(container, 0);
        this.mHelpIcon.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        Image icon = IconFactory.getInstance().getIcon("quickfix");
        this.mHelpIcon.setImage(icon);
        this.mHelpIcon.setVisible(false);
        this.mTipLabel = new Label(container, 64);
        this.mTipLabel.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.mTipLabel.setText("\n\n\n\n\n\n");
        Label dummy = new Label(container, 0);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        data.widthHint = 600;
        dummy.setLayoutData((Object)data);
    }

    void updateTheme() {
        if (this.mThemeParameter != null) {
            Parameter parameter = NewTemplatePage.getParameter((Control)this.mThemeCombo);
            assert (parameter == this.mThemeParameter);
            if (parameter != null) {
                String[] optionIds = (String[])this.mThemeCombo.getData("id");
                int index = optionIds.length - 1;
                while (index >= 0) {
                    IStatus status = NewTemplatePage.validateCombo(null, this.mThemeParameter, index, this.mValues.minSdkLevel, this.mValues.getBuildApi());
                    if (status == null || status.isOK()) {
                        String optionId = optionIds[index];
                        parameter.value = optionId;
                        parameter.edited = optionId != null && !optionId.toString().isEmpty();
                        this.mValues.parameters.put(parameter.id, optionId);
                        try {
                            this.mIgnore = true;
                            this.mThemeCombo.select(index);
                            break;
                        }
                        finally {
                            this.mIgnore = false;
                        }
                    }
                    --index;
                }
            }
            this.validatePage();
        }
    }

    private IAndroidTarget[] getCompilationTargets() {
        Sdk current = Sdk.getCurrent();
        if (current == null) {
            return new IAndroidTarget[0];
        }
        IAndroidTarget[] targets = current.getTargets();
        ArrayList<IAndroidTarget> list = new ArrayList<IAndroidTarget>();
        IAndroidTarget[] iAndroidTargetArray = targets;
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            IAndroidTarget target = iAndroidTargetArray[n2];
            if (target.isPlatform() || target.getOptionalLibraries() != null && target.getOptionalLibraries().size() != 0) {
                list.add(target);
            }
            ++n2;
        }
        return list.toArray(new IAndroidTarget[list.size()]);
    }

    private ControlDecoration createFieldDecoration(Control control, String description) {
        ControlDecoration dec = new ControlDecoration(control, 16384);
        dec.setMarginWidth(2);
        FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        dec.setImage(errorFieldIndicator.getImage());
        dec.setDescriptionText(description);
        control.setToolTipText(description);
        return dec;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.validatePage();
    }

    public void modifyText(ModifyEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mProjectText) {
            this.mValues.projectName = this.mProjectText.getText();
            this.updateProjectLocation(this.mValues.projectName);
            this.mValues.projectModified = true;
            try {
                this.mIgnore = true;
                if (!this.mValues.applicationModified) {
                    this.mValues.applicationName = this.mValues.projectName;
                    this.mApplicationText.setText(this.mValues.projectName);
                }
                this.updateActivityNames(this.mValues.projectName);
            }
            finally {
                this.mIgnore = false;
            }
            this.suggestPackage(this.mValues.projectName);
        } else if (source == this.mPackageText) {
            this.mValues.packageName = this.mPackageText.getText();
            this.mValues.packageModified = true;
        } else if (source == this.mApplicationText) {
            this.mValues.applicationName = this.mApplicationText.getText();
            this.mValues.applicationModified = true;
            try {
                this.mIgnore = true;
                if (!this.mValues.projectModified) {
                    this.mValues.projectName = this.appNameToProjectName(this.mValues.applicationName);
                    this.mProjectText.setText(this.mValues.projectName);
                    this.updateProjectLocation(this.mValues.projectName);
                }
                this.updateActivityNames(this.mValues.applicationName);
            }
            finally {
                this.mIgnore = false;
            }
            this.suggestPackage(this.mValues.applicationName);
        }
        this.validatePage();
    }

    private String appNameToProjectName(String appName) {
        boolean upcaseNext = false;
        StringBuilder sb = new StringBuilder(appName.length());
        int i = 0;
        int n = appName.length();
        while (i < n) {
            char c = appName.charAt(i);
            if (c == ' ') {
                upcaseNext = true;
            } else if (upcaseNext) {
                sb.append(Character.toUpperCase(c));
                upcaseNext = false;
            } else {
                sb.append(c);
            }
            ++i;
        }
        appName = sb.toString().trim();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus nameStatus = workspace.validateName(appName, 4);
        if (nameStatus.isOK()) {
            return appName;
        }
        sb = new StringBuilder(appName.length());
        int i2 = 0;
        int n2 = appName.length();
        while (i2 < n2) {
            char c = appName.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '.' || c == '-') {
                sb.append(c);
            }
            ++i2;
        }
        return sb.toString().trim();
    }

    private void updateProjectLocation(String projectName) {
        if (projectName == null) {
            projectName = "";
        }
        if (this.mValues.useDefaultLocation) {
            String projectLocation;
            IPath workspace = Platform.getLocation();
            this.mValues.projectLocation = projectLocation = workspace.append(projectName).toOSString();
        }
    }

    private void updateActivityNames(String name) {
        try {
            this.mIgnore = true;
            if (!this.mValues.activityNameModified) {
                this.mValues.activityName = String.valueOf(AdtUtils.extractClassName(name)) + ACTIVITY_NAME_SUFFIX;
            }
            if (!this.mValues.activityTitleModified) {
                this.mValues.activityTitle = name;
            }
        }
        finally {
            this.mIgnore = false;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.mIgnore) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mMinSdkCombo) {
            this.mValues.minSdk = this.getSelectedMinSdk();
            Integer minSdk = this.mMinNameToApi.get(this.mValues.minSdk);
            if (minSdk == null) {
                try {
                    minSdk = Integer.parseInt(this.mValues.minSdk);
                }
                catch (NumberFormatException numberFormatException) {
                    minSdk = 24;
                }
            }
            this.mValues.iconState.minSdk = minSdk;
            this.mValues.minSdkLevel = minSdk;
            if (this.mValues.minSdkLevel > this.mValues.getBuildApi()) {
                IAndroidTarget[] targets = (IAndroidTarget[])this.mBuildSdkCombo.getData();
                IAndroidTarget best = null;
                int bestApi = Integer.MAX_VALUE;
                int bestTargetIndex = -1;
                int i = 0;
                while (i < targets.length) {
                    int api;
                    IAndroidTarget target = targets[i];
                    if (target.isPlatform() && (api = target.getVersion().getApiLevel()) >= this.mValues.minSdkLevel && api < bestApi) {
                        best = target;
                        bestApi = api;
                        bestTargetIndex = i;
                    }
                    ++i;
                }
                if (best != null) {
                    assert (bestTargetIndex != -1);
                    this.mValues.target = best;
                    try {
                        this.mIgnore = true;
                        this.mBuildSdkCombo.select(bestTargetIndex);
                    }
                    finally {
                        this.mIgnore = false;
                    }
                }
            }
            if (this.mValues.minSdkLevel > this.mValues.targetSdkLevel) {
                this.mValues.targetSdkLevel = this.mValues.minSdkLevel;
                try {
                    this.mIgnore = true;
                    this.setSelectedTargetSdk(this.mValues.targetSdkLevel);
                }
                finally {
                    this.mIgnore = false;
                }
            }
        } else if (source == this.mBuildSdkCombo) {
            this.mValues.target = this.getSelectedBuildTarget();
            if (this.mValues.target.getVersion().isPreview()) {
                this.mValues.minSdk = this.mValues.target.getVersion().getCodename();
                try {
                    this.mIgnore = true;
                    this.mMinSdkCombo.setText(this.mValues.minSdk);
                }
                finally {
                    this.mIgnore = false;
                }
            } else {
                String minSdk = this.mValues.minSdk;
                int buildApiLevel = this.mValues.target.getVersion().getApiLevel();
                if (minSdk != null && !minSdk.isEmpty() && Character.isDigit(minSdk.charAt(0)) && buildApiLevel < Integer.parseInt(minSdk)) {
                    this.mValues.minSdk = Integer.toString(buildApiLevel);
                    try {
                        this.mIgnore = true;
                        this.setSelectedMinSdk(buildApiLevel);
                    }
                    finally {
                        this.mIgnore = false;
                    }
                }
            }
        } else if (source == this.mTargetSdkCombo) {
            this.mValues.targetSdkLevel = this.getSelectedTargetSdk();
        }
        this.validatePage();
    }

    private String getSelectedMinSdk() {
        IAndroidTarget buildTarget = this.getSelectedBuildTarget();
        if (buildTarget != null && buildTarget.getVersion().isPreview()) {
            return buildTarget.getVersion().getCodename();
        }
        return Integer.toString(this.mMinSdkCombo.getSelectionIndex() + 1);
    }

    private int getSelectedTargetSdk() {
        return this.mTargetSdkCombo.getSelectionIndex() + 1;
    }

    private void setSelectedMinSdk(int api) {
        this.mMinSdkCombo.select(api - 1);
    }

    private void setSelectedTargetSdk(int api) {
        this.mTargetSdkCombo.select(api - 1);
    }

    private IAndroidTarget getSelectedBuildTarget() {
        IAndroidTarget[] targets = (IAndroidTarget[])this.mBuildSdkCombo.getData();
        int index = this.mBuildSdkCombo.getSelectionIndex();
        if (index >= 0 && index < targets.length) {
            return targets[index];
        }
        return null;
    }

    private void suggestPackage(String original) {
        if (!this.mValues.packageModified) {
            StringBuilder sb = new StringBuilder();
            sb.append(SAMPLE_PACKAGE_PREFIX);
            NewProjectPage.appendPackage(sb, original);
            String pkg = sb.toString();
            if (pkg.endsWith(".")) {
                pkg = pkg.substring(0, pkg.length() - 1);
            }
            this.mValues.packageName = pkg;
            try {
                this.mIgnore = true;
                this.mPackageText.setText(this.mValues.packageName);
            }
            finally {
                this.mIgnore = false;
            }
        }
    }

    private static void appendPackage(StringBuilder sb, String string) {
        int i = 0;
        int n = string.length();
        while (i < n) {
            char c = string.charAt(i);
            if (i == 0 && Character.isJavaIdentifierStart(c) || i != 0 && Character.isJavaIdentifierPart(c)) {
                sb.append(Character.toLowerCase(c));
            } else if (c == '.' && sb.length() > 0 && sb.charAt(sb.length() - 1) != '.') {
                sb.append('.');
            } else if (c == '-') {
                sb.append('_');
            }
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        String tip = "";
        if (source == this.mApplicationText) {
            tip = this.mApplicationDec.getDescriptionText();
        } else if (source == this.mProjectText) {
            tip = this.mProjectDec.getDescriptionText();
        } else if (source == this.mBuildSdkCombo) {
            tip = this.mBuildTargetDec.getDescriptionText();
        } else if (source == this.mMinSdkCombo) {
            tip = this.mMinSdkDec.getDescriptionText();
        } else if (source == this.mPackageText) {
            tip = this.mPackageDec.getDescriptionText();
            if (this.mPackageText.getText().startsWith(SAMPLE_PACKAGE_PREFIX)) {
                int length = SAMPLE_PACKAGE_PREFIX.length();
                if (this.mPackageText.getText().length() > length && SAMPLE_PACKAGE_PREFIX.endsWith(".")) {
                    --length;
                }
                this.mPackageText.setSelection(0, length);
            }
        } else if (source == this.mTargetSdkCombo) {
            tip = this.mTargetSdkDec.getDescriptionText();
        } else if (source == this.mThemeCombo) {
            tip = this.mThemeDec.getDescriptionText();
        }
        this.mTipLabel.setText(tip);
        this.mHelpIcon.setVisible(tip.length() > 0);
    }

    public void focusLost(FocusEvent e) {
        this.mTipLabel.setText("");
        this.mHelpIcon.setVisible(false);
    }

    private void validatePage() {
        IStatus status = this.mValues.template.validateTemplate(this.mValues.minSdkLevel, this.mValues.getBuildApi());
        if (status != null && !status.isOK()) {
            this.updateDecorator(this.mApplicationDec, null, true);
            this.updateDecorator(this.mPackageDec, null, true);
            this.updateDecorator(this.mProjectDec, null, true);
            this.updateDecorator(this.mThemeDec, null, true);
        } else {
            IStatus themeStatus;
            IStatus locationStatus;
            IStatus packageStatus;
            IStatus projectStatus;
            IStatus appStatus = this.validateAppName();
            if (appStatus != null && (status == null || appStatus.getSeverity() > status.getSeverity())) {
                status = appStatus;
            }
            if ((projectStatus = this.validateProjectName()) != null && (status == null || projectStatus.getSeverity() > status.getSeverity())) {
                status = projectStatus;
            }
            if ((packageStatus = this.validatePackageName()) != null && (status == null || packageStatus.getSeverity() > status.getSeverity())) {
                status = packageStatus;
            }
            if ((locationStatus = ProjectContentsPage.validateLocationInWorkspace(this.mValues)) != null && (status == null || locationStatus.getSeverity() > status.getSeverity())) {
                status = locationStatus;
            }
            if ((status == null || status.getSeverity() != 4) && this.mValues.target == null) {
                status = new Status(2, "org.eclipse.andmore", "Select an Android build target version");
            }
            if (status == null || status.getSeverity() != 4) {
                if (this.mValues.minSdk == null || this.mValues.minSdk.isEmpty()) {
                    status = new Status(2, "org.eclipse.andmore", "Select a minimum SDK version");
                } else {
                    AndroidVersion version = this.mValues.target.getVersion();
                    if (version.isPreview()) {
                        if (!version.getCodename().equals(this.mValues.minSdk)) {
                            status = new Status(4, "org.eclipse.andmore", "Preview platforms require the min SDK version to match their codenames.");
                        }
                    } else if (this.mValues.target.getVersion().compareTo(this.mValues.minSdkLevel, version.isPreview() ? this.mValues.minSdk : null) < 0) {
                        status = new Status(2, "org.eclipse.andmore", "The minimum SDK version is higher than the build target version");
                    }
                    if ((status == null || status.getSeverity() != 4) && this.mValues.targetSdkLevel < this.mValues.minSdkLevel) {
                        status = new Status(4, "org.eclipse.andmore", "The target SDK version should be at least as high as the minimum SDK version");
                    }
                }
            }
            if ((themeStatus = this.validateTheme()) != null && (status == null || themeStatus.getSeverity() > status.getSeverity())) {
                status = themeStatus;
            }
        }
        this.setPageComplete(status == null || status.getSeverity() != 4);
        if (status != null) {
            this.setMessage(status.getMessage(), status.getSeverity() == 4 ? 3 : 2);
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    private IStatus validateAppName() {
        String appName = this.mValues.applicationName;
        Status status = null;
        if (appName == null || appName.isEmpty()) {
            status = new Status(4, "org.eclipse.andmore", "Enter an application name (shown in launcher)");
        } else if (Character.isLowerCase(this.mValues.applicationName.charAt(0))) {
            status = new Status(2, "org.eclipse.andmore", "The application name for most apps begins with an uppercase letter");
        }
        this.updateDecorator(this.mApplicationDec, (IStatus)status, true);
        return status;
    }

    private IStatus validateProjectName() {
        IStatus status = ProjectNamePage.validateProjectName(this.mValues.projectName);
        this.updateDecorator(this.mProjectDec, status, true);
        return status;
    }

    private IStatus validatePackageName() {
        IStatus status;
        if (this.mValues.packageName == null || this.mValues.packageName.startsWith(SAMPLE_PACKAGE_PREFIX)) {
            if (this.mValues.packageName != null && !this.mValues.packageName.equals(SAMPLE_PACKAGE_PREFIX)) {
                status = ApplicationInfoPage.validatePackage(this.mValues.packageName);
                if (status == null || status.isOK()) {
                    status = new Status(2, "org.eclipse.andmore", String.format("The prefix '%1$s' is meant as a placeholder and should not be used", SAMPLE_PACKAGE_PREFIX));
                }
            } else {
                status = new Status(4, "org.eclipse.andmore", "Package name must be specified.");
            }
        } else {
            status = ApplicationInfoPage.validatePackage(this.mValues.packageName);
        }
        this.updateDecorator(this.mPackageDec, status, true);
        return status;
    }

    private IStatus validateTheme() {
        IStatus status = null;
        if (this.mThemeParameter != null) {
            status = NewTemplatePage.validateCombo(null, this.mThemeParameter, this.mThemeCombo.getSelectionIndex(), this.mValues.minSdkLevel, this.mValues.getBuildApi());
            this.updateDecorator(this.mThemeDec, status, true);
        }
        return status;
    }

    private void updateDecorator(ControlDecoration decorator, IStatus status, boolean hasInfo) {
        if (hasInfo) {
            int severity = status != null ? status.getSeverity() : 0;
            this.setDecoratorType(decorator, severity);
        } else if (status == null || status.isOK()) {
            decorator.hide();
        } else {
            decorator.show();
        }
    }

    private void setDecoratorType(ControlDecoration decorator, int severity) {
        String id = severity == 4 ? "DEC_ERROR" : (severity == 2 ? "DEC_WARNING" : "DEC_INFORMATION");
        FieldDecoration errorFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration(id);
        decorator.setImage(errorFieldIndicator.getImage());
    }
}

